/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservices.integration.security;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ResourceBundle;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.RealmMapping;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.wsf.spi.security.SecurityDomainContext;

public final class SecurityDomainContextAdaptor
implements SecurityDomainContext {
    private static final ResourceBundle bundle = BundleUtils.getBundle(SecurityDomainContextAdaptor.class);
    private AuthenticationManager authenticationManager;
    private RealmMapping realmMapping;

    private void setupAuthenticationManager() {
        if (this.authenticationManager == null) {
            try {
                InitialContext ctx = new InitialContext();
                Object obj = ctx.lookup("java:comp/env/security/securityMgr");
                this.authenticationManager = (AuthenticationManager)obj;
                this.realmMapping = (RealmMapping)this.authenticationManager;
            }
            catch (NamingException ne) {
                throw new RuntimeException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNABLE_TO_LOOKUP_AUTHENTICATIONMANAGER", (Object[])new Object[0]), ne);
            }
        }
    }

    public boolean isValid(Principal principal, Object credential, Subject activeSubject) {
        this.setupAuthenticationManager();
        return this.authenticationManager.isValid(principal, credential, activeSubject);
    }

    public boolean doesUserHaveRole(Principal principal, Set<Principal> roles) {
        this.setupAuthenticationManager();
        return this.realmMapping.doesUserHaveRole(principal, roles);
    }

    public String getSecurityDomain() {
        this.setupAuthenticationManager();
        return this.authenticationManager.getSecurityDomain();
    }

    public Set<Principal> getUserRoles(Principal principal) {
        this.setupAuthenticationManager();
        return this.realmMapping.getUserRoles(principal);
    }

    public void pushSubjectContext(final Subject subject, final Principal principal, final Object credential) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecurityContext securityContext = SecurityContextAssociation.getSecurityContext();
                if (securityContext == null) {
                    throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"SECURITY_CONTEXT_IS_NULL", (Object[])new Object[0]));
                }
                securityContext.getUtil().createSubjectInfo(principal, credential, subject);
                return null;
            }
        });
    }
}

