/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservices.integration.deployers;

import java.util.Set;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.webservices.integration.deployers.SecurityActions;
import org.jboss.webservices.integration.util.ASHelper;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;

final class WSDeploymentAspectDeployer
extends AbstractRealDeployer {
    private static final String JBOSSWS_ATTACHMENT_PREFIX = "jbossws.";
    private static final String JBOSSWS_METADATA = "jbossws.metadata";
    private final DeploymentAspect aspect;

    WSDeploymentAspectDeployer(DeploymentAspect aspect) {
        this.addInput(JBossWebMetaData.class);
        this.addInput(Deployment.class);
        if (aspect.isLast()) {
            this.addInput(JBOSSWS_METADATA);
        }
        Set inputs = aspect.getRequiresAsSet();
        for (String input : inputs) {
            this.addInput(JBOSSWS_ATTACHMENT_PREFIX + input);
        }
        this.addOutput(JBossWebMetaData.class);
        if (!aspect.isLast()) {
            this.addOutput(JBOSSWS_METADATA);
        }
        Set outputs = aspect.getProvidesAsSet();
        for (String output : outputs) {
            this.addOutput(JBOSSWS_ATTACHMENT_PREFIX + output);
        }
        this.setRelativeOrder(aspect.getRelativeOrder());
        this.aspect = aspect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalDeploy(DeploymentUnit unit) throws DeploymentException {
        if (ASHelper.isWebServiceDeployment(unit)) {
            this.log.debug((Object)(this.aspect + " start: " + unit.getName()));
            Deployment dep = ASHelper.getRequiredAttachment(unit, Deployment.class);
            if (this.aspect.canHandle(dep)) {
                ClassLoader deployerClassLoader = SecurityActions.getContextClassLoader();
                try {
                    SecurityActions.setContextClassLoader(this.aspect.getLoader());
                    this.aspect.start(dep);
                }
                finally {
                    SecurityActions.setContextClassLoader(deployerClassLoader);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalUndeploy(DeploymentUnit unit) {
        if (ASHelper.isWebServiceDeployment(unit)) {
            this.log.debug((Object)(this.aspect + " stop: " + unit.getName()));
            Deployment dep = ASHelper.getRequiredAttachment(unit, Deployment.class);
            if (this.aspect.canHandle(dep)) {
                ClassLoader deployerClassLoader = SecurityActions.getContextClassLoader();
                try {
                    SecurityActions.setContextClassLoader(this.aspect.getLoader());
                    this.aspect.stop(dep);
                }
                finally {
                    SecurityActions.setContextClassLoader(deployerClassLoader);
                }
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append('(').append(this.aspect).append(')');
        return sb.toString();
    }
}

