/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers.deployment;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.webservices.deployers.deployment.DeploymentModelBuilder;
import org.jboss.as.webservices.deployers.deployment.WSVirtualFileFilter;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.VirtualFileAdaptor;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentModelFactory;
import org.jboss.wsf.spi.deployment.DeploymentType;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.EndpointType;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;

abstract class AbstractDeploymentModelBuilder
implements DeploymentModelBuilder {
    private static final WSVirtualFileFilter WS_FILE_FILTER = new WSVirtualFileFilter();
    protected final Logger log = Logger.getLogger(this.getClass());
    private final DeploymentModelFactory deploymentModelFactory;
    private final DeploymentType deploymentType;
    private final EndpointType endpointType;

    protected AbstractDeploymentModelBuilder(DeploymentType deploymentType, EndpointType endpointType) {
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        this.deploymentModelFactory = (DeploymentModelFactory)spiProvider.getSPI(DeploymentModelFactory.class);
        this.deploymentType = deploymentType;
        this.endpointType = endpointType;
    }

    @Override
    public final void newDeploymentModel(DeploymentUnit unit) {
        ArchiveDeployment dep;
        if (unit.hasAttachment(WSAttachmentKeys.DEPLOYMENT_KEY)) {
            dep = (ArchiveDeployment)unit.getAttachment(WSAttachmentKeys.DEPLOYMENT_KEY);
        } else {
            try {
                dep = this.newDeployment(unit);
            }
            catch (DeploymentUnitProcessingException e) {
                throw new RuntimeException(e);
            }
            dep.addAttachment(DeploymentUnit.class, (Object)unit);
            unit.putAttachment(WSAttachmentKeys.DEPLOYMENT_KEY, (Object)dep);
        }
        WebservicesMetaData wsMetaData = ASHelper.getOptionalAttachment(unit, WSAttachmentKeys.WEBSERVICES_METADATA_KEY);
        if (wsMetaData != null) {
            dep.addAttachment(WebservicesMetaData.class, (Object)wsMetaData);
        }
        this.build((Deployment)dep, unit);
    }

    protected abstract void build(Deployment var1, DeploymentUnit var2);

    protected final Endpoint newHttpEndpoint(String endpointClass, String endpointName, Deployment dep) {
        if (endpointName == null) {
            throw new NullPointerException("Null endpoint name");
        }
        if (endpointClass == null) {
            throw new NullPointerException("Null endpoint class");
        }
        Endpoint endpoint = this.deploymentModelFactory.newHttpEndpoint(endpointClass);
        endpoint.setShortName(endpointName);
        endpoint.setType(this.endpointType);
        dep.getService().addEndpoint(endpoint);
        return endpoint;
    }

    protected final Endpoint newJMSEndpoint(String endpointClass, String endpointName, String soapAddress, Deployment dep) {
        if (endpointName == null) {
            throw new NullPointerException("Null endpoint name");
        }
        if (endpointClass == null) {
            throw new NullPointerException("Null endpoint class");
        }
        Endpoint endpoint = this.deploymentModelFactory.newJMSEndpoint(endpointClass);
        endpoint.setAddress(soapAddress);
        endpoint.setShortName(endpointName);
        endpoint.setType(this.endpointType);
        dep.getService().addEndpoint(endpoint);
        return endpoint;
    }

    private ArchiveDeployment newDeployment(DeploymentUnit unit) throws DeploymentUnitProcessingException {
        this.log.debug((Object)("Creating new WS deployment model for: " + unit));
        ResourceRoot deploymentRoot = (ResourceRoot)unit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        VirtualFile root = deploymentRoot.getRoot();
        Module module = (Module)unit.getAttachment(Attachments.MODULE);
        if (module == null) {
            throw new DeploymentUnitProcessingException("failed to resolve module for deployment " + deploymentRoot);
        }
        ModuleClassLoader classLoader = module.getClassLoader();
        ArchiveDeployment dep = this.newDeployment(unit.getName(), (ClassLoader)classLoader);
        try {
            List virtualFiles = root.getChildrenRecursively((VirtualFileFilter)WS_FILE_FILTER);
            HashSet<VirtualFileAdaptor> uVirtualFiles = new HashSet<VirtualFileAdaptor>();
            for (VirtualFile vf : virtualFiles) {
                uVirtualFiles.add(new VirtualFileAdaptor(vf));
            }
            dep.setMetadataFiles(new LinkedList(uVirtualFiles));
        }
        catch (IOException e) {
            this.log.warn((Object)("Could not load metadata files for deployment root " + root), (Throwable)e);
        }
        if (unit.getParent() != null) {
            String parentDeploymentName = unit.getParent().getName();
            Module parentModule = (Module)unit.getParent().getAttachment(Attachments.MODULE);
            if (parentModule == null) {
                throw new DeploymentUnitProcessingException("failed to resolve module for parent of deployment " + deploymentRoot);
            }
            ModuleClassLoader parentClassLoader = parentModule.getClassLoader();
            this.log.debug((Object)("Creating new WS deployment model for parent: " + unit.getParent()));
            ArchiveDeployment parentDep = this.newDeployment(parentDeploymentName, (ClassLoader)parentClassLoader);
            dep.setParent(parentDep);
        }
        dep.setRootFile((UnifiedVirtualFile)new VirtualFileAdaptor(root));
        dep.setRuntimeClassLoader((ClassLoader)classLoader);
        dep.setType(this.deploymentType);
        return dep;
    }

    private ArchiveDeployment newDeployment(String name, ClassLoader loader) {
        return (ArchiveDeployment)this.deploymentModelFactory.newDeployment(name, loader);
    }

    protected final <A> A getAndPropagateAttachment(AttachmentKey<A> attachment, Class<?> attachmentClass, DeploymentUnit unit, Deployment dep) {
        A attachmentValue = ASHelper.getOptionalAttachment(unit, attachment);
        if (attachmentValue != null) {
            dep.addAttachment(attachmentClass, attachmentValue);
            return attachmentValue;
        }
        throw new IllegalStateException("Deployment unit does not contain " + attachment);
    }
}

