/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.tomcat;

import javax.annotation.security.RolesAllowed;
import org.jboss.as.webservices.metadata.WebServiceDeclaration;
import org.jboss.as.webservices.metadata.WebServiceDeployment;
import org.jboss.as.webservices.tomcat.AbstractSecurityMetaDataAccessorEJB;
import org.jboss.ejb3.annotation.SecurityDomain;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.metadata.javaee.spec.SecurityRoleMetaData;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.ws.api.annotation.WebContext;
import org.jboss.ws.common.integration.WSHelper;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;

final class SecurityMetaDataAccessorEJB3
extends AbstractSecurityMetaDataAccessorEJB {
    private static final DotName ROLES_ALLOWED_DOT_NAME = DotName.createSimple((String)RolesAllowed.class.getName());
    private static final DotName SECURITY_DOMAIN_DOT_NAME = DotName.createSimple((String)SecurityDomain.class.getName());

    SecurityMetaDataAccessorEJB3() {
    }

    @Override
    public String getSecurityDomain(Deployment dep) {
        WebServiceDeployment wsDeployment = (WebServiceDeployment)WSHelper.getRequiredAttachment((Deployment)dep, WebServiceDeployment.class);
        String securityDomain = null;
        for (WebServiceDeclaration ejbContainer : wsDeployment.getServiceEndpoints()) {
            AnnotationInstance nextSecurityDomain = ejbContainer.getAnnotation(SECURITY_DOMAIN_DOT_NAME);
            securityDomain = this.getDomain(securityDomain, nextSecurityDomain);
        }
        return securityDomain;
    }

    @Override
    public SecurityRolesMetaData getSecurityRoles(Deployment dep) {
        WebServiceDeployment wsDeployment = (WebServiceDeployment)WSHelper.getRequiredAttachment((Deployment)dep, WebServiceDeployment.class);
        SecurityRolesMetaData securityRolesMD = new SecurityRolesMetaData();
        for (WebServiceDeclaration ejbContainer : wsDeployment.getServiceEndpoints()) {
            AnnotationInstance allowedRoles = ejbContainer.getAnnotation(ROLES_ALLOWED_DOT_NAME);
            boolean hasAllowedRoles = allowedRoles != null;
            if (!hasAllowedRoles) continue;
            for (String roleName : allowedRoles.value().asStringArray()) {
                SecurityRoleMetaData securityRoleMD = new SecurityRoleMetaData();
                securityRoleMD.setRoleName(roleName);
                securityRolesMD.add((MappableMetaData)securityRoleMD);
            }
        }
        return securityRolesMD;
    }

    @Override
    public String getAuthMethod(Endpoint endpoint) {
        WebContext webContext = this.getWebContextAnnotation(endpoint);
        boolean hasAuthMethod = webContext != null && webContext.authMethod().length() > 0;
        return hasAuthMethod ? webContext.authMethod() : super.getAuthMethod(endpoint);
    }

    @Override
    public boolean isSecureWsdlAccess(Endpoint endpoint) {
        WebContext webContext = this.getWebContextAnnotation(endpoint);
        boolean hasSecureWsdlAccess = webContext != null && webContext.secureWSDLAccess();
        return hasSecureWsdlAccess ? true : super.isSecureWsdlAccess(endpoint);
    }

    @Override
    public String getTransportGuarantee(Endpoint endpoint) {
        WebContext webContext = this.getWebContextAnnotation(endpoint);
        boolean hasTransportGuarantee = webContext != null && webContext.transportGuarantee().length() > 0;
        return hasTransportGuarantee ? webContext.transportGuarantee() : super.getTransportGuarantee(endpoint);
    }

    private WebContext getWebContextAnnotation(Endpoint endpoint) {
        return endpoint.getTargetBeanClass().getAnnotation(WebContext.class);
    }

    private String getDomain(String oldSecurityDomain, AnnotationInstance nextSecurityDomain) {
        if (nextSecurityDomain == null) {
            return oldSecurityDomain;
        }
        if (oldSecurityDomain == null) {
            return nextSecurityDomain.value().asString();
        }
        this.ensureSameDomains(oldSecurityDomain, nextSecurityDomain.value().asString());
        return oldSecurityDomain;
    }

    private void ensureSameDomains(String oldSecurityDomain, String newSecurityDomain) {
        boolean domainsDiffer;
        boolean bl = domainsDiffer = !oldSecurityDomain.equals(newSecurityDomain);
        if (domainsDiffer) {
            String errorMessage = "Multiple security domains not supported. ";
            String firstDomain = "First domain: '" + oldSecurityDomain + "' ";
            String secondDomain = "second domain: '" + newSecurityDomain + "'";
            throw new IllegalStateException("Multiple security domains not supported. " + firstDomain + secondDomain);
        }
    }
}

