/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.invocation;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.component.ComponentViewInstance;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.invocation.InterceptorContext;
import org.jboss.msc.service.ServiceName;
import org.jboss.ws.common.injection.ThreadLocalAwareWebServiceContext;
import org.jboss.ws.common.invocation.AbstractInvocationHandler;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.Invocation;
import org.jboss.wsf.spi.invocation.InvocationContext;

final class InvocationHandlerEJB3
extends AbstractInvocationHandler {
    private static final String EJB3_JNDI_PREFIX = "java:env/";
    private String ejbName;
    private volatile ComponentViewInstance ejbComponentViewInstance;

    InvocationHandlerEJB3() {
    }

    public void init(Endpoint endpoint) {
        this.ejbName = (String)endpoint.getProperty("org.jboss.wsf.spi.invocation.ContainerName");
        if (this.ejbName == null) {
            throw new IllegalArgumentException("Container name cannot be null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComponentViewInstance getComponentViewInstance() {
        if (this.ejbComponentViewInstance == null) {
            InvocationHandlerEJB3 invocationHandlerEJB3 = this;
            synchronized (invocationHandlerEJB3) {
                if (this.ejbComponentViewInstance == null) {
                    ComponentView ejbView = ASHelper.getMSCService(ServiceName.parse((String)this.ejbName), ComponentView.class);
                    if (ejbView == null) {
                        throw new WebServiceException("Cannot find ejb: " + this.ejbName);
                    }
                    this.ejbComponentViewInstance = ejbView.createInstance();
                }
            }
        }
        return this.ejbComponentViewInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Endpoint endpoint, Invocation wsInvocation) throws Exception {
        try {
            this.onBeforeInvocation(wsInvocation);
            ComponentViewInstance componentViewInstance = this.getComponentViewInstance();
            Method method = this.getEJBMethod(wsInvocation.getJavaMethod(), componentViewInstance.allowedMethods());
            InterceptorContext context = new InterceptorContext();
            context.setMethod(method);
            context.setContextData((Map)this.getWebServiceContext(wsInvocation).getMessageContext());
            context.setParameters(wsInvocation.getArgs());
            context.setTarget(componentViewInstance.createProxy());
            context.putPrivateData(Component.class, (Object)componentViewInstance.getComponent());
            context.putPrivateData(ComponentViewInstance.class, (Object)componentViewInstance);
            Object retObj = componentViewInstance.getEntryPoint(method).processInvocation(context);
            wsInvocation.setReturnValue(retObj);
        }
        catch (Throwable t) {
            this.log.error((Object)("Method invocation failed with exception: " + t.getMessage()), t);
            this.handleInvocationException(t);
        }
        finally {
            this.onAfterInvocation(wsInvocation);
        }
    }

    private Method getEJBMethod(Method seiMethod, Collection<Method> methods) {
        for (Method method : methods) {
            if (!seiMethod.equals(method)) continue;
            return method;
        }
        throw new IllegalStateException();
    }

    public void onBeforeInvocation(Invocation invocation) {
        WebServiceContext wsContext = this.getWebServiceContext(invocation);
        ThreadLocalAwareWebServiceContext.getInstance().setMessageContext(wsContext);
    }

    public void onAfterInvocation(Invocation invocation) {
        ThreadLocalAwareWebServiceContext.getInstance().setMessageContext(null);
    }

    private WebServiceContext getWebServiceContext(Invocation invocation) {
        InvocationContext invocationContext = invocation.getInvocationContext();
        return (WebServiceContext)invocationContext.getAttachment(WebServiceContext.class);
    }
}

