/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import java.util.LinkedList;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.webservices.WSMessages;
import org.jboss.as.webservices.dmr.Attributes;
import org.jboss.as.webservices.dmr.PackageUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.metadata.config.CommonConfig;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;

final class HandlerChainAdd
extends AbstractAddStepHandler {
    static final HandlerChainAdd INSTANCE = new HandlerChainAdd();

    private HandlerChainAdd() {
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, ModelNode model, List<ServiceController<?>> controllers) {
        super.rollbackRuntime(context, operation, model, controllers);
        if (!context.isBooting()) {
            context.revertReloadRequired();
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServerConfig config = PackageUtils.getServerConfig(context);
        if (config != null) {
            String protocolBindings = HandlerChainAdd.getAttributeValue(operation, "protocol-bindings");
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            PathElement confElem = address.getElement(address.size() - 2);
            String configType = confElem.getKey();
            String configName = confElem.getValue();
            String handlerChainType = address.getElement(address.size() - 1).getKey();
            String handlerChainId = address.getElement(address.size() - 1).getValue();
            for (CommonConfig commonConfig : PackageUtils.getConfigs(config, configType)) {
                UnifiedHandlerChainMetaData handlerChain;
                List<Object> handlerChains;
                if (!configName.equals(commonConfig.getConfigName())) continue;
                if ("pre-handler-chain".equals(handlerChainType)) {
                    handlerChains = commonConfig.getPreHandlerChains();
                    if (handlerChains == null) {
                        handlerChains = new LinkedList<UnifiedHandlerChainMetaData>();
                        commonConfig.setPreHandlerChains(handlerChains);
                    }
                } else if ("post-handler-chain".equals(handlerChainType)) {
                    handlerChains = commonConfig.getPostHandlerChains();
                    if (handlerChains == null) {
                        handlerChains = new LinkedList();
                        commonConfig.setPostHandlerChains(handlerChains);
                    }
                } else {
                    throw WSMessages.MESSAGES.wrongHandlerChainType(handlerChainType, "pre-handler-chain", "post-handler-chain");
                }
                if ((handlerChain = HandlerChainAdd.getChain((List<UnifiedHandlerChainMetaData>)handlerChains, handlerChainId)) != null) {
                    throw WSMessages.MESSAGES.multipleHandlerChainsWithSameId(handlerChainType, handlerChainId, configName);
                }
                handlerChain = new UnifiedHandlerChainMetaData();
                handlerChain.setId(handlerChainId);
                handlerChain.setProtocolBindings(protocolBindings);
                handlerChains.add(handlerChain);
                if (!context.isBooting()) {
                    context.reloadRequired();
                }
                return;
            }
            throw WSMessages.MESSAGES.missingConfig(configName);
        }
    }

    private static UnifiedHandlerChainMetaData getChain(List<UnifiedHandlerChainMetaData> handlerChains, String handlerChainId) {
        for (UnifiedHandlerChainMetaData handlerChain : handlerChains) {
            if (!handlerChainId.equals(handlerChain.getId())) continue;
            return handlerChain;
        }
        return null;
    }

    private static String getAttributeValue(ModelNode node, String propertyName) {
        return node.hasDefined(propertyName) ? node.get(propertyName).asString() : null;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        Attributes.PROTOCOL_BINDINGS.validateAndSet(operation, model);
    }
}

