/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.injection;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.webservices.WSMessages;
import org.jboss.as.webservices.injection.WSEndpointHandlersMapping;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.DotNames;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.Index;
import org.jboss.vfs.VirtualFile;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaDataParser;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;

public final class WSHandlerChainAnnotationProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)unit)) {
            return;
        }
        List<ResourceRoot> resourceRoots = ASHelper.getResourceRoots(unit);
        if (resourceRoots == null) {
            return;
        }
        WSEndpointHandlersMapping mapping = new WSEndpointHandlersMapping();
        Index index = null;
        for (ResourceRoot resourceRoot : resourceRoots) {
            index = (Index)resourceRoot.getAttachment(Attachments.ANNOTATION_INDEX);
            if (index == null) continue;
            WSHandlerChainAnnotationProcessor.processHandlerChainAnnotations(resourceRoot, index, mapping);
        }
        if (!mapping.isEmpty()) {
            unit.putAttachment(WSAttachmentKeys.WS_ENDPOINT_HANDLERS_MAPPING_KEY, (Object)mapping);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private static void processHandlerChainAnnotations(ResourceRoot resourceRoot, Index index, WSEndpointHandlersMapping mapping) throws DeploymentUnitProcessingException {
        List handlerChainAnnotations = index.getAnnotations(DotNames.HANDLER_CHAIN_ANNOTATION);
        for (AnnotationInstance handlerChainAnnotation : handlerChainAnnotations) {
            ClassInfo classInfo;
            AnnotationTarget annotationTarget = handlerChainAnnotation.target();
            if (!(annotationTarget instanceof ClassInfo) || !WSHandlerChainAnnotationProcessor.isJaxwsEndpoint(classInfo = (ClassInfo)annotationTarget, index)) continue;
            String endpointClass = classInfo.name().toString();
            WSHandlerChainAnnotationProcessor.processHandlerChainAnnotation(resourceRoot, handlerChainAnnotation, endpointClass, mapping);
        }
    }

    private static void processHandlerChainAnnotation(ResourceRoot resourceRoot, AnnotationInstance handlerChainAnnotation, String endpointClass, WSEndpointHandlersMapping mapping) throws DeploymentUnitProcessingException {
        String handlerChainConfigFile = handlerChainAnnotation.value("file").asString();
        InputStream is = null;
        try {
            is = WSHandlerChainAnnotationProcessor.getInputStream(resourceRoot, handlerChainConfigFile, endpointClass);
            Set<String> endpointHandlers = WSHandlerChainAnnotationProcessor.getHandlers(is);
            if (endpointHandlers.size() > 0) {
                mapping.registerEndpointHandlers(endpointClass, endpointHandlers);
            }
        }
        catch (IOException e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    private static InputStream getInputStream(ResourceRoot resourceRoot, String handlerChainConfigFile, String annotatedClassName) throws IOException {
        if (handlerChainConfigFile.startsWith("file://") || handlerChainConfigFile.startsWith("http://")) {
            return new URL(handlerChainConfigFile).openStream();
        }
        URI classURI = null;
        try {
            classURI = new URI(annotatedClassName.replace('.', '/'));
        }
        catch (URISyntaxException ignore) {
            // empty catch block
        }
        String handlerChainConfigFileResourcePath = classURI.resolve(handlerChainConfigFile).toString();
        VirtualFile config = resourceRoot.getRoot().getChild(handlerChainConfigFileResourcePath);
        if (config.exists() && config.isFile()) {
            return config.openStream();
        }
        throw WSMessages.MESSAGES.missingHandlerChainConfigFile(handlerChainConfigFileResourcePath, resourceRoot);
    }

    private static Set<String> getHandlers(InputStream is) throws IOException {
        HashSet<String> retVal = new HashSet<String>();
        UnifiedHandlerChainsMetaData handlerChainsUMDM = UnifiedHandlerChainsMetaDataParser.parse((InputStream)is);
        for (UnifiedHandlerChainMetaData handlerChainUMDM : handlerChainsUMDM.getHandlerChains()) {
            for (UnifiedHandlerMetaData handlerUMDM : handlerChainUMDM.getHandlers()) {
                retVal.add(handlerUMDM.getHandlerClass());
            }
        }
        return retVal;
    }

    private static boolean isJaxwsEndpoint(ClassInfo clazz, Index index) {
        short flags = clazz.flags();
        if (Modifier.isInterface(flags)) {
            return false;
        }
        if (Modifier.isAbstract(flags)) {
            return false;
        }
        if (!Modifier.isPublic(flags)) {
            return false;
        }
        if (ASHelper.isJaxwsService(clazz, index)) {
            return false;
        }
        if (Modifier.isFinal(flags)) {
            return false;
        }
        boolean isWebService = clazz.annotations().containsKey(DotNames.WEB_SERVICE_ANNOTATION);
        boolean isWebServiceProvider = clazz.annotations().containsKey(DotNames.WEB_SERVICE_PROVIDER_ANNOTATION);
        return isWebService || isWebServiceProvider;
    }
}

