/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.test;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.ws.Service;
import javax.xml.ws.handler.HandlerResolver;
import org.jboss.logging.Logger;
import org.jboss.ws.common.concurrent.CopyJob;
import org.jboss.ws.common.io.TeeOutputStream;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployer.Deployer;

public class JBossWSTestHelper {
    private static final Logger LOGGER = Logger.getLogger(JBossWSTestHelper.class);
    private static final String JBOSS_HOME = System.getProperty("jboss.home");
    private static final String FS = System.getProperty("file.separator");
    private static final String PS = System.getProperty("path.separator");
    private static final String EXT = ":".equals(PS) ? ".sh" : ".bat";
    private static final String SYSPROP_JBOSSWS_INTEGRATION_TARGET = "jbossws.integration.target";
    private static final String SYSPROP_JBOSS_BIND_ADDRESS = "jboss.bind.address";
    private static final String SYSPROP_TEST_ARCHIVE_DIRECTORY = "test.archive.directory";
    private static final String SYSPROP_TEST_RESOURCES_DIRECTORY = "test.resources.directory";
    private static final boolean DEPLOY_PROCESS_ENABLED = !Boolean.getBoolean("disable.test.archive.deployment");
    private static Deployer DEPLOYER;
    private static MBeanServerConnection server;
    private static String integrationTarget;
    private static String implVendor;
    private static String implTitle;
    private static String implVersion;
    private static String testArchiveDir;
    private static String testResourcesDir;
    private static Process appclientProcess;
    private static OutputStream appclientOutput;

    private static synchronized Deployer getDeployer() {
        if (DEPLOYER == null) {
            SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
            DEPLOYER = (Deployer)spiProvider.getSPI(Deployer.class);
        }
        return DEPLOYER;
    }

    public static void deploy(String archive) throws Exception {
        if (DEPLOY_PROCESS_ENABLED) {
            URL archiveURL = JBossWSTestHelper.getArchiveFile(archive).toURI().toURL();
            JBossWSTestHelper.getDeployer().deploy(archiveURL);
        }
    }

    public static void undeploy(String archive) throws Exception {
        if (DEPLOY_PROCESS_ENABLED) {
            URL archiveURL = JBossWSTestHelper.getArchiveFile(archive).toURI().toURL();
            JBossWSTestHelper.getDeployer().undeploy(archiveURL);
        }
    }

    public static Process deployAppclient(String archive, OutputStream appclientOS, String ... appclientArgs) throws Exception {
        if (DEPLOY_PROCESS_ENABLED) {
            int sharpIndex = archive.indexOf(35);
            String appclientScript = JBOSS_HOME + FS + "bin" + FS + "appclient" + EXT;
            String earName = archive.substring(0, sharpIndex);
            String appclientName = archive.substring(sharpIndex + 1);
            String appclientFullName = JBossWSTestHelper.getArchiveFile(earName).getParent() + FS + archive;
            String touchFile = JBOSS_HOME + FS + "bin" + FS + appclientName + ".kill";
            appclientOutput = new ByteArrayOutputStream();
            if (appclientOS == null) {
                appclientProcess = new ProcessBuilder(new String[0]).command(appclientScript, appclientFullName, touchFile).start();
            } else {
                LinkedList<String> args = new LinkedList<String>();
                args.add(appclientScript);
                args.add(appclientFullName);
                for (String appclientArg : appclientArgs) {
                    args.add(appclientArg);
                }
                appclientProcess = new ProcessBuilder(new String[0]).command(args).start();
            }
            CopyJob inputStreamJob = new CopyJob(appclientProcess.getInputStream(), (OutputStream)(appclientOS == null ? new TeeOutputStream(appclientOutput, (OutputStream)System.out, new OutputStream[0]) : new TeeOutputStream(appclientOutput, (OutputStream)System.out, new OutputStream[]{appclientOS})));
            CopyJob errorStreamJob = new CopyJob(appclientProcess.getErrorStream(), (OutputStream)System.err);
            System.out.println("Appclient output stream:");
            new Thread((Runnable)inputStreamJob).start();
            new Thread((Runnable)errorStreamJob).start();
            int countOfAttempts = 0;
            int maxCountOfAttempts = 30;
            while (!appclientOutput.toString().contains("Deployed \"" + earName + "\"")) {
                Thread.sleep(1000L);
                if (countOfAttempts++ != 30) continue;
                throw new RuntimeException("Cannot deploy " + appclientFullName + " to appclient");
            }
            System.out.println("appclient started");
        }
        return appclientProcess;
    }

    public static void undeployAppclient(String archive) throws Exception {
        if (DEPLOY_PROCESS_ENABLED) {
            int sharpIndex = archive.indexOf(35);
            File touchFile = new File(JBOSS_HOME + FS + "bin" + FS + archive.substring(sharpIndex + 1) + ".kill");
            touchFile.createNewFile();
            appclientProcess.waitFor();
            appclientProcess = null;
            touchFile.delete();
            System.out.println("appclient stopped");
        }
    }

    public static boolean isTargetJBoss7() {
        String target = JBossWSTestHelper.getIntegrationTarget();
        return target.startsWith("jboss7");
    }

    public static boolean isTargetJBoss70() {
        String target = JBossWSTestHelper.getIntegrationTarget();
        return target.startsWith("jboss70");
    }

    public static boolean isTargetJBoss71() {
        String target = JBossWSTestHelper.getIntegrationTarget();
        return target.startsWith("jboss71");
    }

    public static boolean isIntegrationNative() {
        String vendor = JBossWSTestHelper.getImplementationVendor();
        return vendor.toLowerCase().indexOf("jboss") != -1;
    }

    public static boolean isIntegrationCXF() {
        String vendor = JBossWSTestHelper.getImplementationVendor();
        return vendor.toLowerCase().indexOf("apache") != -1;
    }

    private static String getImplementationVendor() {
        if (implVendor == null) {
            Object obj = JBossWSTestHelper.getImplementationObject();
            implVendor = obj.getClass().getPackage().getImplementationVendor();
            if (implVendor == null) {
                implVendor = JBossWSTestHelper.getImplementationPackage();
            }
            implTitle = obj.getClass().getPackage().getImplementationTitle();
            implVersion = obj.getClass().getPackage().getImplementationVersion();
            System.out.println(implVendor + ", " + implTitle + ", " + implVersion);
        }
        return implVendor;
    }

    private static Object getImplementationObject() {
        Service service = Service.create((QName)new QName("dummyService"));
        HandlerResolver obj = service.getHandlerResolver();
        if (obj == null) {
            service.addPort(new QName("dummyPort"), "http://schemas.xmlsoap.org/wsdl/soap/http", "http://dummy-address");
            obj = service.createDispatch(new QName("dummyPort"), Source.class, Service.Mode.PAYLOAD);
        }
        return obj;
    }

    private static String getImplementationPackage() {
        return JBossWSTestHelper.getImplementationObject().getClass().getPackage().getName();
    }

    public static String getServerHost() {
        String host = System.getProperty(SYSPROP_JBOSS_BIND_ADDRESS, "localhost");
        return JBossWSTestHelper.toIPv6URLFormat(host);
    }

    private static String toIPv6URLFormat(String host) {
        try {
            boolean isIPv6Address = InetAddress.getByName(host) instanceof Inet6Address;
            boolean isIPv6Formatted = isIPv6Address && host.startsWith("[");
            return isIPv6Address && !isIPv6Formatted ? "[" + host + "]" : host;
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public static MBeanServerConnection getServer() {
        if (server == null) {
            String integrationTarget = JBossWSTestHelper.getIntegrationTarget();
            if (integrationTarget.startsWith("jboss7")) {
                server = JBossWSTestHelper.getAS7ServerConnection(integrationTarget);
            } else {
                throw new IllegalStateException("Unsupported target container: " + integrationTarget);
            }
        }
        return server;
    }

    private static MBeanServerConnection getAS7ServerConnection(String integrationTarget) {
        String host = JBossWSTestHelper.getServerHost();
        String urlString = integrationTarget.startsWith("jboss70") ? System.getProperty("jmx.service.url", "service:jmx:rmi:///jndi/rmi://" + host + ":" + 1090 + "/jmxrmi") : System.getProperty("jmx.service.url", "service:jmx:remoting-jmx://" + host + ":" + 9999);
        try {
            JMXServiceURL serviceURL = new JMXServiceURL(urlString);
            return JMXConnectorFactory.connect(serviceURL, null).getMBeanServerConnection();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot obtain MBeanServerConnection to: " + urlString, ex);
        }
    }

    public static String getIntegrationTarget() {
        if (integrationTarget == null) {
            integrationTarget = System.getProperty(SYSPROP_JBOSSWS_INTEGRATION_TARGET);
            if (integrationTarget == null) {
                throw new IllegalStateException("Cannot obtain system property: jbossws.integration.target");
            }
            LOGGER.warn((Object)"TODO: [JBWS-3211] implement integrationTarget mismatch check for AS 7.x");
        }
        return integrationTarget;
    }

    public static URL getArchiveURL(String archive) throws MalformedURLException {
        return JBossWSTestHelper.getArchiveFile(archive).toURI().toURL();
    }

    public static File getArchiveFile(String archive) {
        File file = new File(archive);
        if (file.exists()) {
            return file;
        }
        file = new File(JBossWSTestHelper.getTestArchiveDir() + "/" + archive);
        if (file.exists()) {
            return file;
        }
        String notSet = JBossWSTestHelper.getTestArchiveDir() == null ? " System property 'test.archive.directory' not set." : "";
        throw new IllegalArgumentException("Cannot obtain '" + JBossWSTestHelper.getTestArchiveDir() + "/" + archive + "'." + notSet);
    }

    public static URL getResourceURL(String resource) throws MalformedURLException {
        return JBossWSTestHelper.getResourceFile(resource).toURI().toURL();
    }

    public static File getResourceFile(String resource) {
        File file = new File(resource);
        if (file.exists()) {
            return file;
        }
        file = new File(JBossWSTestHelper.getTestResourcesDir() + "/" + resource);
        if (file.exists()) {
            return file;
        }
        String notSet = JBossWSTestHelper.getTestResourcesDir() == null ? " System property 'test.resources.directory' not set." : "";
        throw new IllegalArgumentException("Cannot obtain '" + JBossWSTestHelper.getTestResourcesDir() + "/" + resource + "'." + notSet);
    }

    public static String getTestArchiveDir() {
        if (testArchiveDir == null) {
            testArchiveDir = System.getProperty(SYSPROP_TEST_ARCHIVE_DIRECTORY);
        }
        return testArchiveDir;
    }

    public static String getTestResourcesDir() {
        if (testResourcesDir == null) {
            testResourcesDir = System.getProperty(SYSPROP_TEST_RESOURCES_DIRECTORY);
        }
        return testResourcesDir;
    }

    public static void addSecurityDomain(String name, Map<String, String> authenticationOptions) throws Exception {
        JBossWSTestHelper.getDeployer().addSecurityDomain(name, authenticationOptions);
    }

    public static void removeSecurityDomain(String name) throws Exception {
        JBossWSTestHelper.getDeployer().removeSecurityDomain(name);
    }
}

