/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import org.jboss.as.webservices.WSLogger;
import org.jboss.as.webservices.WSMessages;
import org.jboss.as.webservices.parser.WSDeploymentAspectParser;
import org.jboss.ws.common.sort.DeploymentAspectSorter;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.deployment.DeploymentAspect;

public class DeploymentAspectsProvider {
    private static List<DeploymentAspect> aspects = null;

    public static synchronized List<DeploymentAspect> getSortedDeploymentAspects() {
        if (aspects == null) {
            LinkedList<DeploymentAspect> deploymentAspects = new LinkedList<DeploymentAspect>();
            ClassLoaderProvider provider = ClassLoaderProvider.getDefaultProvider();
            ClassLoader cl = provider.getServerIntegrationClassLoader();
            deploymentAspects.addAll(DeploymentAspectsProvider.getDeploymentAspects(cl, "/META-INF/stack-agnostic-deployment-aspects.xml"));
            deploymentAspects.addAll(DeploymentAspectsProvider.getDeploymentAspects(cl, "/META-INF/stack-specific-deployment-aspects.xml"));
            aspects = DeploymentAspectSorter.getInstance().sort(deploymentAspects);
        }
        return aspects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<DeploymentAspect> getDeploymentAspects(ClassLoader cl, String resourcePath) {
        try {
            Enumeration<URL> urls = DeploymentAspectsProvider.class.getClassLoader().getResources(resourcePath);
            if (urls != null && urls.hasMoreElements()) {
                URL url = urls.nextElement();
                InputStream is = null;
                try {
                    is = url.openStream();
                    List<DeploymentAspect> list = WSDeploymentAspectParser.parse(is, cl);
                    return list;
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
            WSLogger.ROOT_LOGGER.cannotLoadDeploymentAspectsDefinitionFile(resourcePath);
            return Collections.emptyList();
        }
        catch (IOException e) {
            throw WSMessages.MESSAGES.cannotLoadDeploymentAspectsDefinitionFile(e, resourcePath);
        }
    }
}

