/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxrs.deployment;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.ws.rs.ApplicationPath;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.jaxrs.deployment.JaxrsAttachments;
import org.jboss.as.jaxrs.deployment.JaxrsDeploymentMarker;
import org.jboss.as.jaxrs.logging.JaxrsLogger;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossServletsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.wsf.spi.deployment.WSFServlet;
import org.jboss.wsf.spi.metadata.JAXRSDeploymentMetadata;

public class JaxrsIntegrationProcessor
implements DeploymentUnitProcessor {
    private static final String JAX_RS_SERVLET_NAME = "javax.ws.rs.core.Application";
    private static final String SERVLET_INIT_PARAM = "javax.ws.rs.Application";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!JaxrsDeploymentMarker.isJaxrsDeployment(deploymentUnit)) {
            return;
        }
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        DeploymentUnit parent = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        JBossWebMetaData webdata = warMetaData.getMergedJBossWebMetaData();
        JAXRSDeploymentMetadata jaxrsDepMD = (JAXRSDeploymentMetadata)deploymentUnit.getAttachment(JaxrsAttachments.JAXRS_DEPLOYMENT_DATA);
        if (jaxrsDepMD == null) {
            return;
        }
        Map attachmentMap = (Map)parent.getAttachment(JaxrsAttachments.ADDITIONAL_JAXRS_DEPLOYMENT_DATA);
        ArrayList additionalData = new ArrayList();
        ModuleSpecification moduleSpec = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        if (moduleSpec != null && attachmentMap != null) {
            HashSet<ModuleIdentifier> identifiers = new HashSet<ModuleIdentifier>();
            for (ModuleDependency dep : moduleSpec.getAllDependencies()) {
                if (identifiers.contains(dep.getIdentifier())) continue;
                identifiers.add(dep.getIdentifier());
                if (!attachmentMap.containsKey(dep.getIdentifier())) continue;
                additionalData.add(attachmentMap.get(dep.getIdentifier()));
            }
            jaxrsDepMD.merge(additionalData);
        }
        this.logFindings(jaxrsDepMD);
        if (jaxrsDepMD.hasBootClasses() || jaxrsDepMD.isDispatcherCreated()) {
            return;
        }
        HashSet<Class> applicationClassSet = new HashSet<Class>();
        for (Class clazz : jaxrsDepMD.getScannedApplicationClasses()) {
            if (!clazz.isAnnotationPresent(ApplicationPath.class) && !JaxrsIntegrationProcessor.servletMappingsExist(webdata, clazz.getName())) continue;
            applicationClassSet.add(clazz);
        }
        if (applicationClassSet.size() == 0) {
            JBossServletMetaData servlet = new JBossServletMetaData();
            servlet.setName(JAX_RS_SERVLET_NAME);
            this.setJBossWSServlet(servlet);
            servlet.setAsyncSupported(true);
            this.addServlet(webdata, servlet);
            return;
        }
        for (Class applicationClass : applicationClassSet) {
            String servletName = null;
            servletName = applicationClass.getName();
            JBossServletMetaData servlet = new JBossServletMetaData();
            servlet.setLoadOnStartup("0");
            servlet.setName(servletName);
            this.setJBossWSServlet(servlet);
            servlet.setAsyncSupported(true);
            this.setServletInitParam(servlet, SERVLET_INIT_PARAM, applicationClass.getName());
            this.addServlet(webdata, servlet);
            if (!JaxrsIntegrationProcessor.servletMappingsExist(webdata, servletName)) {
                ArrayList<String> patterns = new ArrayList<String>();
                patterns.add("/*");
                ServletMappingMetaData mapping = new ServletMappingMetaData();
                mapping.setServletName(servletName);
                mapping.setUrlPatterns(patterns);
                if (webdata.getServletMappings() == null) {
                    webdata.setServletMappings(new ArrayList());
                }
                webdata.getServletMappings().add(mapping);
                continue;
            }
            if (!this.isURLPatternSet(webdata, servletName)) continue;
            jaxrsDepMD.setIgnoreApplicationPath(true);
        }
    }

    private void logFindings(JAXRSDeploymentMetadata jaxrsDepMD) {
        if (JaxrsLogger.JAXRS_LOGGER.isInfoEnabled()) {
            Object providers;
            StringBuffer buf;
            if (!jaxrsDepMD.getScannedResourceClasses().isEmpty()) {
                buf = null;
                for (String resource : jaxrsDepMD.getScannedResourceClasses()) {
                    if (buf == null) {
                        buf = new StringBuffer();
                        buf.append(resource);
                        continue;
                    }
                    buf.append(",").append(resource);
                }
                String resources = buf.toString();
                JaxrsLogger.JAXRS_LOGGER.infof("Adding JAX-RS resource classes: %s", resources);
            }
            if (!jaxrsDepMD.getScannedProviderClasses().isEmpty()) {
                buf = null;
                for (String provider : jaxrsDepMD.getScannedProviderClasses()) {
                    if (buf == null) {
                        buf = new StringBuffer();
                        buf.append(provider);
                        continue;
                    }
                    buf.append(",").append(provider);
                }
                providers = buf.toString();
                JaxrsLogger.JAXRS_LOGGER.infof("Adding JAX-RS provider classes: %s", providers);
            }
            if (!jaxrsDepMD.getScannedJndiComponentResources().isEmpty()) {
                buf = null;
                for (String resource : jaxrsDepMD.getScannedJndiComponentResources()) {
                    if (buf == null) {
                        buf = new StringBuffer();
                        buf.append(resource);
                        continue;
                    }
                    buf.append(",").append(resource);
                }
                providers = buf.toString();
                JaxrsLogger.JAXRS_LOGGER.infof("Adding JAX-RS jndi component resource classes: %s", providers);
            }
        }
    }

    private void setJBossWSServlet(JBossServletMetaData servlet) {
        servlet.setServletClass(WSFServlet.class.getName());
        this.setServletInitParam(servlet, "org.jboss.wsf.spi.deployment.jaxrsServletMode", "true");
        this.setServletInitParam(servlet, "org.jboss.wsf.spi.deployment.stackServletDelegateClass", "org.jboss.wsf.stack.cxf.JAXRSServletExt");
    }

    protected void setServletInitParam(JBossServletMetaData servlet, String name, String value) {
        ParamValueMetaData param = new ParamValueMetaData();
        param.setParamName(name);
        param.setParamValue(value);
        ArrayList<ParamValueMetaData> params = servlet.getInitParam();
        if (params == null) {
            params = new ArrayList<ParamValueMetaData>();
            servlet.setInitParam(params);
        }
        params.add(param);
    }

    private boolean isURLPatternSet(JBossWebMetaData webdata, String servletName) {
        List mappings = webdata.getServletMappings();
        boolean mappingSet = false;
        if (mappings != null) {
            for (ServletMappingMetaData mapping : mappings) {
                if (!mapping.getServletName().equals(servletName) || mapping.getUrlPatterns() == null) continue;
                for (String pattern : mapping.getUrlPatterns()) {
                    if (mappingSet) {
                        JaxrsLogger.JAXRS_LOGGER.moreThanOneServletMapping(servletName, pattern);
                        continue;
                    }
                    mappingSet = true;
                }
            }
        }
        return mappingSet;
    }

    private void addServlet(JBossWebMetaData webdata, JBossServletMetaData servlet) {
        if (webdata.getServlets() == null) {
            webdata.setServlets(new JBossServletsMetaData());
        }
        webdata.getServlets().add((MappableMetaData)servlet);
    }

    public void undeploy(DeploymentUnit context) {
    }

    protected void setFilterInitParam(FilterMetaData filter, String name, String value) {
        ParamValueMetaData param = new ParamValueMetaData();
        param.setParamName(name);
        param.setParamValue(value);
        ArrayList<ParamValueMetaData> params = filter.getInitParam();
        if (params == null) {
            params = new ArrayList<ParamValueMetaData>();
            filter.setInitParam(params);
        }
        params.add(param);
    }

    private static boolean servletMappingsExist(JBossWebMetaData webdata, String servletName) {
        List mappings = webdata.getServletMappings();
        if (mappings == null) {
            return false;
        }
        for (ServletMappingMetaData mapping : mappings) {
            if (!mapping.getServletName().equals(servletName)) continue;
            return true;
        }
        return false;
    }
}

