/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.effect;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.IntegerBox;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.HashMap;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.bus.UndoableEvent;
import org.jbpm.form.builder.ng.model.client.bus.UndoableHandler;
import org.jbpm.form.builder.ng.model.client.effect.FBFormEffect;
import org.jbpm.form.builder.ng.model.client.form.FBFormItem;
import org.jbpm.form.builder.ng.model.client.form.items.MIGLayoutFormItem;
import org.jbpm.form.builder.ng.model.client.messages.I18NConstants;

@Reflectable
public class ChangeColspanFormEffect
extends FBFormEffect {
    private final I18NConstants i18n = CommonGlobals.getInstance().getI18n();
    private final EventBus bus = CommonGlobals.getInstance().getEventBus();
    private final IntegerBox colspan = new IntegerBox();
    private final IntegerBox rowspan = new IntegerBox();

    public ChangeColspanFormEffect() {
        super(CommonGlobals.getInstance().getI18n().ChangeColspanEffectLabel(), true);
    }

    @Override
    protected void createStyles() {
        FBFormItem item = this.getItem();
        MIGLayoutFormItem container = this.getContainer(item);
        HashMap<String, Object> dataSnapshot = new HashMap<String, Object>();
        dataSnapshot.put("item", (Object)item);
        dataSnapshot.put("container", container);
        dataSnapshot.put("oldColspan", container.getColSpan(item));
        dataSnapshot.put("oldRowspan", container.getRowSpan(item));
        dataSnapshot.put("newColspan", this.colspan.getValue());
        dataSnapshot.put("newRowspan", this.rowspan.getValue());
        UndoableHandler rollbackHandler = new UndoableHandler(){

            @Override
            public void onEvent(UndoableEvent event) {
            }

            @Override
            public void doAction(UndoableEvent event) {
                Integer rowspan = (Integer)event.getData("newRowspan");
                Integer colspan = (Integer)event.getData("newColspan");
                MIGLayoutFormItem container = (MIGLayoutFormItem)event.getData("container");
                FBFormItem item = (FBFormItem)((Object)event.getData("item"));
                container.setSpan(item, colspan, rowspan);
            }

            @Override
            public void undoAction(UndoableEvent event) {
                Integer rowspan = (Integer)event.getData("oldRowspan");
                Integer colspan = (Integer)event.getData("oldColspan");
                MIGLayoutFormItem container = (MIGLayoutFormItem)event.getData("container");
                FBFormItem item = (FBFormItem)((Object)event.getData("item"));
                container.setSpan(item, colspan, rowspan);
            }
        };
        this.bus.fireEvent((GwtEvent)new UndoableEvent(dataSnapshot, rollbackHandler));
        container.setSpan(item, (Integer)this.colspan.getValue(), (Integer)this.rowspan.getValue());
    }

    private MIGLayoutFormItem getContainer(FBFormItem item) {
        Widget parent = item.getParent();
        while (!(parent instanceof MIGLayoutFormItem)) {
            parent = parent.getParent();
        }
        return (MIGLayoutFormItem)parent;
    }

    @Override
    public PopupPanel createPanel() {
        FBFormItem item = this.getItem();
        MIGLayoutFormItem container = this.getContainer(item);
        this.colspan.setValue((Object)container.getColSpan(item));
        this.rowspan.setValue((Object)container.getRowSpan(item));
        final PopupPanel panel = new PopupPanel();
        Grid data = new Grid(3, 2);
        Button cancelButton = new Button(this.i18n.CancelButton(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                panel.hide();
            }
        });
        Button confirmButton = new Button(this.i18n.ConfirmButton(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ChangeColspanFormEffect.this.createStyles();
                panel.hide();
            }
        });
        data.setWidget(0, 0, (Widget)new Label(this.i18n.ColspanLabel()));
        data.setWidget(0, 1, (Widget)this.colspan);
        data.setWidget(1, 0, (Widget)new Label(this.i18n.RowspanLabel()));
        data.setWidget(1, 1, (Widget)this.rowspan);
        data.setWidget(2, 0, (Widget)cancelButton);
        data.setWidget(2, 1, (Widget)confirmButton);
        panel.add((Widget)data);
        return panel;
    }
}

