/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.effect.scripthandlers;

import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.effect.scripthandlers.AbstractScriptHelper;
import org.jbpm.form.builder.ng.model.client.effect.scriptviews.ToggleScriptHelperView;
import org.jbpm.form.builder.ng.model.client.messages.I18NConstants;

@Reflectable
public class ToggleScriptHelper
extends AbstractScriptHelper {
    public static final String TOGGLE = "toggle";
    public static final String SHOW = "show";
    public static final String HIDE = "hide";
    public static final String HIDING_STRATEGY_COLLAPSE = "collapse";
    public static final String HIDING_STRATEGY_HIDDEN = "hidden";
    private final I18NConstants i18n = CommonGlobals.getInstance().getI18n();
    private String idField = "";
    private String actionOnEvent = "toggle";
    private String hidingStrategy = "hidden";
    private ToggleScriptHelperView view;

    @Override
    public Map<String, Object> getDataMap() {
        if (this.view != null) {
            this.view.writeDataTo(this);
        }
        String idFieldValue = this.idField;
        String actionOnEventValue = this.actionOnEvent;
        String hidingStrategyValue = this.hidingStrategy;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("@className", ToggleScriptHelper.class.getName());
        map.put("idField", idFieldValue);
        map.put("actionOnEvent", actionOnEventValue);
        map.put("hidingStrategy", hidingStrategyValue);
        return map;
    }

    @Override
    public void setDataMap(Map<String, Object> dataMap) {
        String idFieldValue = (String)dataMap.get("idField");
        String actionOnEventValue = (String)dataMap.get("actionOnEvent");
        String hidingStrategyValue = (String)dataMap.get("hidingStrategy");
        this.idField = idFieldValue;
        this.actionOnEvent = actionOnEventValue;
        this.hidingStrategy = hidingStrategyValue;
        if (this.view != null) {
            this.view.readDataFrom(this);
        }
    }

    @Override
    public String asScriptContent() {
        if (this.view != null) {
            this.view.writeDataTo(this);
        }
        long id = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        String actionValue = this.actionOnEvent;
        String strategy = this.hidingStrategy;
        sb.append("var elementToggle" + id + " = document.getElementById('" + this.idField + "');");
        sb.append("if (elementToggle" + id + " != null) {");
        if (actionValue.equals(HIDE)) {
            sb.append("   elementToggle" + id + ".style.visibility = '" + strategy + "';");
        }
        if (actionValue.equals(SHOW)) {
            sb.append("   elementToggle" + id + ".style.visibility = 'visible';");
        }
        if (actionValue.equals(TOGGLE)) {
            sb.append("   if (elementToggle" + id + ".style.visibility == 'visible') {");
            sb.append("      elementToggle" + id + ".style.visibility = '" + strategy + "';");
            sb.append("   } else {");
            sb.append("      elementToggle" + id + ".style.visibility = 'visible';");
            sb.append("   }");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public Widget draw() {
        if (this.view == null) {
            this.view = new ToggleScriptHelperView(this);
            this.view.readDataFrom(this);
        }
        return this.view;
    }

    @Override
    public String getName() {
        return this.i18n.ToggleScriptHelperName();
    }

    public String getIdField() {
        return this.idField;
    }

    public void setIdField(String idField) {
        this.idField = idField;
    }

    public String getActionOnEvent() {
        return this.actionOnEvent;
    }

    public void setActionOnEvent(String actionOnEvent) {
        this.actionOnEvent = actionOnEvent;
    }

    public String getHidingStrategy() {
        return this.hidingStrategy;
    }

    public void setHidingStrategy(String hidingStrategy) {
        this.hidingStrategy = hidingStrategy;
    }
}

