/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.form;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.FormElement;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.FormBuilderException;
import org.jbpm.form.builder.ng.model.client.form.FBCompositeItem;
import org.jbpm.form.builder.ng.model.client.form.FBFormItem;
import org.jbpm.form.builder.ng.model.client.form.PhantomPanel;
import org.jbpm.form.builder.ng.model.client.menu.FormDataPopupPanel;
import org.jbpm.form.builder.ng.model.client.validation.FBValidationItem;
import org.jbpm.form.builder.ng.model.common.handler.ControlKeyHandler;
import org.jbpm.form.builder.ng.model.common.handler.EventHelper;
import org.jbpm.form.builder.ng.model.common.handler.RightClickEvent;
import org.jbpm.form.builder.ng.model.common.handler.RightClickHandler;
import org.jbpm.form.builder.ng.model.shared.api.FBScript;
import org.jbpm.form.builder.ng.model.shared.api.FormBuilderDTO;

public class FBForm
extends FlowPanel
implements FBCompositeItem {
    private String name;
    private String taskId;
    private String processId;
    private String method;
    private String enctype;
    private String action;
    private Map<String, Object> inputs;
    private Map<String, Object> outputs;
    private List<FBScript> onLoadScripts = new ArrayList<FBScript>();
    private List<FBScript> onSubmitScripts = new ArrayList<FBScript>();
    private List<FBFormItem> formItems = new ArrayList<FBFormItem>();
    private List<FBValidationItem> validationItems = new ArrayList<FBValidationItem>();
    private final FormDataPopupPanel popup = new FormDataPopupPanel();
    private boolean saved = false;
    private long lastModified = 0L;

    public FBForm() {
        EventHelper.addRightClickHandler((Widget)this, new RightClickHandler(){

            @Override
            public void onRightClick(RightClickEvent event) {
                FBForm.this.popup.setPopupPosition(event.getX(), event.getY());
                FBForm.this.popup.show();
            }
        });
        EventHelper.addKeyboardPasteHandler((Widget)this, new ControlKeyHandler(){

            @Override
            public void onKeyboardControl() {
                CommonGlobals.getInstance().paste().append(null).execute();
            }
        });
    }

    public void onBrowserEvent(Event event) {
        EventHelper.onBrowserEvent((Widget)this, event);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.popup.setName(name);
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
        this.popup.setTaskId(taskId);
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
        this.popup.setProcessId(processId);
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
        this.popup.setAction(action);
    }

    public String getEnctype() {
        return this.enctype;
    }

    public void setEnctype(String enctype) {
        this.enctype = enctype;
        this.popup.setEnctype(enctype);
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
        this.popup.setMethod(method);
    }

    @Override
    public List<FBFormItem> getItems() {
        return this.formItems;
    }

    @Override
    public void setItems(List<FBFormItem> items) {
        this.formItems = items;
    }

    public List<FBValidationItem> getValidationItems() {
        return this.validationItems;
    }

    public void setValidationItems(List<FBValidationItem> validationItems) {
        this.validationItems = validationItems;
    }

    public boolean remove(Widget w) {
        if (w instanceof FBFormItem) {
            FBFormItem item = (FBFormItem)w;
            this.formItems.remove((Object)item);
        }
        return super.remove(w);
    }

    public void add(Widget w) {
        if (w instanceof FBFormItem) {
            FBFormItem formItem = (FBFormItem)w;
            int index = this.getItemPosition(formItem);
            if (index == this.getWidgetCount()) {
                this.formItems.add(formItem);
                super.add(w);
            } else {
                this.insert(w, index);
            }
        } else {
            super.add(w);
        }
    }

    @Override
    public void add(PhantomPanel phantom, int x, int y) {
        for (int index = 0; index < this.getWidgetCount(); ++index) {
            Widget item = this.getWidget(index);
            int left = item.getAbsoluteLeft();
            int right = left + item.getOffsetWidth();
            int top = item.getAbsoluteTop();
            int bottom = top + item.getOffsetHeight();
            if (x > left && x < right && y > top && y < bottom) {
                this.insert((Widget)phantom, index);
                break;
            }
            if (x > right && y > top && y < bottom && index < this.getWidgetCount() - 1) {
                this.insert((Widget)phantom, index + 1);
                break;
            }
            if (index != this.getWidgetCount() - 1) continue;
            this.add((Widget)phantom);
            break;
        }
    }

    public void insert(Widget widget, int beforeIndex) {
        if (widget instanceof FBFormItem) {
            ArrayList<FBFormItem> posteriorItems = new ArrayList<FBFormItem>(this.formItems.subList(beforeIndex, this.formItems.size()));
            this.formItems.removeAll(posteriorItems);
            this.formItems.add((FBFormItem)widget);
            this.formItems.addAll(posteriorItems);
        }
        super.insert(widget, beforeIndex);
    }

    protected int getItemPosition(FBFormItem newItem) {
        int index = this.getWidgetCount();
        if (index == 0) {
            return index;
        }
        if (this.formItems.size() == 0) {
            return 0;
        }
        ListIterator<FBFormItem> it = this.formItems.listIterator(this.formItems.size() - 1);
        while (it.hasPrevious() && index > 0) {
            boolean aboveItem;
            FBFormItem item = it.previous();
            boolean leftOfItem = item.getAbsoluteLeft() > newItem.getDesiredX() && newItem.getDesiredX() > 0;
            boolean bl = aboveItem = item.getAbsoluteTop() > newItem.getDesiredY() && newItem.getDesiredY() > 0;
            if (!aboveItem && !leftOfItem) continue;
            --index;
        }
        return index;
    }

    public void addValidation(FBValidationItem item) {
        this.validationItems.add(item);
    }

    public void onFormLoad() {
    }

    public void onFormSubmit() {
    }

    public void setInputs(Map<String, Object> inputs) {
        this.inputs = inputs;
    }

    public Map<String, Object> getInputs() {
        return this.inputs;
    }

    public void setOutputs(Map<String, Object> outputs) {
        this.outputs = outputs;
    }

    public Map<String, Object> getOutputs() {
        return this.outputs;
    }

    public void setSaved(boolean saved) {
        this.saved = saved;
        this.lastModified = System.currentTimeMillis();
    }

    public FormBuilderDTO createRepresentation() {
        FormBuilderDTO dto = new FormBuilderDTO();
        dto.setString("name", this.name);
        dto.setString("taskId", this.taskId);
        dto.setString("processName", this.processId);
        dto.setString("action", this.action);
        dto.setString("method", this.method);
        dto.setString("enctype", this.enctype);
        ArrayList<Object> formItems = new ArrayList<Object>();
        if (this.formItems != null) {
            for (FBFormItem item : this.formItems) {
                formItems.add(item.getRepresentation().getParameters());
            }
            dto.setList("formItems", formItems);
        }
        if (this.validationItems != null) {
            ArrayList<Object> formValidations = new ArrayList<Object>();
            for (FBValidationItem item : this.validationItems) {
                formValidations.add(item.getDataMap());
            }
            dto.setList("formValidations", formValidations);
        }
        dto.setMap("inputs", this.inputs);
        dto.setMap("outputs", this.outputs);
        dto.setBoolean("saved", this.saved);
        dto.setLong("lastModified", this.lastModified);
        if (this.onLoadScripts != null) {
            ArrayList<Object> loadScripts = new ArrayList<Object>();
            for (FBScript script : this.onLoadScripts) {
                loadScripts.add(script.getDataMap());
            }
            dto.setList("onLoadScripts", loadScripts);
        }
        if (this.onSubmitScripts != null) {
            ArrayList<Object> submitScripts = new ArrayList<Object>();
            for (FBScript script : this.onSubmitScripts) {
                submitScripts.add(script.getDataMap());
            }
            dto.setList("onSubmitScripts", submitScripts);
        }
        return dto;
    }

    public void populate(FormBuilderDTO dto) {
        List<FormBuilderDTO> validationsRep;
        this.setName(dto.getString("name"));
        this.setTaskId(dto.getString("taskId"));
        this.setProcessId(dto.getString("processName"));
        this.setAction(dto.getString("action"));
        this.setMethod(dto.getString("method"));
        this.setEnctype(dto.getString("enctype"));
        for (FBFormItem item : new ArrayList<FBFormItem>(this.formItems)) {
            this.remove((Widget)item);
        }
        List<FormBuilderDTO> itemReps = dto.getListOfDtos("formItems");
        if (itemReps != null) {
            for (FormBuilderDTO itemRep : itemReps) {
                FBFormItem item = null;
                try {
                    item = FBFormItem.createItem(itemRep);
                }
                catch (FormBuilderException ex) {
                    Logger.getLogger(FBForm.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.add((Widget)item);
                this.ensureMinimumSize(item);
            }
        }
        if ((validationsRep = dto.getListOfDtos("formValidations")) != null) {
            for (FormBuilderDTO subDto : validationsRep) {
                try {
                    FBValidationItem validation = FBValidationItem.createValidation(subDto.getParameters());
                    this.addValidation(validation);
                }
                catch (FormBuilderException ex) {
                    Logger.getLogger(FBForm.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        this.setInputs(dto.getMap("inputs"));
        this.setOutputs(dto.getMap("outputs"));
        this.saved = dto.getBoolean("saved");
        this.lastModified = dto.getLong("lastModified");
        this.onLoadScripts.clear();
        List<FormBuilderDTO> loadScriptsRep = dto.getListOfDtos("onLoadScripts");
        if (loadScriptsRep != null) {
            for (FormBuilderDTO scriptRep : loadScriptsRep) {
                FBScript script = new FBScript();
                try {
                    script.setDataMap(scriptRep.getParameters());
                    this.onLoadScripts.add(script);
                }
                catch (FormBuilderException ex) {
                    Logger.getLogger(FBForm.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        this.onSubmitScripts.clear();
        List<FormBuilderDTO> submitScriptsRep = dto.getListOfDtos("onSubmitScripts");
        if (submitScriptsRep != null) {
            for (FormBuilderDTO scriptRep : submitScriptsRep) {
                FBScript script = new FBScript();
                try {
                    script.setDataMap(scriptRep.getParameters());
                    this.onSubmitScripts.add(script);
                }
                catch (FormBuilderException ex) {
                    Logger.getLogger(FBForm.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    protected void ensureMinimumSize(FBFormItem item) {
        if (item.getHeight() != null && !"".equals(item.getHeight()) && item.getHeight().endsWith("px")) {
            int actualHeight = item.getWidget().getOffsetHeight();
            int settedHeight = Integer.valueOf(item.getHeight().replace("px", ""));
            if (actualHeight > 0 && settedHeight < actualHeight) {
                item.setHeight("" + actualHeight + "px");
            }
        }
        if (item.getWidth() != null && !"".equals(item.getWidth()) && item.getWidth().endsWith("px")) {
            int actualWidth = item.getWidget().getOffsetWidth();
            int settedWidth = Integer.valueOf(item.getWidth().replace("px", ""));
            if (actualWidth > 0 && settedWidth < actualWidth) {
                item.setWidth("" + actualWidth + "px");
            }
        }
    }

    @Override
    public void replacePhantom(FBFormItem item) {
        System.out.println("REplace Phantom");
        PhantomPanel phantom = null;
        Iterator i$ = this.iterator();
        while (i$.hasNext()) {
            Widget widget = (Widget)i$.next();
            if (!(widget instanceof PhantomPanel)) continue;
            phantom = (PhantomPanel)widget;
            break;
        }
        if (phantom != null) {
            int index = this.getWidgetIndex((Widget)phantom);
            this.remove((Widget)phantom);
            this.insert((Widget)item, index);
        } else {
            this.add((Widget)item);
        }
    }

    public FormPanel asFormPanel(Map<String, Object> data) {
        FormPanel panel = new FormPanel();
        data.put("org.jbpm.formbuilder.FormBuilder.FORM_PANEL", panel);
        panel.setAction(this.action);
        panel.setEncoding(this.enctype);
        panel.setMethod(this.method);
        FlowPanel flow = new FlowPanel();
        FormElement el = FormElement.as((Element)panel.getElement());
        el.setName(this.name);
        flow.add((Widget)new HTML("<!-- process name: " + this.getProcessId() + ", task name: " + this.getTaskId() + " -->"));
        for (FBFormItem item : this.getItems()) {
            flow.add(item.cloneDisplay(data));
        }
        panel.addSubmitHandler(new FormPanel.SubmitHandler(){

            public void onSubmit(FormPanel.SubmitEvent event) {
                for (FBValidationItem item : FBForm.this.getValidationItems()) {
                    if (!item.canValidateOnClient() || item.isValid(null)) continue;
                    Window.alert((String)("Validation " + item.getName() + " failed"));
                    event.cancel();
                }
            }
        });
        panel.addSubmitCompleteHandler(new FormPanel.SubmitCompleteHandler(){

            public void onSubmitComplete(FormPanel.SubmitCompleteEvent event) {
                RootPanel.get().getElement().setInnerHTML(event.getResults());
            }
        });
        panel.setWidget((Widget)flow);
        return panel;
    }
}

