/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.form;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.FormBuilderException;
import org.jbpm.form.builder.ng.model.client.bus.FormItemSelectionEvent;
import org.jbpm.form.builder.ng.model.client.bus.FormItemSelectionHandler;
import org.jbpm.form.builder.ng.model.client.effect.FBFormEffect;
import org.jbpm.form.builder.ng.model.client.form.EditionContext;
import org.jbpm.form.builder.ng.model.client.form.FBInplaceEditor;
import org.jbpm.form.builder.ng.model.client.form.FormIDGenerator;
import org.jbpm.form.builder.ng.model.client.menu.EffectsPopupPanel;
import org.jbpm.form.builder.ng.model.client.validation.FBValidationItem;
import org.jbpm.form.builder.ng.model.common.handler.ControlKeyHandler;
import org.jbpm.form.builder.ng.model.common.handler.EventHelper;
import org.jbpm.form.builder.ng.model.common.handler.RightClickEvent;
import org.jbpm.form.builder.ng.model.common.handler.RightClickHandler;
import org.jbpm.form.builder.ng.model.common.reflect.ReflectionHelper;
import org.jbpm.form.builder.ng.model.shared.api.FBScript;
import org.jbpm.form.builder.ng.model.shared.api.FormBuilderDTO;
import org.jbpm.form.builder.ng.model.shared.api.RepresentationFactory;

public abstract class FBFormItem
extends FocusPanel {
    private List<FBValidationItem> validations = new ArrayList<FBValidationItem>();
    private Map<String, FBScript> eventActions = new HashMap<String, FBScript>();
    private List<FBFormEffect> effects = new ArrayList<FBFormEffect>();
    private FormItemSelectionHandler itemSelectionHandler;
    private int desiredX;
    private int desiredY;
    private String widgetWidth;
    private String widgetHeight;
    private boolean alreadyEditing = false;
    private Widget auxiliarWidget = null;
    private Map<String, Object> input = null;
    private Map<String, Object> output = null;
    private Map<String, Object> external = null;
    private final String ID = FormIDGenerator.nextId();

    public FBFormItem(List<FBFormEffect> formEffects) {
        this.effects.addAll(formEffects);
        this.addStyleName("fbFormItemThinBorder");
        EventHelper.addRightClickHandler((Widget)this, new RightClickHandler(){

            @Override
            public void onRightClick(RightClickEvent event) {
                EffectsPopupPanel popupPanel = new EffectsPopupPanel(FBFormItem.this, true);
                if (FBFormItem.this.getFormEffects() != null && !FBFormItem.this.getFormEffects().isEmpty()) {
                    popupPanel.setPopupPosition(event.getX(), event.getY());
                    popupPanel.show();
                }
            }
        });
        EventHelper.addKeyboardCopyHandler((Widget)this, new ControlKeyHandler(){

            @Override
            public void onKeyboardControl() {
                CommonGlobals.getInstance().copy().append(FBFormItem.this).execute();
            }
        });
        EventHelper.addKeyboardCutHandler((Widget)this, new ControlKeyHandler(){

            @Override
            public void onKeyboardControl() {
                CommonGlobals.getInstance().cut().append(FBFormItem.this).execute();
            }
        });
        EventHelper.addKeyboardPasteHandler((Widget)this, new ControlKeyHandler(){

            @Override
            public void onKeyboardControl() {
                CommonGlobals.getInstance().paste().append(FBFormItem.this).execute();
            }
        });
        EventHelper.addBlurHandler((Widget)this, new BlurHandler(){

            public void onBlur(BlurEvent event) {
                FBFormItem.this.reset();
            }
        });
        EventHelper.addFocusHandler((Widget)this, new FocusHandler(){

            public void onFocus(FocusEvent event) {
                FBFormItem.this.makeEditor();
            }
        });
    }

    private void makeEditor() {
        FBInplaceEditor inplaceEditor;
        if (!this.getFormItemPropertiesMap().isEmpty() && !this.isAlreadyEditing()) {
            this.fireSelectionEvent(new FormItemSelectionEvent(this.getContext(), true));
        }
        if ((inplaceEditor = this.createInplaceEditor()) != null && !this.isAlreadyEditing()) {
            this.auxiliarWidget = this.getWidget();
            this.clear();
            this.setWidget((Widget)inplaceEditor);
            this.setAlreadyEditing(true);
            inplaceEditor.focus();
        }
    }

    public boolean isAlreadyEditing() {
        return this.alreadyEditing;
    }

    public void setAlreadyEditing(boolean alreadyEditing) {
        this.alreadyEditing = alreadyEditing;
    }

    public void reset() {
        if (this.auxiliarWidget != null && !this.getEditor().isFocused()) {
            this.clear();
            this.add(this.auxiliarWidget);
            this.setAlreadyEditing(false);
            this.fireSelectionEvent(new FormItemSelectionEvent(this.getContext(), false));
        }
    }

    private FBInplaceEditor getEditor() {
        return (FBInplaceEditor)this.getWidget();
    }

    public final void fireSelectionEvent(FormItemSelectionEvent event) {
        this.itemSelectionHandler.onEvent(event);
    }

    public void onBrowserEvent(Event event) {
        EventHelper.onBrowserEvent((Widget)this, event);
    }

    public void addEffect(FBFormEffect effect) {
        if (!this.effects.contains(effect)) {
            this.effects.add(effect);
        }
    }

    public void removeEffect(FBFormEffect effect) {
        if (this.effects.contains(effect)) {
            this.effects.remove(effect);
        }
    }

    protected Integer extractInt(Object obj) {
        String s = this.extractString(obj);
        return s.equals("") ? null : Integer.valueOf(s);
    }

    protected Boolean extractBoolean(Object obj) {
        if (obj != null && obj instanceof Boolean) {
            return (Boolean)obj;
        }
        String s = this.extractString(obj);
        return s.equals("") ? Boolean.FALSE : Boolean.valueOf(s);
    }

    protected String extractString(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    protected Double extractDouble(Object obj) {
        String s = this.extractString(obj);
        return s.equals("") ? null : Double.valueOf(s);
    }

    public List<FBFormEffect> getFormEffects() {
        return this.effects;
    }

    public int getDesiredX() {
        return this.desiredX;
    }

    public void setDesiredX(int desiredX) {
        this.desiredX = desiredX;
    }

    public int getDesiredY() {
        return this.desiredY;
    }

    public void setDesiredY(int desiredY) {
        this.desiredY = desiredY;
    }

    public void setDesiredPosition(int desiredX, int desiredY) {
        this.desiredX = desiredX;
        this.desiredY = desiredY;
    }

    public String getHeight() {
        return this.widgetHeight;
    }

    public String getWidth() {
        return this.widgetWidth;
    }

    public void setWidth(String width) {
        if (width != null) {
            super.setWidth(width);
            this.widgetWidth = width;
        }
    }

    public void setHeight(String height) {
        if (height != null) {
            super.setHeight(height);
            this.widgetHeight = height;
        }
    }

    public void setInput(Map<String, Object> input) {
        this.input = input;
    }

    public void setOutput(Map<String, Object> output) {
        this.output = output;
    }

    public void setExternal(Map<String, Object> external) {
        this.external = external;
    }

    public Map<String, Object> getOutput() {
        return this.output;
    }

    public Map<String, Object> getInput() {
        return this.input;
    }

    public Map<String, Object> getExternal() {
        return this.external;
    }

    protected void setWidgetHeight(String widgetHeight) {
        this.widgetHeight = widgetHeight;
    }

    protected void setWidgetWidth(String widgetWidth) {
        this.widgetWidth = widgetWidth;
    }

    protected void setEffects(List<FBFormEffect> effects) {
        this.effects = effects;
    }

    public void setItemSelectionHandler(FormItemSelectionHandler itemSelectionHandler) {
        this.itemSelectionHandler = itemSelectionHandler;
    }

    protected <T extends FBFormItem> T cloneItem(T clone) {
        clone.setValidations(this.validations);
        clone.setWidgetHeight(this.widgetHeight);
        clone.setWidgetWidth(this.widgetWidth);
        clone.setEffects(this.effects);
        clone.setInput(this.input);
        clone.setOutput(this.output);
        return clone;
    }

    public FormBuilderDTO getRepresentation() {
        FormBuilderDTO dto = new FormBuilderDTO();
        dto.setMap("input", this.getInput());
        dto.setMap("output", this.getOutput());
        dto.setString("height", this.getHeight());
        dto.setString("width", this.getWidth());
        if (this.getFormEffects() != null) {
            ArrayList<Object> effectClasses = new ArrayList<Object>();
            for (FBFormEffect effect : this.getFormEffects()) {
                effectClasses.add(effect.getClass());
            }
            dto.setList("effectClasses", effectClasses);
        }
        if (this.getEventActions() != null) {
            boolean index = false;
            HashMap<String, Object> eventActions = new HashMap<String, Object>();
            for (Map.Entry<String, FBScript> entry : this.getEventActions().entrySet()) {
                Map<String, Object> dataMap = entry.getValue().getDataMap();
                eventActions.put(entry.getKey(), dataMap);
            }
            dto.setMap("eventActions", eventActions);
        }
        dto.setMap("external", this.getExternal());
        return dto;
    }

    public static FBFormItem createItem(FormBuilderDTO dto) throws FormBuilderException {
        if (dto == null) {
            return null;
        }
        String className = RepresentationFactory.getItemClassName(dto.getClassName());
        try {
            FBFormItem item = (FBFormItem)((Object)ReflectionHelper.newInstance(className));
            item.populate(dto);
            return item;
        }
        catch (Exception e) {
            throw new FormBuilderException("Couldn't instantiate class " + className, e);
        }
    }

    public void setValidations(List<FBValidationItem> validations) {
        if (validations == null) {
            validations = new ArrayList<FBValidationItem>();
        }
        this.validations = validations;
    }

    public List<FBValidationItem> getValidations() {
        return this.validations;
    }

    public void setEventActions(Map<String, FBScript> eventActions) {
        if (eventActions == null) {
            eventActions = new HashMap<String, FBScript>();
        }
        this.eventActions = eventActions;
    }

    public Map<String, FBScript> getEventActions() {
        return this.eventActions;
    }

    public FBInplaceEditor createInplaceEditor() {
        return null;
    }

    public EditionContext getContext() {
        Map<String, Object> map = this.getFormItemPropertiesMap();
        EditionContext context = new EditionContext();
        context.setMap(map);
        context.setId(this.ID);
        return context;
    }

    public void save(EditionContext context) {
        if (this.ID.equals(context.getId())) {
            this.saveValues(context.getMap());
        }
    }

    public abstract Map<String, Object> getFormItemPropertiesMap();

    public abstract void saveValues(Map<String, Object> var1);

    public void populate(FormBuilderDTO dto) throws FormBuilderException {
        FormBuilderDTO repActions;
        List<Object> repClasses = dto.getList("effectClasses");
        if (repClasses != null) {
            this.effects = new ArrayList<FBFormEffect>(repClasses.size());
            for (Object objClassName : repClasses) {
                String className = String.valueOf(objClassName);
                try {
                    FBFormEffect effect = (FBFormEffect)ReflectionHelper.newInstance(className);
                    this.effects.add(effect);
                }
                catch (Exception e) {
                    throw new FormBuilderException("Couldn't instantiate class " + className, e);
                }
            }
        }
        if ((repActions = dto.getSubDto("eventActions")) != null && repActions.getParameters() != null) {
            for (String key : repActions.getParameters().keySet()) {
                Map<String, Object> dataMap = repActions.getMap(key);
                if (dataMap == null) {
                    this.eventActions.put(key, null);
                    continue;
                }
                FBScript script = new FBScript();
                script.setDataMap(dataMap);
                this.eventActions.put(key, script);
            }
        }
        this.validations.clear();
        List<FormBuilderDTO> repValidations = dto.getListOfDtos("itemValidations");
        if (repValidations != null) {
            for (FormBuilderDTO repValidation : repValidations) {
                FBValidationItem validationItem = FBValidationItem.createValidation(repValidation.getParameters());
                this.validations.add(validationItem);
            }
        }
        this.setHeight(dto.getString("height"));
        this.setWidth(dto.getString("width"));
        this.input = dto.getMap("input");
        this.output = dto.getMap("output");
        this.external = dto.getMap("external");
    }

    public abstract FBFormItem cloneItem();

    public abstract Widget cloneDisplay(Map<String, Object> var1);

    protected void populateActions(Element element) {
        for (Map.Entry<String, FBScript> entry : this.getEventActions().entrySet()) {
            if (entry.getValue() == null) continue;
            element.setPropertyJSO(entry.getKey(), this.toJsFunction(entry.getValue().getContent()));
        }
    }

    protected Object getInputValue(Map<String, Object> data) {
        if (this.getInput() != null && this.getInput().get("name") != null && data != null && data.containsKey(this.getInput().get("name"))) {
            return data.get(this.getInput().get("name"));
        }
        return null;
    }

    private native JavaScriptObject toJsFunction(String var1);

    public boolean removeEffectOfType(Class<? extends FBFormEffect> effectClass) {
        FBFormEffect effectToRemove = null;
        if (this.getFormEffects() != null) {
            for (FBFormEffect effect : this.getFormEffects()) {
                if (!effect.getClass().getName().equals(effectClass.getName())) continue;
                effectToRemove = effect;
                break;
            }
        }
        if (effectToRemove != null) {
            return this.effects.remove(effectToRemove);
        }
        return false;
    }

    public boolean hasEffectOfType(Class<? extends FBFormEffect> effectClass) {
        if (this.getFormEffects() != null) {
            for (FBFormEffect effect : this.getFormEffects()) {
                if (!effect.getClass().getName().equals(effectClass.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

