/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.form;

import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.InsertPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jbpm.form.builder.ng.model.client.bus.FormItemSelectionHandler;
import org.jbpm.form.builder.ng.model.client.effect.FBFormEffect;
import org.jbpm.form.builder.ng.model.client.form.FBCompositeItem;
import org.jbpm.form.builder.ng.model.client.form.FBFormItem;
import org.jbpm.form.builder.ng.model.client.form.PhantomPanel;

public abstract class LayoutFormItem
extends FBFormItem
implements FBCompositeItem {
    private List<FBFormItem> items = new ArrayList<FBFormItem>();

    public LayoutFormItem() {
        this(new ArrayList<FBFormEffect>());
    }

    public LayoutFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
    }

    @Override
    public List<FBFormItem> getItems() {
        return this.items;
    }

    public boolean removeItem(FBFormItem item) {
        return this.items.remove((Object)item);
    }

    @Override
    public void setItems(List<FBFormItem> items) {
        this.items = items;
    }

    public int size() {
        return this.items.size();
    }

    public Iterator<FBFormItem> formItemIterator() {
        return this.items.iterator();
    }

    public boolean remove(Widget w) {
        if (w instanceof FBFormItem) {
            FBFormItem item = (FBFormItem)w;
            this.items.remove((Object)item);
        }
        return super.remove(w);
    }

    public boolean remove(Object o) {
        return this.items.remove(o);
    }

    public FBFormItem get(int index) {
        return this.items.get(index);
    }

    public FBFormItem remove(int index) {
        return this.items.remove(index);
    }

    public ListIterator<FBFormItem> formItemListIterator() {
        return this.items.listIterator();
    }

    public boolean add(FBFormItem item) {
        return this.items.add(item);
    }

    @Override
    public abstract void add(PhantomPanel var1, int var2, int var3);

    public FBFormItem insert(int index, FBFormItem newItem) {
        FBFormItem item = null;
        if (index == this.items.size()) {
            item = newItem;
            this.add(item);
        } else {
            if (this.items.get(index) == null || this.isWhiteSpace((Widget)this.items.get(index))) {
                item = this.items.set(index, newItem);
            } else {
                item = newItem;
                while (index < this.items.size()) {
                    item = this.items.set(index, item);
                    ++index;
                }
                this.items.add(item);
            }
            HasWidgets panel = this.getPanel();
            if (panel instanceof InsertPanel) {
                InsertPanel iPanel = (InsertPanel)panel;
                iPanel.insert((Widget)newItem, index);
            }
        }
        return item;
    }

    protected boolean isWhiteSpace(Widget widget) {
        return widget.getElement().getParentElement().getInnerHTML().equals("&nbsp;");
    }

    public abstract HasWidgets getPanel();

    public HasWidgets getUnderlyingLayout(int x, int y) {
        for (FBFormItem item : this.items) {
            HasWidgets newLayout;
            if (!(item instanceof LayoutFormItem) || (newLayout = ((LayoutFormItem)item).getUnderlyingLayout(x, y)) == null) continue;
            return newLayout;
        }
        if (x > this.getAbsoluteLeft() && x < this.getAbsoluteLeft() + this.getOffsetWidth() && y > this.getAbsoluteTop() && y < this.getAbsoluteTop() + this.getOffsetHeight()) {
            return this.getPanel();
        }
        return null;
    }

    @Override
    public void setItemSelectionHandler(FormItemSelectionHandler itemSelectionHandler) {
        super.setItemSelectionHandler(itemSelectionHandler);
        for (FBFormItem item : this.items) {
            item.setItemSelectionHandler(itemSelectionHandler);
        }
    }
}

