/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.form.editors;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.form.FBInplaceEditor;
import org.jbpm.form.builder.ng.model.client.form.editors.FocusWrapper;
import org.jbpm.form.builder.ng.model.client.form.items.HTMLFormItem;
import org.jbpm.form.builder.ng.model.client.messages.I18NConstants;

public class HTMLFormItemEditor
extends FBInplaceEditor {
    private final HTMLFormItem formItem;
    private final I18NConstants i18n = CommonGlobals.getInstance().getI18n();
    private VerticalPanel panel = new VerticalPanel();
    private TextArea editorArea = new TextArea();
    private Button htmlButton = new Button(this.i18n.HTMLEditorHTML());
    private Button textButton = new Button(this.i18n.HTMLEditorText());
    private Button doneButton = new Button(this.i18n.ConfirmButton());
    private FocusWrapper wrapper = new FocusWrapper();

    public HTMLFormItemEditor(HTMLFormItem formItem) {
        this.formItem = formItem;
        HorizontalPanel buttonPanel = new HorizontalPanel();
        this.editorArea.setValue((Object)this.formItem.getHtmlContent());
        this.editorArea.addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                HTMLFormItemEditor.this.wrapper.setValue(false);
            }
        });
        this.editorArea.addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent event) {
                HTMLFormItemEditor.this.wrapper.setValue(true);
            }
        });
        this.editorArea.unsinkEvents(262410);
        this.htmlButton.setEnabled(false);
        buttonPanel.add((Widget)this.createTextButton());
        buttonPanel.add((Widget)this.createHtmlButton());
        this.editorArea.setCharacterWidth(50);
        this.editorArea.setVisibleLines(5);
        this.panel.add((Widget)buttonPanel);
        this.panel.add((Widget)this.editorArea);
        this.panel.add((Widget)this.createDoneButton());
        this.add((Widget)this.panel);
    }

    @Override
    public void focus() {
        this.editorArea.setFocus(true);
    }

    @Override
    public boolean isFocused() {
        return this.wrapper.getValue();
    }

    private Button createDoneButton() {
        this.doneButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (HTMLFormItemEditor.this.textButton.isEnabled()) {
                    String htmlContent = HTMLFormItemEditor.this.editorArea.getValue();
                    HTMLFormItemEditor.this.formItem.setHtmlContent(htmlContent);
                } else {
                    String textContent = HTMLFormItemEditor.this.editorArea.getValue();
                    HTMLFormItemEditor.this.formItem.setTextContent(textContent);
                }
                HTMLFormItemEditor.this.formItem.reset();
            }
        });
        return this.doneButton;
    }

    private Button createHtmlButton() {
        this.htmlButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                HTMLFormItemEditor.this.formItem.setTextContent(HTMLFormItemEditor.this.editorArea.getValue());
                HTMLFormItemEditor.this.editorArea.setValue((Object)HTMLFormItemEditor.this.formItem.getHtmlContent());
                HTMLFormItemEditor.this.textButton.setEnabled(true);
                HTMLFormItemEditor.this.htmlButton.setEnabled(false);
            }
        });
        return this.htmlButton;
    }

    private Button createTextButton() {
        this.textButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                HTMLFormItemEditor.this.formItem.setHtmlContent(HTMLFormItemEditor.this.editorArea.getValue());
                HTMLFormItemEditor.this.editorArea.setValue((Object)HTMLFormItemEditor.this.formItem.getTextContent());
                HTMLFormItemEditor.this.htmlButton.setEnabled(true);
                HTMLFormItemEditor.this.textButton.setEnabled(false);
            }
        });
        return this.textButton;
    }
}

