/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.form.editors;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.bus.UndoableEvent;
import org.jbpm.form.builder.ng.model.client.bus.UndoableHandler;
import org.jbpm.form.builder.ng.model.client.form.FBInplaceEditor;
import org.jbpm.form.builder.ng.model.client.form.editors.FocusWrapper;
import org.jbpm.form.builder.ng.model.client.form.items.LabelFormItem;

public class LabelInplaceEditor
extends FBInplaceEditor {
    private final EventBus bus = CommonGlobals.getInstance().getEventBus();
    private final TextBox textBox = new TextBox();
    private final FocusWrapper wrapper = new FocusWrapper();

    public LabelInplaceEditor(final LabelFormItem item) {
        HorizontalPanel editPanel = new HorizontalPanel();
        editPanel.setBorderWidth(1);
        this.textBox.setValue((Object)item.getLabel().getText());
        this.textBox.addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                LabelInplaceEditor.this.wrapper.setValue(false);
                item.reset();
            }
        });
        this.textBox.addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent event) {
                LabelInplaceEditor.this.wrapper.setValue(true);
            }
        });
        this.textBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                HashMap<String, Object> dataSnapshot = new HashMap<String, Object>();
                dataSnapshot.put("item", item);
                dataSnapshot.put("oldValue", item.getLabel().getText());
                dataSnapshot.put("newValue", LabelInplaceEditor.this.textBox.getValue());
                LabelInplaceEditor.this.bus.fireEvent((GwtEvent)new UndoableEvent(dataSnapshot, new UndoableHandler(){

                    @Override
                    public void undoAction(UndoableEvent event) {
                        LabelFormItem myItem = (LabelFormItem)event.getData("item");
                        String value = (String)event.getData("oldValue");
                        myItem.getLabel().setText(value);
                    }

                    @Override
                    public void onEvent(UndoableEvent event) {
                    }

                    @Override
                    public void doAction(UndoableEvent event) {
                        LabelFormItem myItem = (LabelFormItem)event.getData("item");
                        String value = (String)event.getData("newValue");
                        myItem.getLabel().setText(value);
                    }
                }));
                item.reset();
            }
        });
        editPanel.add((Widget)this.textBox);
        this.textBox.setWidth(item.getLabel().getOffsetWidth() + "px");
        this.textBox.setFocus(true);
        this.add((Widget)editPanel);
    }

    @Override
    public void focus() {
        this.textBox.setFocus(true);
    }

    @Override
    public boolean isFocused() {
        return this.wrapper.getValue();
    }
}

