/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.form.items;

import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.FormBuilderException;
import org.jbpm.form.builder.ng.model.client.effect.FBFormEffect;
import org.jbpm.form.builder.ng.model.client.form.FBFormItem;
import org.jbpm.form.builder.ng.model.client.form.LayoutFormItem;
import org.jbpm.form.builder.ng.model.client.form.PhantomPanel;
import org.jbpm.form.builder.ng.model.client.messages.I18NConstants;
import org.jbpm.form.builder.ng.model.shared.api.FormBuilderDTO;

@Reflectable
public class AbsoluteLayoutFormItem
extends LayoutFormItem {
    private final I18NConstants i18n = CommonGlobals.getInstance().getI18n();
    private AbsolutePanel panel = new AbsolutePanel(){

        public boolean remove(Widget widget) {
            if (widget instanceof FBFormItem) {
                AbsoluteLayoutFormItem.this.remove(widget);
            }
            return super.remove(widget);
        }
    };
    private String id;
    private String oldStyleName = null;

    public AbsoluteLayoutFormItem() {
        this(new ArrayList<FBFormEffect>());
    }

    public AbsoluteLayoutFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.add((Widget)this.panel);
        this.setSize("90px", "90px");
        this.panel.setSize(this.getWidth(), this.getHeight());
    }

    @Override
    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", this.id);
        map.put("height", this.getHeight());
        map.put("width", this.getWidth());
        return map;
    }

    @Override
    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.id = this.extractString(asPropertiesMap.get("id"));
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.populate(this.panel);
    }

    private void populate(AbsolutePanel panel) {
        if (this.getHeight() != null) {
            panel.setHeight(this.getHeight());
        }
        if (this.getWidth() != null) {
            panel.setWidth(this.getWidth());
        }
    }

    @Override
    public FormBuilderDTO getRepresentation() {
        FormBuilderDTO dto = super.getRepresentation();
        dto.setString("id", this.id);
        ArrayList<Object> items = new ArrayList<Object>();
        for (FBFormItem item : this.getItems()) {
            FormBuilderDTO subDto = item.getRepresentation();
            int x = item.getDesiredX() - this.panel.getAbsoluteLeft();
            int y = item.getDesiredY() - this.panel.getAbsoluteTop();
            subDto.setInteger("x", x);
            subDto.setInteger("y", y);
            items.add(subDto.getParameters());
        }
        dto.setList("items", items);
        return dto;
    }

    @Override
    public void populate(FormBuilderDTO dto) throws FormBuilderException {
        if (!dto.getClassName().endsWith("AbsolutePanelRepresentation")) {
            throw new FormBuilderException(this.i18n.RepNotOfType(dto.getClassName(), "AbsolutePanelRepresentation"));
        }
        super.populate(dto);
        this.panel.clear();
        this.getItems().clear();
        List<FormBuilderDTO> items = dto.getListOfDtos("items");
        if (items != null) {
            for (FormBuilderDTO itemDto : items) {
                FBFormItem item = LayoutFormItem.createItem(itemDto);
                item.setDesiredPosition(itemDto.getInteger("x"), itemDto.getInteger("y"));
                this.add(item);
            }
        }
        this.populate(this.panel);
    }

    @Override
    public FBFormItem cloneItem() {
        AbsoluteLayoutFormItem clone = new AbsoluteLayoutFormItem(this.getFormEffects());
        clone.setHeight(this.getHeight());
        clone.id = this.id;
        clone.setWidth(this.getWidth());
        clone.populate(clone.panel);
        for (FBFormItem item : this.getItems()) {
            clone.add(item.cloneItem());
        }
        return clone;
    }

    @Override
    public boolean add(FBFormItem item) {
        int left = item.getDesiredX();
        int top = item.getDesiredY();
        this.panel.add((Widget)item, left - this.panel.getAbsoluteLeft(), top - this.panel.getAbsoluteTop());
        return super.add(item);
    }

    @Override
    public boolean remove(Widget child) {
        return super.remove(child);
    }

    @Override
    public HasWidgets getPanel() {
        return this.panel;
    }

    @Override
    public Widget cloneDisplay(Map<String, Object> data) {
        AbsolutePanel ap = new AbsolutePanel();
        this.populate(ap);
        for (FBFormItem item : this.getItems()) {
            ap.add(item.cloneDisplay(data), this.getAbsoluteLeft() - item.getDesiredX(), this.getAbsoluteTop() - item.getDesiredY());
        }
        super.populateActions(ap.getElement());
        return ap;
    }

    @Override
    public void add(PhantomPanel phantom, int x, int y) {
        String styleName = phantom.getStyleName();
        this.oldStyleName = this.getStyleName();
        this.setStyleName(styleName);
    }

    @Override
    public void replacePhantom(FBFormItem item) {
        if (this.oldStyleName == null) {
            this.removeStyleName(this.getStyleName());
        } else {
            this.setStyleName(this.oldStyleName);
        }
        this.oldStyleName = null;
        this.add(item);
    }
}

