/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.form.items;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.FormBuilderException;
import org.jbpm.form.builder.ng.model.client.bus.ui.NotificationEvent;
import org.jbpm.form.builder.ng.model.client.effect.FBFormEffect;
import org.jbpm.form.builder.ng.model.client.form.FBFormItem;
import org.jbpm.form.builder.ng.model.client.form.LayoutFormItem;
import org.jbpm.form.builder.ng.model.client.form.PhantomPanel;
import org.jbpm.form.builder.ng.model.client.messages.I18NConstants;
import org.jbpm.form.builder.ng.model.shared.api.FormBuilderDTO;

@Reflectable
public class BorderLayoutFormItem
extends LayoutFormItem {
    private EventBus bus = CommonGlobals.getInstance().getEventBus();
    private I18NConstants i18n = CommonGlobals.getInstance().getI18n();
    private Map<Position, FBFormItem> locations = new HashMap<Position, FBFormItem>();
    private Position currentPosition = null;
    private Grid grid = new Grid(1, 1){

        public boolean remove(Widget widget) {
            if (widget instanceof FBFormItem) {
                super.remove(widget);
                return BorderLayoutFormItem.this.remove(widget);
            }
            return super.remove(widget);
        }
    };

    public BorderLayoutFormItem() {
        this(new ArrayList<FBFormEffect>());
    }

    public BorderLayoutFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.add((Widget)this.grid);
        this.grid.setSize("180px", "180px");
        this.setSize("180px", "180px");
    }

    protected void setDropPosition(Position position) {
        this.currentPosition = position;
    }

    protected Position obtainPosition(int x, int y) {
        boolean top;
        int xpos = x - this.grid.getAbsoluteLeft();
        int width = this.grid.getOffsetWidth();
        int ypos = y - this.grid.getAbsoluteTop();
        int height = this.grid.getOffsetHeight();
        boolean left = width / 3 > xpos;
        boolean right = width * 2 / 3 < xpos;
        boolean bottom = height * 2 / 3 < ypos;
        boolean bl = top = height / 3 > ypos;
        if (!(left || right || bottom || top)) {
            return Position.CENTER;
        }
        if (!left && !right && top) {
            return Position.NORTH;
        }
        if (!left && !right && bottom) {
            return Position.SOUTH;
        }
        if (!bottom && !top && right) {
            return Position.EAST;
        }
        if (!bottom && !top && left) {
            return Position.WEST;
        }
        if (top && right) {
            return Position.NORTHEAST;
        }
        if (bottom && right) {
            return Position.SOUTHEAST;
        }
        if (top && left) {
            return Position.NORTHWEST;
        }
        if (bottom && left) {
            return Position.SOUTHWEST;
        }
        return null;
    }

    @Override
    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("width", this.getWidth());
        map.put("height", this.getHeight());
        return map;
    }

    @Override
    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.populate(this.grid);
    }

    private void populate(Grid myGrid) {
        if (this.getHeight() != null && !"".equals(this.getHeight())) {
            this.grid.setHeight(this.getHeight());
        }
        if (this.getWidth() != null && !"".equals(this.getWidth())) {
            this.grid.setWidth(this.getWidth());
        }
    }

    @Override
    public FormBuilderDTO getRepresentation() {
        FormBuilderDTO dto = super.getRepresentation();
        for (Map.Entry<Position, FBFormItem> entry : this.locations.entrySet()) {
            Position key = entry.getKey();
            FormBuilderDTO value = entry.getValue().getRepresentation();
            dto.setMap(key.toString(), value.getParameters());
        }
        return dto;
    }

    @Override
    public void populate(FormBuilderDTO dto) throws FormBuilderException {
        if (!dto.getClassName().endsWith("BorderPanelRepresentation")) {
            throw new FormBuilderException(this.i18n.RepNotOfType(dto.getClassName(), "BorderPanelRepresentation"));
        }
        super.populate(dto);
        for (Map.Entry<String, Object> entry : dto.getParameters().entrySet()) {
            Position key = Position.valueOf(entry.getKey());
            Map subMap = (Map)entry.getValue();
            FormBuilderDTO subDto = new FormBuilderDTO(subMap);
            FBFormItem value = LayoutFormItem.createItem(subDto);
            this.currentPosition = key;
            this.add(value);
        }
    }

    @Override
    public FBFormItem cloneItem() {
        BorderLayoutFormItem clone = super.cloneItem(new BorderLayoutFormItem(this.getFormEffects()));
        clone.currentPosition = this.currentPosition;
        clone.grid = (Grid)this.cloneDisplay(null);
        clone.locations = new HashMap<Position, FBFormItem>(this.locations);
        return clone;
    }

    @Override
    public Widget cloneDisplay(Map<String, Object> data) {
        int rows = this.grid.getRowCount();
        int columns = this.grid.getColumnCount();
        Grid g = new Grid(rows, columns);
        this.populate(g);
        for (int index = 0; index < columns * rows; ++index) {
            int row = index / columns;
            int column = index % columns;
            FBFormItem item = (FBFormItem)this.grid.getWidget(row, column);
            if (item == null) continue;
            g.setWidget(row, column, item.cloneDisplay(data));
        }
        super.populateActions(g.getElement());
        return g;
    }

    @Override
    public HasWidgets getPanel() {
        return this.grid;
    }

    private int getRow(Position pos) {
        int row = 0;
        switch (pos) {
            case NORTH: 
            case NORTHEAST: 
            case NORTHWEST: {
                this.ensureRows();
                row = 0;
                break;
            }
            case SOUTH: 
            case SOUTHEAST: 
            case SOUTHWEST: {
                this.ensureRows();
                row = 2;
                break;
            }
            default: {
                row = this.getMiddleRow();
            }
        }
        return row;
    }

    private int getColumn(Position pos) {
        int col = 0;
        switch (pos) {
            case NORTHEAST: 
            case SOUTHEAST: 
            case EAST: {
                this.ensureColumns();
                col = 2;
                break;
            }
            case NORTHWEST: 
            case SOUTHWEST: 
            case WEST: {
                this.ensureColumns();
                col = 0;
                break;
            }
            default: {
                col = this.getMiddleColumn();
            }
        }
        return col;
    }

    @Override
    public boolean add(FBFormItem item) {
        this.currentPosition = this.obtainPosition(item.getDesiredX(), item.getDesiredY());
        int row = this.getRow(this.currentPosition);
        int col = this.getColumn(this.currentPosition);
        if (this.locations.get((Object)this.currentPosition) == null) {
            this.grid.setWidget(row, col, (Widget)item);
            this.locations.put(this.currentPosition, item);
            this.currentPosition = null;
            return super.add(item);
        }
        this.bus.fireEvent((GwtEvent)new NotificationEvent(NotificationEvent.Level.WARN, this.i18n.BorderLayoutPositionPopulated()));
        return false;
    }

    @Override
    public void add(PhantomPanel phantom, int x, int y) {
        Position pos = this.obtainPosition(x, y);
        if (this.locations.get((Object)pos) == null) {
            this.grid.setWidget(this.getRow(pos), this.getColumn(pos), (Widget)phantom);
        }
    }

    @Override
    public void replacePhantom(FBFormItem item) {
        this.currentPosition = this.obtainPosition(item.getDesiredX(), item.getDesiredY());
        int row = this.getRow(this.currentPosition);
        int col = this.getColumn(this.currentPosition);
        if (this.locations.get((Object)this.currentPosition) == null) {
            this.grid.setWidget(row, col, (Widget)item);
            this.locations.put(this.currentPosition, item);
            this.currentPosition = null;
            super.add(item);
        } else {
            this.bus.fireEvent((GwtEvent)new NotificationEvent(NotificationEvent.Level.WARN, this.i18n.BorderLayoutPositionPopulated()));
        }
    }

    private int getMiddleRow() {
        int row = 0;
        if (this.grid.getRowCount() == 3) {
            row = 1;
        }
        return row;
    }

    private int getMiddleColumn() {
        int col = 0;
        if (this.grid.getColumnCount() == 3) {
            col = 1;
        }
        return col;
    }

    private void ensureRows() {
        if (this.grid.getRowCount() < 3) {
            this.grid.resizeRows(3);
            for (int i = 0; i < 2; ++i) {
                Widget widget;
                if (this.grid.getColumnCount() <= i || (widget = this.grid.getWidget(0, i)) == null) continue;
                this.grid.remove(widget);
                this.grid.setWidget(1, i, widget);
            }
            this.grid.setSize(this.getWidth(), this.getHeight());
        }
    }

    private void ensureColumns() {
        if (this.grid.getColumnCount() < 3) {
            this.grid.resizeColumns(3);
            for (int i = 0; i < 2; ++i) {
                Widget widget;
                if (this.grid.getRowCount() <= i || (widget = this.grid.getWidget(i, 0)) == null) continue;
                this.grid.remove(widget);
                this.grid.setWidget(i, 1, widget);
            }
            this.grid.setSize(this.getWidth(), this.getHeight());
        }
    }

    @Override
    public boolean remove(Widget child) {
        boolean removed = false;
        if (child instanceof FBFormItem) {
            Position pos = null;
            for (Map.Entry<Position, FBFormItem> entry : this.locations.entrySet()) {
                if (!((Object)((Object)entry.getValue())).equals(child)) continue;
                pos = entry.getKey();
                break;
            }
            this.locations.remove((Object)pos);
            this.removeItem((FBFormItem)child);
        } else {
            removed = super.remove(child);
        }
        return removed;
    }

    public static enum Position {
        SOUTH,
        SOUTHWEST,
        WEST,
        NORTHWEST,
        NORTH,
        NORTHEAST,
        EAST,
        SOUTHEAST,
        CENTER;

    }
}

