/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.form.items;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.LinkElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.FormBuilderException;
import org.jbpm.form.builder.ng.model.client.effect.FBFormEffect;
import org.jbpm.form.builder.ng.model.client.form.FBFormItem;
import org.jbpm.form.builder.ng.model.client.form.HasSourceReference;
import org.jbpm.form.builder.ng.model.client.form.LayoutFormItem;
import org.jbpm.form.builder.ng.model.client.form.PhantomPanel;
import org.jbpm.form.builder.ng.model.client.messages.I18NConstants;
import org.jbpm.form.builder.ng.model.shared.api.FormBuilderDTO;

@Reflectable
public class CSSLayoutFormItem
extends LayoutFormItem
implements HasSourceReference {
    private final I18NConstants i18n = CommonGlobals.getInstance().getI18n();
    private FlowPanel panel = new FlowPanel(){

        public boolean remove(Widget w) {
            if (w instanceof FBFormItem) {
                CSSLayoutFormItem.this.removeItem((FBFormItem)w);
            }
            return super.remove(w);
        }
    };
    private LinkElement link = Document.get().createLinkElement();
    private String cssStylesheetUrl;
    private String cssClassName;
    private String id;

    public CSSLayoutFormItem() {
        this(new ArrayList<FBFormEffect>());
    }

    public CSSLayoutFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.setSize("190px", "90px");
        this.panel.setSize(this.getWidth(), this.getHeight());
        this.link.setRel("Stylesheet");
        this.link.setType("text/css");
        this.link.setMedia("screen");
        this.panel.getElement().insertFirst((Node)this.link);
        this.add((Widget)this.panel);
    }

    @Override
    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cssStylesheetUrl", this.cssStylesheetUrl);
        map.put("cssClassName", this.cssClassName);
        map.put("id", this.id);
        map.put("width", this.getWidth());
        map.put("height", this.getHeight());
        return map;
    }

    @Override
    public void saveValues(Map<String, Object> map) {
        this.cssStylesheetUrl = this.extractString(map.get("cssStylesheetUrl"));
        this.cssClassName = this.extractString(map.get("cssClassName"));
        this.id = this.extractString(map.get("id"));
        this.setHeight(this.extractString(map.get("height")));
        this.setWidth(this.extractString(map.get("width")));
        this.populate(this.panel, this.link);
    }

    private void populate(FlowPanel panel, LinkElement style) {
        if (this.getHeight() != null) {
            panel.setHeight(this.getHeight());
        }
        if (this.cssClassName != null) {
            panel.setStyleName(this.cssClassName);
        }
        if (this.getWidth() != null) {
            panel.setWidth(this.getWidth());
        }
        if (this.cssStylesheetUrl != null) {
            style.setHref(this.cssStylesheetUrl);
        }
    }

    @Override
    public FormBuilderDTO getRepresentation() {
        FormBuilderDTO dto = super.getRepresentation();
        ArrayList<Object> items = new ArrayList<Object>();
        for (FBFormItem item : this.getItems()) {
            items.add(item.getRepresentation().getParameters());
        }
        dto.setList("items", items);
        dto.setString("id", this.id);
        dto.setString("cssClassName", this.cssClassName);
        dto.setString("cssStylesheetUrl", this.cssStylesheetUrl);
        return dto;
    }

    @Override
    public void populate(FormBuilderDTO dto) throws FormBuilderException {
        if (!dto.getClassName().endsWith("CSSPanelRepresentation")) {
            throw new FormBuilderException(this.i18n.RepNotOfType(dto.getClassName(), "CSSPanelRepresentation"));
        }
        super.populate(dto);
        this.cssClassName = dto.getString("cssClassName");
        this.id = dto.getString("id");
        this.cssStylesheetUrl = dto.getString("cssStylesheetUrl");
        super.getItems().clear();
        this.populate(this.panel, this.link);
        List<FormBuilderDTO> items = dto.getListOfDtos("items");
        if (items != null) {
            for (FormBuilderDTO itemDto : items) {
                this.add(LayoutFormItem.createItem(itemDto));
            }
        }
    }

    @Override
    public FBFormItem cloneItem() {
        CSSLayoutFormItem clone = super.cloneItem(new CSSLayoutFormItem(this.getFormEffects()));
        clone.cssClassName = this.cssClassName;
        clone.cssStylesheetUrl = this.cssStylesheetUrl;
        clone.id = this.id;
        clone.populate(clone.panel, clone.link);
        for (FBFormItem item : this.getItems()) {
            clone.add(item.cloneItem());
        }
        return clone;
    }

    @Override
    public Widget cloneDisplay(Map<String, Object> data) {
        FlowPanel fp = new FlowPanel();
        fp.getElement().insertFirst(this.link.cloneNode(false));
        this.populate(fp, this.link);
        super.populateActions(fp.getElement());
        for (FBFormItem item : this.getItems()) {
            fp.add(item.cloneDisplay(data));
        }
        return fp;
    }

    @Override
    public HasWidgets getPanel() {
        return this.panel;
    }

    @Override
    public boolean add(FBFormItem item) {
        this.panel.add((Widget)item);
        return super.add(item);
    }

    @Override
    public void add(PhantomPanel phantom, int x, int y) {
        this.panel.add((Widget)phantom);
    }

    @Override
    public void replacePhantom(FBFormItem item) {
        PhantomPanel phantom = null;
        for (Widget widget : this.panel) {
            if (!(widget instanceof PhantomPanel)) continue;
            phantom = (PhantomPanel)widget;
            break;
        }
        if (phantom == null) {
            this.add(item);
        } else {
            int index = this.panel.getWidgetIndex(phantom);
            this.panel.remove((Widget)phantom);
            super.insert(index, item);
        }
    }

    @Override
    public void setSourceReference(String sourceReference) {
        this.cssStylesheetUrl = sourceReference;
        this.link.setHref(this.cssStylesheetUrl);
    }

    @Override
    public String getSourceReference() {
        return this.cssStylesheetUrl;
    }

    @Override
    public List<String> getAllowedTypes() {
        ArrayList<String> retval = new ArrayList<String>();
        retval.add("css");
        return retval;
    }
}

