/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.form.items;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.datepicker.client.DatePicker;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.FormBuilderException;
import org.jbpm.form.builder.ng.model.client.effect.FBFormEffect;
import org.jbpm.form.builder.ng.model.client.form.FBFormItem;
import org.jbpm.form.builder.ng.model.client.messages.I18NConstants;
import org.jbpm.form.builder.ng.model.client.resources.FormBuilderResources;
import org.jbpm.form.builder.ng.model.common.panels.CalendarPanel;
import org.jbpm.form.builder.ng.model.shared.api.FormBuilderDTO;

@Reflectable
public class CalendarFormItem
extends FBFormItem {
    private String defaultValue;
    private String iconUrl;
    private String calendarCss;
    private final I18NConstants i18n = CommonGlobals.getInstance().getI18n();
    private final DateTimeFormat format = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_LONG);
    private final DatePicker calendar = new DatePicker();
    private final Image icon = new Image();
    private final PopupPanel panel = new PopupPanel();
    private final TextBox text = new TextBox();

    public CalendarFormItem() {
        this(new ArrayList<FBFormEffect>());
    }

    public CalendarFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.iconUrl = FormBuilderResources.INSTANCE.calendarSquare().getSafeUri().asString();
        this.icon.setUrl(this.iconUrl);
        this.icon.getElement().getStyle().setCursor(Style.Cursor.POINTER);
        this.icon.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                CalendarFormItem.this.panel.setSize("183px", "183px");
                CalendarFormItem.this.panel.setPopupPosition(event.getClientX(), event.getClientY());
                CalendarFormItem.this.panel.setWidget((Widget)CalendarFormItem.this.calendar);
                CalendarFormItem.this.panel.show();
            }
        });
        this.calendar.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Date>(){

            public void onValueChange(ValueChangeEvent<Date> event) {
                CalendarFormItem.this.panel.hide();
                CalendarFormItem.this.text.setValue((Object)CalendarFormItem.this.format.format((Date)event.getValue()));
            }
        });
        this.calendar.setSize("183px", "183px");
        CalendarPanel cPanel = new CalendarPanel((Widget)this.text, (Widget)this.icon);
        cPanel.add((Widget)this.text);
        cPanel.add((Widget)this.icon);
        this.text.setSize("175px", "21px");
        cPanel.setSize("200px", "21px");
        this.setSize("200px", "21px");
        this.add((Widget)cPanel);
    }

    @Override
    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("width", this.getWidth());
        map.put("height", this.getHeight());
        map.put("iconUrl", this.iconUrl);
        map.put("calendarCss", this.calendarCss);
        map.put("defaultValue", this.defaultValue);
        return map;
    }

    @Override
    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.iconUrl = this.extractString(asPropertiesMap.get("iconUrl"));
        this.calendarCss = this.extractString(asPropertiesMap.get("calendarCss"));
        this.defaultValue = this.extractString(asPropertiesMap.get("defaultValue"));
        this.populate(this.calendar, this.text, this.icon);
    }

    private void populate(DatePicker calendar, TextBox text, Image icon) {
        if (this.getHeight() != null && !"".equals(this.getHeight())) {
            calendar.setHeight(this.getHeight());
        }
        if (this.getWidth() != null && !"".equals(this.getWidth())) {
            calendar.setWidth(this.getWidth());
        }
        if (this.defaultValue != null) {
            if (!"".equals(this.defaultValue)) {
                calendar.setValue(this.format.parse(this.defaultValue));
            } else {
                calendar.setValue(null);
            }
        }
        if (this.calendarCss != null && !"".equals(this.calendarCss)) {
            calendar.setStyleName(this.calendarCss);
        }
        if (this.iconUrl != null && !"".equals(this.iconUrl)) {
            icon.setUrl(this.iconUrl);
        }
        String cursor = icon.getElement().getStyle().getCursor();
        if (!Style.Cursor.POINTER.getCssName().equals(cursor)) {
            icon.getElement().getStyle().setCursor(Style.Cursor.POINTER);
        }
    }

    @Override
    public FormBuilderDTO getRepresentation() {
        FormBuilderDTO dto = super.getRepresentation();
        dto.setString("iconUrl", this.iconUrl);
        dto.setString("calendarCss", this.calendarCss);
        dto.setString("defaultValue", this.defaultValue);
        return dto;
    }

    @Override
    public void populate(FormBuilderDTO dto) throws FormBuilderException {
        if (!dto.getClassName().endsWith("CalendarRepresentation")) {
            throw new FormBuilderException(this.i18n.RepNotOfType(dto.getClassName(), "CalendarRepresentation"));
        }
        super.populate(dto);
        this.calendarCss = dto.getString("calendarCss");
        this.iconUrl = dto.getString("iconUrl");
        this.defaultValue = dto.getString("defaultValue");
        this.populate(this.calendar, this.text, this.icon);
    }

    @Override
    public FBFormItem cloneItem() {
        CalendarFormItem clone = super.cloneItem(new CalendarFormItem());
        clone.calendarCss = this.calendarCss;
        clone.defaultValue = this.defaultValue;
        clone.iconUrl = this.iconUrl;
        this.populate(clone.calendar, clone.text, clone.icon);
        return clone;
    }

    @Override
    public Widget cloneDisplay(Map<String, Object> data) {
        DatePicker date = new DatePicker();
        TextBox textBox = new TextBox();
        final PopupPanel panel = new PopupPanel();
        DatePicker calendar = new DatePicker();
        if (this.calendarCss != null && !"".equals(this.calendarCss)) {
            calendar.setStyleName(this.calendarCss);
        }
        panel.setSize("183px", "183px");
        panel.setWidget((Widget)calendar);
        Image icon = new Image();
        icon.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                panel.setPopupPosition(event.getClientX(), event.getClientY());
                panel.show();
            }
        });
        this.populate(date, textBox, icon);
        CalendarPanel display = new CalendarPanel((Widget)textBox, (Widget)icon);
        Object input = this.getInputValue(data);
        if (input != null) {
            textBox.setValue((Object)input.toString());
        }
        if (this.getOutput() != null && this.getOutput().get("name") != null) {
            textBox.setName(String.valueOf(this.getOutput().get("name")));
        }
        super.populateActions(textBox.getElement());
        return display;
    }
}

