/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.form.items;

import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.FormBuilderException;
import org.jbpm.form.builder.ng.model.client.effect.FBFormEffect;
import org.jbpm.form.builder.ng.model.client.form.FBFormItem;
import org.jbpm.form.builder.ng.model.client.messages.I18NConstants;
import org.jbpm.form.builder.ng.model.shared.api.FormBuilderDTO;

@Reflectable
public class CheckBoxFormItem
extends FBFormItem {
    private final I18NConstants i18n = CommonGlobals.getInstance().getI18n();
    private CheckBox checkBox = new CheckBox();
    private String formValue;
    private Boolean checked;
    private String name;
    private String id;

    public CheckBoxFormItem() {
        this(new ArrayList<FBFormEffect>());
    }

    public CheckBoxFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.add((Widget)this.checkBox);
        this.setWidth("15px");
        this.setHeight("15px");
        this.checkBox.setSize(this.getWidth(), this.getHeight());
    }

    @Override
    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("formValue", this.formValue);
        map.put("checked", this.checked);
        map.put("name", this.name);
        map.put("id", this.id);
        map.put("height", this.getHeight());
        map.put("width", this.getWidth());
        return map;
    }

    @Override
    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.formValue = this.extractString(asPropertiesMap.get("formValue"));
        this.name = this.extractString(asPropertiesMap.get("name"));
        this.id = this.extractString(asPropertiesMap.get("id"));
        this.checked = this.extractBoolean(asPropertiesMap.get("checked"));
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.populate(this.checkBox);
    }

    private void populate(CheckBox checkBox) {
        if (this.formValue != null) {
            checkBox.setFormValue(this.formValue);
        }
        if (this.name != null) {
            checkBox.setName(this.name);
        }
        if (this.checked != null) {
            checkBox.setValue(this.checked);
        }
        if (this.getWidth() != null) {
            checkBox.setWidth(this.getWidth());
        }
        if (this.getHeight() != null) {
            checkBox.setHeight(this.getHeight());
        }
    }

    @Override
    public FormBuilderDTO getRepresentation() {
        FormBuilderDTO dto = super.getRepresentation();
        dto.setString("formValue", this.formValue);
        dto.setString("name", this.name);
        dto.setString("id", this.id);
        dto.setBoolean("checked", this.checked);
        return dto;
    }

    @Override
    public void populate(FormBuilderDTO dto) throws FormBuilderException {
        if (!dto.getClassName().endsWith("CheckBoxRepresentation")) {
            throw new FormBuilderException(this.i18n.RepNotOfType(dto.getClassName(), "CheckBoxRepresentation"));
        }
        super.populate(dto);
        this.formValue = dto.getString("formValue");
        this.name = dto.getString("name");
        this.id = dto.getString("id");
        this.checked = dto.getBoolean("checked");
        this.populate(this.checkBox);
    }

    @Override
    public FBFormItem cloneItem() {
        CheckBoxFormItem clone = new CheckBoxFormItem(this.getFormEffects());
        clone.setWidth(this.getWidth());
        clone.setHeight(this.getHeight());
        clone.checked = this.checked;
        clone.formValue = this.formValue;
        clone.id = this.id;
        clone.name = this.name;
        clone.populate(clone.checkBox);
        return clone;
    }

    @Override
    public Widget cloneDisplay(Map<String, Object> data) {
        CheckBox cb = new CheckBox();
        this.populate(cb);
        Object input = this.getInputValue(data);
        if (input != null) {
            cb.setValue(Boolean.valueOf(input.toString()));
        }
        if (this.getOutput() != null && this.getOutput().get("name") != null) {
            cb.setName(String.valueOf(this.getOutput().get("name")));
        }
        super.populateActions(cb.getElement());
        return cb;
    }
}

