/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.form.items;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.ScriptElement;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.FormBuilderException;
import org.jbpm.form.builder.ng.model.client.effect.FBFormEffect;
import org.jbpm.form.builder.ng.model.client.form.FBFormItem;
import org.jbpm.form.builder.ng.model.client.form.HasSourceReference;
import org.jbpm.form.builder.ng.model.client.messages.I18NConstants;
import org.jbpm.form.builder.ng.model.client.resources.FormBuilderResources;
import org.jbpm.form.builder.ng.model.shared.api.FormBuilderDTO;

@Reflectable
public class ClientScriptFormItem
extends FBFormItem
implements HasSourceReference {
    private final I18NConstants i18n = CommonGlobals.getInstance().getI18n();
    private ScriptElement script = Document.get().createScriptElement();
    private String type = "text/javascript";
    private String src = null;

    public ClientScriptFormItem() {
        this(new ArrayList<FBFormEffect>());
    }

    public ClientScriptFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        Grid border = new Grid(1, 1);
        border.setSize("100px", "20px");
        border.setBorderWidth(1);
        border.getCellFormatter().setHorizontalAlignment(0, 0, HasHorizontalAlignment.ALIGN_CENTER);
        border.getCellFormatter().setVerticalAlignment(0, 0, HasVerticalAlignment.ALIGN_MIDDLE);
        border.setWidget(0, 0, (Widget)new Image(FormBuilderResources.INSTANCE.clientScriptIcon()));
        border.getElement().insertFirst((Node)this.script);
        this.add((Widget)border);
        this.setSize("100px", "20px");
    }

    @Override
    public void setSourceReference(String sourceReference) {
        this.script.setSrc(sourceReference);
    }

    @Override
    public String getSourceReference() {
        return this.script.getSrc();
    }

    @Override
    public List<String> getAllowedTypes() {
        ArrayList<String> retval = new ArrayList<String>();
        retval.add("js");
        return retval;
    }

    private void populate(ScriptElement script) {
        script.setSrc(this.src);
        script.setType(this.type);
    }

    @Override
    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", this.type);
        map.put("src", this.src);
        return map;
    }

    @Override
    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.type = this.extractString(asPropertiesMap.get("type"));
        this.src = this.extractString(asPropertiesMap.get("src"));
        this.populate(this.script);
    }

    @Override
    public FormBuilderDTO getRepresentation() {
        FormBuilderDTO dto = super.getRepresentation();
        dto.setString("type", this.type);
        dto.setString("src", this.src);
        return dto;
    }

    @Override
    public void populate(FormBuilderDTO dto) throws FormBuilderException {
        if (!dto.getClassName().endsWith("ClientScriptRepresentation")) {
            throw new FormBuilderException(this.i18n.RepNotOfType(dto.getClassName(), "ClientScriptRepresentation"));
        }
        super.populate(dto);
        this.src = dto.getString("src");
        this.type = dto.getString("type");
        this.populate(this.script);
    }

    @Override
    public FBFormItem cloneItem() {
        ClientScriptFormItem clone = super.cloneItem(new ClientScriptFormItem());
        clone.src = this.src;
        clone.type = this.type;
        this.populate(clone.script);
        return clone;
    }

    @Override
    public Widget cloneDisplay(Map<String, Object> data) {
        MyWidget widget = new MyWidget();
        widget.set(this.script);
        super.populateActions(widget.getElement());
        return widget;
    }

    class MyWidget
    extends Widget {
        public MyWidget() {
            this.setElement(DOM.createElement((String)"script"));
        }

        public void set(ScriptElement elem) {
            this.getElement().setAttribute("src", elem.getSrc());
            this.getElement().setAttribute("type", elem.getType());
        }
    }
}

