/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.form.items;

import com.google.gwt.dom.client.ButtonElement;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.FormBuilderException;
import org.jbpm.form.builder.ng.model.client.effect.FBFormEffect;
import org.jbpm.form.builder.ng.model.client.form.FBFormItem;
import org.jbpm.form.builder.ng.model.client.form.I18NFormItem;
import org.jbpm.form.builder.ng.model.client.form.I18NUtils;
import org.jbpm.form.builder.ng.model.client.messages.I18NConstants;
import org.jbpm.form.builder.ng.model.shared.api.FormBuilderDTO;

@Reflectable
public class CompleteButtonFormItem
extends FBFormItem
implements I18NFormItem {
    private final I18NConstants i18n = CommonGlobals.getInstance().getI18n();
    private Button button = new Button(this.i18n.CompleteButton());
    private final I18NUtils utils = new I18NUtils();
    private String innerText = this.i18n.CompleteButton();
    private String name;
    private String id;
    private String cssStyleName;

    public CompleteButtonFormItem() {
        this(new ArrayList<FBFormEffect>());
    }

    public CompleteButtonFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.add((Widget)this.button);
        this.setHeight("27px");
        this.setWidth("100px");
        this.button.setSize(this.getWidth(), this.getHeight());
    }

    @Override
    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.name = this.extractString(asPropertiesMap.get("name"));
        this.id = this.extractString(asPropertiesMap.get("id"));
        this.innerText = this.extractString(asPropertiesMap.get("innerText"));
        this.cssStyleName = this.extractString(asPropertiesMap.get("cssStyleName"));
        this.populate(this.button);
    }

    private void populate(Button button) {
        if (this.getHeight() != null) {
            button.setHeight(this.getHeight());
        }
        if (this.getWidth() != null) {
            button.setWidth(this.getWidth());
        }
        if (this.innerText != null) {
            button.setText(this.innerText);
        }
        if (this.cssStyleName != null) {
            button.setStyleName(this.cssStyleName);
        }
    }

    @Override
    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("height", this.getHeight());
        map.put("width", this.getWidth());
        map.put("innerText", this.innerText);
        map.put("cssStyleName", this.cssStyleName);
        map.put("name", this.name);
        map.put("id", this.id);
        return map;
    }

    @Override
    public FormBuilderDTO getRepresentation() {
        FormBuilderDTO dto = super.getRepresentation();
        dto.setString("text", this.innerText);
        dto.setString("name", this.name);
        dto.setString("id", this.id);
        dto.setMapOfStrings("i18n", this.getI18nMap());
        dto.setString("format", this.getFormat() == null ? null : this.getFormat().toString());
        return dto;
    }

    @Override
    public void populate(FormBuilderDTO dto) throws FormBuilderException {
        if (!dto.getClassName().endsWith("CompleteButtonRepresentation")) {
            throw new FormBuilderException(this.i18n.RepNotOfType(dto.getClassName(), "CompleteButtonRepresentation"));
        }
        super.populate(dto);
        this.innerText = dto.getString("text");
        this.name = dto.getString("name");
        this.id = dto.getString("id");
        this.saveI18nMap(dto.getMapOfStrings("i18n"));
        if (dto.getString("format") != null && !"".equals(dto.getString("format"))) {
            this.setFormat(I18NFormItem.Format.valueOf(dto.getString("format")));
        }
        this.populate(this.button);
    }

    @Override
    public FBFormItem cloneItem() {
        CompleteButtonFormItem clone = new CompleteButtonFormItem(this.getFormEffects());
        clone.cssStyleName = this.cssStyleName;
        clone.setHeight(this.getHeight());
        clone.setWidth(this.getWidth());
        clone.id = this.id;
        clone.innerText = this.innerText;
        clone.saveI18nMap(this.getI18nMap());
        clone.name = this.name;
        clone.populate(clone.button);
        clone.setFormat(this.getFormat());
        return clone;
    }

    @Override
    public Widget cloneDisplay(final Map<String, Object> data) {
        Button bt = new Button();
        this.populate(bt);
        Object input = this.getInputValue(data);
        if (input != null) {
            bt.setText(input.toString());
        }
        if (this.getOutput() != null && this.getOutput().get("name") != null) {
            ButtonElement.as((Element)bt.getElement()).setName(String.valueOf(this.getOutput().get("name")));
        }
        bt.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                FormPanel form = (FormPanel)data.get("org.jbpm.formbuilder.FormBuilder.FORM_PANEL");
                form.submit();
            }
        });
        super.populateActions(bt.getElement());
        return bt;
    }

    @Override
    public boolean containsLocale(String localeName) {
        return this.utils.containsLocale(localeName);
    }

    @Override
    public String getI18n(String key) {
        return this.utils.getI18n(key);
    }

    @Override
    public Map<String, String> getI18nMap() {
        return this.utils.getI18nMap();
    }

    @Override
    public void saveI18nMap(Map<String, String> i18nMap) {
        if (i18nMap != null) {
            String defaultI18n = i18nMap.get("default");
            if (defaultI18n != null && !"".equals(defaultI18n)) {
                this.innerText = defaultI18n;
                this.populate(this.button);
            }
            this.utils.saveI18nMap(i18nMap);
        }
    }

    @Override
    public I18NFormItem.Format getFormat() {
        return this.utils.getFormat();
    }

    @Override
    public void setFormat(I18NFormItem.Format format) {
        this.utils.setFormat(format);
    }
}

