/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.form.items;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.FormBuilderException;
import org.jbpm.form.builder.ng.model.client.bus.ui.NotificationEvent;
import org.jbpm.form.builder.ng.model.client.effect.FBFormEffect;
import org.jbpm.form.builder.ng.model.client.form.FBFormItem;
import org.jbpm.form.builder.ng.model.client.form.LayoutFormItem;
import org.jbpm.form.builder.ng.model.client.form.PhantomPanel;
import org.jbpm.form.builder.ng.model.client.messages.I18NConstants;
import org.jbpm.form.builder.ng.model.shared.api.FormBuilderDTO;

@Reflectable
public class ConditionalBlockFormItem
extends LayoutFormItem {
    private final I18NConstants i18n = CommonGlobals.getInstance().getI18n();
    private final EventBus bus = CommonGlobals.getInstance().getEventBus();
    private Grid display = new Grid(2, 1){

        public boolean remove(Widget w) {
            if (w == ConditionalBlockFormItem.this.ifBlock) {
                ConditionalBlockFormItem.this.ifBlock = null;
            }
            if (w == ConditionalBlockFormItem.this.elseBlock) {
                ConditionalBlockFormItem.this.elseBlock = null;
            }
            return super.remove(w);
        }
    };
    private FBFormItem ifBlock = null;
    private FBFormItem elseBlock = null;
    private String conditionScript = "true";

    public ConditionalBlockFormItem() {
        this(new ArrayList<FBFormEffect>());
    }

    public ConditionalBlockFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.display.setBorderWidth(1);
        this.display.setStyleName("conditionalBlockBorder");
        this.display.setSize("100%", "50px");
        this.add((Widget)this.display);
        this.setSize("100%", "50px");
    }

    @Override
    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("conditionScript", this.conditionScript);
        return map;
    }

    @Override
    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.conditionScript = this.extractString(asPropertiesMap.get("conditionScript"));
    }

    @Override
    public FormBuilderDTO getRepresentation() {
        FormBuilderDTO dto = super.getRepresentation();
        dto.setString("condition", this.conditionScript);
        dto.setMap("ifBlock", this.ifBlock == null ? null : this.ifBlock.getRepresentation().getParameters());
        dto.setMap("elseBlock", this.elseBlock == null ? null : this.elseBlock.getRepresentation().getParameters());
        return dto;
    }

    @Override
    public void populate(FormBuilderDTO dto) throws FormBuilderException {
        if (!dto.getClassName().endsWith("ConditionalBlockRepresentation")) {
            throw new FormBuilderException(this.i18n.RepNotOfType(dto.getClassName(), "ConditionalBlockRepresentation"));
        }
        super.populate(dto);
        this.conditionScript = dto.getString("condition");
        FormBuilderDTO ifDto = new FormBuilderDTO(dto.getMap("ifBlock"));
        this.ifBlock = ifDto.getParameters() == null || ifDto.getParameters().isEmpty() ? null : ConditionalBlockFormItem.createItem(ifDto);
        FormBuilderDTO elseDto = new FormBuilderDTO(dto.getMap("elseBlock"));
        this.elseBlock = elseDto.getParameters() == null || elseDto.getParameters().isEmpty() ? null : ConditionalBlockFormItem.createItem(elseDto);
    }

    @Override
    public FBFormItem cloneItem() {
        ConditionalBlockFormItem item = new ConditionalBlockFormItem(super.getFormEffects());
        item.conditionScript = this.conditionScript;
        item.elseBlock = this.elseBlock == null ? null : this.elseBlock.cloneItem();
        item.ifBlock = this.ifBlock == null ? null : this.ifBlock.cloneItem();
        return item;
    }

    @Override
    public Widget cloneDisplay(Map<String, Object> data) {
        Widget actualBlock;
        Widget elseBlock = this.elseBlock == null ? null : this.elseBlock.cloneDisplay(data);
        Widget ifBlock = this.ifBlock == null ? null : this.ifBlock.cloneDisplay(data);
        String condition = this.conditionScript;
        boolean result = this.eval0(condition);
        Widget widget = actualBlock = result ? ifBlock : elseBlock;
        if (actualBlock != null) {
            super.populateActions(actualBlock.getElement());
        }
        return actualBlock;
    }

    private native boolean eval0(String var1);

    @Override
    public HasWidgets getPanel() {
        return this.display;
    }

    @Override
    public void add(PhantomPanel phantom, int x, int y) {
        Element elseDisplay;
        Element ifDisplay = this.display.getCellFormatter().getElement(0, 0);
        if (x > ifDisplay.getAbsoluteLeft() && x < ifDisplay.getAbsoluteRight() && y > ifDisplay.getAbsoluteTop() && y < ifDisplay.getAbsoluteBottom()) {
            this.display.setWidget(0, 0, (Widget)phantom);
        }
        if (x > (elseDisplay = this.display.getCellFormatter().getElement(1, 0)).getAbsoluteLeft() && x < elseDisplay.getAbsoluteRight() && y > elseDisplay.getAbsoluteTop() && y < elseDisplay.getAbsoluteBottom()) {
            this.display.setWidget(1, 0, (Widget)phantom);
        }
    }

    @Override
    public boolean add(FBFormItem item) {
        boolean retval = false;
        if (this.ifBlock != null && this.elseBlock != null) {
            this.bus.fireEvent((GwtEvent)new NotificationEvent(NotificationEvent.Level.WARN, this.i18n.ConditionalBlockFull()));
        } else if (this.ifBlock == null && this.elseBlock == null) {
            this.ifBlock = item;
            this.display.setWidget(0, 0, (Widget)item);
            retval = true;
        } else if (this.ifBlock != null && this.elseBlock == null) {
            this.elseBlock = item;
            this.display.setWidget(1, 0, (Widget)item);
            retval = true;
        } else if (this.ifBlock == null && this.elseBlock != null) {
            this.ifBlock = item;
            this.display.setWidget(1, 0, (Widget)item);
            retval = true;
        }
        return retval;
    }

    @Override
    public void replacePhantom(FBFormItem item) {
        if (this.display.getWidget(0, 0) != null && this.display.getWidget(0, 0) instanceof PhantomPanel) {
            this.ifBlock = item;
            this.display.setWidget(0, 0, (Widget)item);
        } else if (this.display.getWidget(1, 0) != null && this.display.getWidget(1, 0) instanceof PhantomPanel) {
            this.elseBlock = item;
            this.display.setWidget(1, 0, (Widget)item);
        }
    }
}

