/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.form.items;

import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.FormBuilderException;
import org.jbpm.form.builder.ng.model.client.effect.FBFormEffect;
import org.jbpm.form.builder.ng.model.client.form.FBFormItem;
import org.jbpm.form.builder.ng.model.client.form.I18NFormItem;
import org.jbpm.form.builder.ng.model.client.form.I18NUtils;
import org.jbpm.form.builder.ng.model.client.form.LayoutFormItem;
import org.jbpm.form.builder.ng.model.client.form.PhantomPanel;
import org.jbpm.form.builder.ng.model.client.messages.I18NConstants;
import org.jbpm.form.builder.ng.model.common.panels.FieldSetPanel;
import org.jbpm.form.builder.ng.model.shared.api.FormBuilderDTO;

@Reflectable
public class FieldSetLayoutFormItem
extends LayoutFormItem
implements I18NFormItem {
    private final I18NConstants i18n = CommonGlobals.getInstance().getI18n();
    private final I18NUtils utils = new I18NUtils();
    private String cssClassName;
    private String id;
    private String legend;
    private FieldSetPanel panel = new FieldSetPanel(){

        public boolean remove(Widget w) {
            if (w instanceof FBFormItem) {
                FieldSetLayoutFormItem.this.removeItem((FBFormItem)w);
            }
            return super.remove(w);
        }
    };

    public FieldSetLayoutFormItem() {
        this(new ArrayList<FBFormEffect>());
    }

    public FieldSetLayoutFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.setSize("250px", "120px");
        this.panel.setSize(this.getWidth(), this.getHeight());
        this.add((Widget)this.panel);
    }

    @Override
    public void replacePhantom(FBFormItem item) {
        PhantomPanel phantom = null;
        Iterator i$ = this.panel.iterator();
        while (i$.hasNext()) {
            Widget widget = (Widget)i$.next();
            if (!(widget instanceof PhantomPanel)) continue;
            phantom = (PhantomPanel)widget;
            break;
        }
        if (phantom != null) {
            int index = this.panel.getWidgetIndex((Widget)phantom);
            super.insert(index, item);
            this.remove((Widget)phantom);
        } else {
            this.add(item);
        }
    }

    @Override
    public boolean add(FBFormItem item) {
        this.panel.add((Widget)item);
        return super.add(item);
    }

    @Override
    public void add(PhantomPanel phantom, int x, int y) {
        for (int index = 0; index < this.panel.getWidgetCount(); ++index) {
            Widget item = this.panel.getWidget(index);
            int left = item.getAbsoluteLeft();
            int right = left + item.getOffsetWidth();
            int top = item.getAbsoluteTop();
            int bottom = top + item.getOffsetHeight();
            if (x <= left || x >= right || y <= top || y >= bottom) continue;
            this.panel.insert((Widget)phantom, index);
            break;
        }
    }

    @Override
    public HasWidgets getPanel() {
        return this.panel;
    }

    @Override
    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> formItemPropertiesMap = new HashMap<String, Object>();
        formItemPropertiesMap.put("height", this.getHeight());
        formItemPropertiesMap.put("width", this.getWidth());
        formItemPropertiesMap.put("cssClassName", this.cssClassName);
        formItemPropertiesMap.put("legend", this.legend);
        formItemPropertiesMap.put("id", this.id);
        return formItemPropertiesMap;
    }

    @Override
    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.cssClassName = this.extractString(asPropertiesMap.get("cssClassName"));
        this.id = this.extractString(asPropertiesMap.get("id"));
        this.legend = this.extractString(asPropertiesMap.get("legend"));
        this.populate(this.panel);
    }

    private void populate(FieldSetPanel panel) {
        if (this.getHeight() != null) {
            panel.setHeight(this.getHeight());
        }
        if (this.cssClassName != null) {
            panel.setStyleName(this.cssClassName);
        }
        if (this.legend != null) {
            panel.setLegend(this.legend);
        }
        if (this.id != null) {
            panel.setId(this.id);
        }
        if (this.getWidth() != null) {
            panel.setWidth(this.getWidth());
        }
    }

    @Override
    public void populate(FormBuilderDTO dto) throws FormBuilderException {
        if (!dto.getClassName().endsWith("FieldSetPanelRepresentation")) {
            throw new FormBuilderException(this.i18n.RepNotOfType(dto.getClassName(), "FieldSetPanelRepresentation"));
        }
        super.populate(dto);
        this.cssClassName = dto.getString("cssClassName");
        this.id = dto.getString("id");
        this.legend = dto.getString("legend");
        this.populate(this.panel);
        List<FormBuilderDTO> items = dto.getListOfDtos("items");
        if (items != null) {
            for (FormBuilderDTO itemDto : items) {
                this.add(LayoutFormItem.createItem(itemDto));
            }
        }
    }

    @Override
    public FormBuilderDTO getRepresentation() {
        FormBuilderDTO dto = super.getRepresentation();
        dto.setString("cssClassName", this.cssClassName);
        dto.setString("id", this.id);
        dto.setString("legend", this.legend);
        ArrayList<Object> items = new ArrayList<Object>();
        for (FBFormItem item : this.getItems()) {
            items.add(item.getRepresentation().getParameters());
        }
        dto.setMapOfStrings("i18n", this.getI18nMap());
        dto.setList("items", items);
        return dto;
    }

    @Override
    public FBFormItem cloneItem() {
        FieldSetLayoutFormItem clone = super.cloneItem(new FieldSetLayoutFormItem(this.getFormEffects()));
        clone.cssClassName = this.cssClassName;
        clone.id = this.id;
        clone.legend = this.legend;
        clone.populate(clone.panel);
        for (FBFormItem item : this.getItems()) {
            clone.add(item.cloneItem());
        }
        return clone;
    }

    @Override
    public Widget cloneDisplay(Map<String, Object> formData) {
        FieldSetPanel fsp = new FieldSetPanel();
        this.populate(fsp);
        String value = (String)this.getInputValue(formData);
        if (value != null) {
            fsp.setLegend(value);
        } else {
            String i18nText;
            String locale = (String)formData.get("org.jbpm.formbuilder.server.render.Renderer.BASE_LOCALE");
            fsp.setLegend(this.legend);
            if (locale != null && (i18nText = this.getI18n(locale)) != null && !"".equals(i18nText)) {
                fsp.setLegend(i18nText);
            }
        }
        super.populateActions(fsp.getElement());
        for (FBFormItem item : this.getItems()) {
            fsp.add(item.cloneDisplay(formData));
        }
        return fsp;
    }

    @Override
    public boolean containsLocale(String localeName) {
        return this.utils.containsLocale(localeName);
    }

    @Override
    public I18NFormItem.Format getFormat() {
        return this.utils.getFormat();
    }

    @Override
    public String getI18n(String key) {
        return this.utils.getI18n(key);
    }

    @Override
    public Map<String, String> getI18nMap() {
        return this.utils.getI18nMap();
    }

    @Override
    public void saveI18nMap(Map<String, String> i18nMap) {
        this.utils.saveI18nMap(i18nMap);
    }

    @Override
    public void setFormat(I18NFormItem.Format format) {
        this.utils.setFormat(format);
    }
}

