/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.form.items;

import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.FormBuilderException;
import org.jbpm.form.builder.ng.model.client.effect.FBFormEffect;
import org.jbpm.form.builder.ng.model.client.form.FBFormItem;
import org.jbpm.form.builder.ng.model.client.messages.I18NConstants;
import org.jbpm.form.builder.ng.model.shared.api.FormBuilderDTO;

@Reflectable
public class FileInputFormItem
extends FBFormItem {
    private final I18NConstants i18n = CommonGlobals.getInstance().getI18n();
    private FileUpload fileUpload = new FileUpload();
    private String name;
    private String id;
    private String accept;

    public FileInputFormItem() {
        this(new ArrayList<FBFormEffect>());
    }

    public FileInputFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.add((Widget)this.fileUpload);
        this.setHeight("27px");
        this.setWidth("100px");
        this.fileUpload.setSize(this.getWidth(), this.getHeight());
    }

    @Override
    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", this.name);
        map.put("id", this.id);
        map.put("width", this.getWidth());
        map.put("height", this.getHeight());
        map.put("accept", this.accept);
        return map;
    }

    @Override
    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.name = this.extractString(asPropertiesMap.get("name"));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.id = this.extractString(asPropertiesMap.get("id"));
        this.accept = this.extractString(asPropertiesMap.get("accept"));
        this.populate(this.fileUpload);
    }

    private void populate(FileUpload fileUpload) {
        if (this.name != null) {
            fileUpload.setName(this.name);
        }
        if (this.getWidth() != null) {
            fileUpload.setWidth(this.getWidth());
        }
        if (this.getHeight() != null) {
            fileUpload.setHeight(this.getHeight());
        }
    }

    @Override
    public FormBuilderDTO getRepresentation() {
        FormBuilderDTO rep = super.getRepresentation();
        rep.setString("id", this.id);
        rep.setString("name", this.name);
        rep.setString("accept", this.accept);
        return rep;
    }

    @Override
    public void populate(FormBuilderDTO dto) throws FormBuilderException {
        if (!dto.getClassName().endsWith("FileInputRepresentation")) {
            throw new FormBuilderException(this.i18n.RepNotOfType(dto.getClassName(), "FileInputRepresentation"));
        }
        super.populate(dto);
        this.id = dto.getString("id");
        this.name = dto.getString("name");
        this.accept = dto.getString("accept");
        this.populate(this.fileUpload);
    }

    @Override
    public FBFormItem cloneItem() {
        FileInputFormItem clone = new FileInputFormItem(this.getFormEffects());
        clone.accept = this.accept;
        clone.setHeight(this.getHeight());
        clone.id = this.id;
        clone.name = this.name;
        clone.setWidth(this.getWidth());
        clone.populate(clone.fileUpload);
        return clone;
    }

    @Override
    public Widget cloneDisplay(Map<String, Object> data) {
        FileUpload fu = new FileUpload();
        this.populate(fu);
        if (this.getOutput() != null && this.getOutput().get("name") != null) {
            fu.setName(String.valueOf(this.getOutput().get("name")));
        }
        super.populateActions(fu.getElement());
        return fu;
    }
}

