/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.form.items;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.FormBuilderException;
import org.jbpm.form.builder.ng.model.client.effect.FBFormEffect;
import org.jbpm.form.builder.ng.model.client.form.FBFormItem;
import org.jbpm.form.builder.ng.model.client.form.LayoutFormItem;
import org.jbpm.form.builder.ng.model.client.form.PhantomPanel;
import org.jbpm.form.builder.ng.model.client.messages.I18NConstants;
import org.jbpm.form.builder.ng.model.shared.api.FormBuilderDTO;

@Reflectable
public class FlowLayoutFormItem
extends LayoutFormItem {
    private final I18NConstants i18n = CommonGlobals.getInstance().getI18n();
    private FlowPanel panel = new FlowPanel(){

        public boolean remove(Widget w) {
            if (w instanceof FBFormItem) {
                FlowLayoutFormItem.this.removeItem((FBFormItem)w);
            }
            return super.remove(w);
        }
    };
    private String cssClassName;
    private String id;

    public FlowLayoutFormItem() {
        this(new ArrayList<FBFormEffect>());
    }

    public FlowLayoutFormItem(List<FBFormEffect> effects) {
        super(effects);
        this.setSize("190px", "90px");
        this.panel.setSize(this.getWidth(), this.getHeight());
        this.add((Widget)this.panel);
    }

    private void populate(FlowPanel panel) {
        if (this.getHeight() != null) {
            panel.setHeight(this.getHeight());
        }
        if (this.cssClassName != null) {
            panel.setStyleName(this.cssClassName);
        }
        if (this.getWidth() != null) {
            panel.setWidth(this.getWidth());
        }
    }

    @Override
    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> formItemPropertiesMap = new HashMap<String, Object>();
        formItemPropertiesMap.put("height", this.getHeight());
        formItemPropertiesMap.put("width", this.getWidth());
        formItemPropertiesMap.put("cssClassName", this.cssClassName);
        formItemPropertiesMap.put("id", this.id);
        return formItemPropertiesMap;
    }

    @Override
    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.cssClassName = this.extractString(asPropertiesMap.get("cssClassName"));
        this.id = this.extractString(asPropertiesMap.get("id"));
        this.populate(this.panel);
    }

    @Override
    public FormBuilderDTO getRepresentation() {
        FormBuilderDTO dto = super.getRepresentation();
        ArrayList<Object> itemMaps = new ArrayList<Object>();
        for (FBFormItem item : this.getItems()) {
            itemMaps.add(item.getRepresentation().getParameters());
        }
        dto.setList("items", itemMaps);
        dto.setString("id", this.id);
        dto.setString("cssClassName", this.cssClassName);
        return dto;
    }

    @Override
    public void populate(FormBuilderDTO dto) throws FormBuilderException {
        if (!dto.getClassName().endsWith("FlowPanelRepresentation")) {
            throw new FormBuilderException(this.i18n.RepNotOfType(dto.getClassName(), "FlowPanelRepresentation"));
        }
        super.populate(dto);
        this.cssClassName = dto.getString("cssClassName");
        this.id = dto.getString("id");
        super.getItems().clear();
        this.populate(this.panel);
        List<FormBuilderDTO> itemDtos = dto.getListOfDtos("items");
        if (itemDtos != null) {
            for (FormBuilderDTO subDto : itemDtos) {
                this.add(LayoutFormItem.createItem(subDto));
            }
        }
    }

    @Override
    public FBFormItem cloneItem() {
        FlowLayoutFormItem clone = super.cloneItem(new FlowLayoutFormItem(this.getFormEffects()));
        clone.cssClassName = this.cssClassName;
        clone.id = this.id;
        clone.populate(clone.panel);
        for (FBFormItem item : this.getItems()) {
            clone.add(item.cloneItem());
        }
        return clone;
    }

    @Override
    public Widget cloneDisplay(Map<String, Object> data) {
        FlowPanel fp = new FlowPanel();
        this.populate(fp);
        super.populateActions(fp.getElement());
        for (FBFormItem item : this.getItems()) {
            fp.add(item.cloneDisplay(data));
        }
        return fp;
    }

    @Override
    public HasWidgets getPanel() {
        return this.panel;
    }

    @Override
    public boolean add(FBFormItem item) {
        this.panel.add((Widget)item);
        return super.add(item);
    }

    @Override
    public void add(PhantomPanel phantom, int x, int y) {
        for (int index = 0; index < this.panel.getWidgetCount(); ++index) {
            Widget item = this.panel.getWidget(index);
            int left = item.getAbsoluteLeft();
            int right = left + item.getOffsetWidth();
            int top = item.getAbsoluteTop();
            int bottom = top + item.getOffsetHeight();
            if (x <= left || x >= right || y <= top || y >= bottom) continue;
            this.panel.insert((Widget)phantom, index);
            break;
        }
    }

    @Override
    public void replacePhantom(FBFormItem item) {
        PhantomPanel phantom = null;
        for (Widget widget : this.panel) {
            if (!(widget instanceof PhantomPanel)) continue;
            phantom = (PhantomPanel)widget;
            break;
        }
        if (phantom != null) {
            int index = this.panel.getWidgetIndex(phantom);
            super.insert(index, item);
            this.remove((Widget)phantom);
        } else {
            this.add(item);
        }
    }
}

