/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.form.items;

import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.FormBuilderException;
import org.jbpm.form.builder.ng.model.client.effect.FBFormEffect;
import org.jbpm.form.builder.ng.model.client.form.FBFormItem;
import org.jbpm.form.builder.ng.model.client.form.FBInplaceEditor;
import org.jbpm.form.builder.ng.model.client.form.editors.HTMLFormItemEditor;
import org.jbpm.form.builder.ng.model.client.messages.I18NConstants;
import org.jbpm.form.builder.ng.model.shared.api.FormBuilderDTO;

@Reflectable
public class HTMLFormItem
extends FBFormItem {
    private final I18NConstants i18n = CommonGlobals.getInstance().getI18n();
    private HTML html = new HTML();

    public HTMLFormItem() {
        this(new ArrayList<FBFormEffect>());
    }

    public HTMLFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.html.setHTML("<div style=\"background-color: #DDDDDD; \">HTML: Click to edit</div>");
        this.add((Widget)this.html);
        this.setWidth("200px");
        this.setHeight("100px");
        this.setSize(this.getWidth(), this.getHeight());
    }

    @Override
    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("width", this.getWidth());
        map.put("height", this.getHeight());
        return map;
    }

    @Override
    public FBInplaceEditor createInplaceEditor() {
        return new HTMLFormItemEditor(this);
    }

    @Override
    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.populate(this.html);
    }

    private void populate(HTML html) {
        if (this.getWidth() != null) {
            html.setWidth(this.getWidth());
        }
        if (this.getHeight() != null) {
            html.setHeight(this.getHeight());
        }
    }

    public void setContent(String html) {
        this.html.setHTML(html);
    }

    @Override
    public FormBuilderDTO getRepresentation() {
        FormBuilderDTO dto = super.getRepresentation();
        dto.setString("content", this.html.getHTML());
        return dto;
    }

    @Override
    public void populate(FormBuilderDTO dto) throws FormBuilderException {
        if (!dto.getClassName().endsWith("HTMLRepresentation")) {
            throw new FormBuilderException(this.i18n.RepNotOfType(dto.getClassName(), "HTMLRepresentation"));
        }
        super.populate(dto);
        this.setContent(dto.getString("content"));
    }

    @Override
    public FBFormItem cloneItem() {
        HTMLFormItem clone = new HTMLFormItem(this.getFormEffects());
        clone.setHeight(this.getHeight());
        clone.setWidth(this.getWidth());
        clone.setContent(this.html.getHTML());
        clone.populate(clone.html);
        return clone;
    }

    public String getTextContent() {
        return this.html.getText();
    }

    public String getHtmlContent() {
        return this.html.getHTML();
    }

    public void setTextContent(String textContent) {
        this.html.setText(textContent);
    }

    public void setHtmlContent(String htmlContent) {
        this.html.setHTML(htmlContent);
    }

    @Override
    public Widget cloneDisplay(Map<String, Object> data) {
        HTML html = new HTML();
        html.setHTML(this.html.getHTML());
        this.populate(html);
        super.populateActions(html.getElement());
        return html;
    }
}

