/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.form.items;

import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.FormBuilderException;
import org.jbpm.form.builder.ng.model.client.effect.FBFormEffect;
import org.jbpm.form.builder.ng.model.client.form.FBFormItem;
import org.jbpm.form.builder.ng.model.client.form.FBInplaceEditor;
import org.jbpm.form.builder.ng.model.client.form.I18NFormItem;
import org.jbpm.form.builder.ng.model.client.form.I18NUtils;
import org.jbpm.form.builder.ng.model.client.form.editors.HeaderInplaceEditor;
import org.jbpm.form.builder.ng.model.client.messages.I18NConstants;
import org.jbpm.form.builder.ng.model.shared.api.FormBuilderDTO;

@Reflectable
public class HeaderFormItem
extends FBFormItem
implements I18NFormItem {
    private final I18NConstants i18n = CommonGlobals.getInstance().getI18n();
    private final HTML header = new HTML("<h1>" + this.i18n.MenuItemHeader() + "</h1>");
    private final I18NUtils utils = new I18NUtils();
    private String id;
    private String name;
    private String cssClassName;

    public HeaderFormItem() {
        this(new ArrayList<FBFormEffect>());
    }

    public HeaderFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.add((Widget)this.getHeader());
        this.setWidth("99%");
        this.setHeight("30px");
        this.getHeader().setSize(this.getWidth(), this.getHeight());
    }

    @Override
    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> formItemPropertiesMap = new HashMap<String, Object>();
        formItemPropertiesMap.put("id", this.id);
        formItemPropertiesMap.put("name", this.name);
        formItemPropertiesMap.put("width", this.getWidth());
        formItemPropertiesMap.put("height", this.getHeight());
        formItemPropertiesMap.put("cssClassName", this.cssClassName);
        return formItemPropertiesMap;
    }

    @Override
    public FBInplaceEditor createInplaceEditor() {
        return new HeaderInplaceEditor(this);
    }

    @Override
    public void saveValues(Map<String, Object> propertiesMap) {
        this.id = this.extractString(propertiesMap.get("id"));
        this.name = this.extractString(propertiesMap.get("name"));
        this.setWidth(this.extractString(propertiesMap.get("width")));
        this.setHeight(this.extractString(propertiesMap.get("height")));
        this.cssClassName = this.extractString(propertiesMap.get("cssClassName"));
        this.populate(this.getHeader());
    }

    private void populate(HTML html) {
        if (this.getWidth() != null) {
            html.setWidth(this.getWidth());
        }
        if (this.getHeight() != null) {
            html.setHeight(this.getHeight());
        }
        if (this.cssClassName != null) {
            html.setStyleName(this.cssClassName);
        }
    }

    public HTML getHeader() {
        return this.header;
    }

    public void setContent(String html) {
        this.getHeader().setHTML(html);
    }

    @Override
    public void addEffect(FBFormEffect effect) {
        super.addEffect(effect);
        effect.setWidget((Widget)this.header);
    }

    @Override
    public FormBuilderDTO getRepresentation() {
        FormBuilderDTO dto = super.getRepresentation();
        dto.setString("value", this.header.getText());
        dto.setString("styleClass", this.cssClassName);
        dto.setString("cssId", this.id);
        dto.setString("cssName", this.name);
        dto.setMapOfStrings("i18n", this.getI18nMap());
        dto.setString("format", this.getFormat() == null ? null : this.getFormat().toString());
        return dto;
    }

    @Override
    public void populate(FormBuilderDTO dto) throws FormBuilderException {
        if (!dto.getClassName().endsWith("HeaderRepresentation")) {
            throw new FormBuilderException(this.i18n.RepNotOfType(dto.getClassName(), "HeaderRepresentation"));
        }
        super.populate(dto);
        this.cssClassName = dto.getString("cssName");
        this.id = dto.getString("cssId");
        this.saveI18nMap(dto.getMapOfStrings("i18n"));
        if (dto.getString("value").startsWith("<h1>")) {
            this.setContent(dto.getString("value"));
        } else {
            this.setContent("<h1>" + dto.getString("value") + "</h1>");
        }
        if (dto.getString("format") != null && !"".equals(dto.getString("format"))) {
            this.setFormat(I18NFormItem.Format.valueOf(dto.getString("format")));
        }
    }

    @Override
    public FBFormItem cloneItem() {
        HeaderFormItem clone = super.cloneItem(new HeaderFormItem(this.getFormEffects()));
        clone.cssClassName = this.cssClassName;
        clone.id = this.id;
        clone.name = this.name;
        clone.setContent(this.header.getHTML());
        clone.saveI18nMap(this.getI18nMap());
        clone.setFormat(this.getFormat());
        clone.populate(this.header);
        return clone;
    }

    @Override
    public Widget cloneDisplay(Map<String, Object> data) {
        HTML html = new HTML(this.header.getHTML());
        this.populate(html);
        String value = (String)this.getInputValue(data);
        if (value != null) {
            html.setHTML("<h1>" + value + "</h1>");
        } else {
            String i18nText;
            String locale = (String)data.get("org.jbpm.formbuilder.server.render.Renderer.BASE_LOCALE");
            html.setHTML(this.header.getHTML());
            if (locale != null && (i18nText = this.getI18n(locale)) != null && !"".equals(i18nText)) {
                html.setHTML("<h1>" + i18nText + "</h1>");
            }
        }
        super.populateActions(html.getElement());
        return html;
    }

    @Override
    public boolean containsLocale(String localeName) {
        return this.utils.containsLocale(localeName);
    }

    @Override
    public String getI18n(String key) {
        return this.utils.getI18n(key);
    }

    @Override
    public Map<String, String> getI18nMap() {
        return this.utils.getI18nMap();
    }

    @Override
    public void saveI18nMap(Map<String, String> i18nMap) {
        if (i18nMap != null) {
            String defaultI18n = i18nMap.get("default");
            if (defaultI18n != null && !"".equals(defaultI18n)) {
                this.header.setHTML("<h1>" + defaultI18n + "</h1>");
            }
            this.utils.saveI18nMap(i18nMap);
        }
    }

    @Override
    public I18NFormItem.Format getFormat() {
        return this.utils.getFormat();
    }

    @Override
    public void setFormat(I18NFormItem.Format format) {
        this.utils.setFormat(format);
    }
}

