/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.form.items;

import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Hidden;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.FormBuilderException;
import org.jbpm.form.builder.ng.model.client.effect.FBFormEffect;
import org.jbpm.form.builder.ng.model.client.form.FBFormItem;
import org.jbpm.form.builder.ng.model.client.messages.I18NConstants;
import org.jbpm.form.builder.ng.model.client.resources.FormBuilderResources;
import org.jbpm.form.builder.ng.model.shared.api.FormBuilderDTO;

@Reflectable
public class HiddenFormItem
extends FBFormItem {
    private final I18NConstants i18n = CommonGlobals.getInstance().getI18n();
    private Hidden hidden = new Hidden();
    private String id;
    private String name;
    private String value;

    public HiddenFormItem() {
        this(new ArrayList<FBFormEffect>());
    }

    public HiddenFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        Grid border = new Grid(1, 1);
        border.setSize("100px", "20px");
        border.setBorderWidth(1);
        border.getCellFormatter().setHorizontalAlignment(0, 0, HasHorizontalAlignment.ALIGN_CENTER);
        border.getCellFormatter().setVerticalAlignment(0, 0, HasVerticalAlignment.ALIGN_MIDDLE);
        border.setWidget(0, 0, (Widget)new Image(FormBuilderResources.INSTANCE.hiddenFieldIcon()));
        this.add((Widget)border);
        this.setSize("100px", "20px");
    }

    @Override
    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("value", this.value);
        map.put("name", this.name);
        map.put("id", this.id);
        return map;
    }

    @Override
    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.value = this.extractString(asPropertiesMap.get("value"));
        this.name = this.extractString(asPropertiesMap.get("name"));
        this.id = this.extractString(asPropertiesMap.get("id"));
        this.populate(this.hidden);
    }

    private void populate(Hidden hidden) {
        if (this.id != null) {
            hidden.setID(this.id);
        }
        if (this.name != null && !"".equals(this.name)) {
            hidden.setName(this.name);
        }
        if (this.value != null) {
            hidden.setValue(this.value);
        }
    }

    @Override
    public FormBuilderDTO getRepresentation() {
        FormBuilderDTO dto = super.getRepresentation();
        dto.setString("id", this.id);
        dto.setString("name", this.name);
        dto.setString("value", this.value);
        return dto;
    }

    @Override
    public void populate(FormBuilderDTO dto) throws FormBuilderException {
        if (!dto.getClassName().endsWith("HiddenRepresentation")) {
            throw new FormBuilderException(this.i18n.RepNotOfType(dto.getClassName(), "HiddenRepresentation"));
        }
        super.populate(dto);
        this.id = dto.getString("id");
        this.name = dto.getString("name");
        this.value = dto.getString("value");
        this.populate(this.hidden);
    }

    @Override
    public FBFormItem cloneItem() {
        HiddenFormItem clone = new HiddenFormItem(this.getFormEffects());
        clone.id = this.id;
        clone.name = this.name;
        clone.value = this.value;
        clone.populate(clone.hidden);
        return clone;
    }

    @Override
    public Widget cloneDisplay(Map<String, Object> data) {
        Hidden hi = new Hidden();
        this.populate(hi);
        Object input = this.getInputValue(data);
        if (input != null) {
            hi.setValue(input.toString());
        }
        if (this.getOutput() != null && this.getOutput().get("name") != null && !"".equals(this.getOutput().get("name"))) {
            hi.setName(String.valueOf(this.getOutput().get("name")));
        }
        super.populateActions(hi.getElement());
        return hi;
    }
}

