/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.form.items;

import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.FormBuilderException;
import org.jbpm.form.builder.ng.model.client.effect.FBFormEffect;
import org.jbpm.form.builder.ng.model.client.form.FBFormItem;
import org.jbpm.form.builder.ng.model.client.form.HasSourceReference;
import org.jbpm.form.builder.ng.model.client.form.I18NFormItem;
import org.jbpm.form.builder.ng.model.client.form.I18NUtils;
import org.jbpm.form.builder.ng.model.client.messages.I18NConstants;
import org.jbpm.form.builder.ng.model.client.resources.FormBuilderResources;
import org.jbpm.form.builder.ng.model.shared.api.FormBuilderDTO;

@Reflectable
public class ImageFormItem
extends FBFormItem
implements I18NFormItem,
HasSourceReference {
    private Image image = new Image();
    private final I18NConstants i18n = CommonGlobals.getInstance().getI18n();
    private final I18NUtils utils = new I18NUtils();
    private String altText;
    private String url;
    private String id;

    public ImageFormItem() {
        this(new ArrayList<FBFormEffect>());
    }

    public ImageFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.image.setResource(FormBuilderResources.INSTANCE.defaultImage());
        this.add((Widget)this.image);
        this.setWidth("200px");
        this.setHeight("150px");
    }

    @Override
    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("altText", this.altText);
        map.put("height", this.getHeight());
        map.put("width", this.getWidth());
        map.put("url", this.url);
        map.put("id", this.id);
        return map;
    }

    @Override
    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.altText = this.extractString(asPropertiesMap.get("altText"));
        Map<String, String> i18nMap = this.getI18nMap();
        i18nMap.put("default", this.altText);
        this.saveI18nMap(i18nMap);
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.url = this.extractString(asPropertiesMap.get("url"));
        this.id = this.extractString(asPropertiesMap.get("id"));
        this.populate(this.image);
    }

    private void populate(Image image) {
        if (this.altText != null) {
            image.setAltText(this.altText);
            image.setTitle(this.altText);
        }
        if (this.getHeight() != null) {
            image.setHeight(this.getHeight());
        }
        if (this.getWidth() != null) {
            image.setWidth(this.getWidth());
        }
        if (this.url != null && !"".equals(this.url)) {
            image.setUrl(this.url);
        }
    }

    @Override
    public FormBuilderDTO getRepresentation() {
        FormBuilderDTO dto = super.getRepresentation();
        dto.setString("altText", this.altText);
        dto.setString("url", this.url);
        dto.setString("id", this.id);
        dto.setMapOfStrings("i18n", this.getI18nMap());
        return dto;
    }

    @Override
    public void populate(FormBuilderDTO dto) throws FormBuilderException {
        String i18nAltText;
        if (!dto.getClassName().endsWith("ImageRepresentation")) {
            throw new FormBuilderException(this.i18n.RepNotOfType(dto.getClassName(), "ImageRepresentation"));
        }
        super.populate(dto);
        this.altText = dto.getString("altText");
        this.url = dto.getString("url");
        this.id = dto.getString("id");
        this.saveI18nMap(dto.getMapOfStrings("i18n"));
        if ((this.altText == null || "".equals(this.altText)) && (i18nAltText = this.getI18n("default")) != null) {
            this.altText = i18nAltText;
        }
        this.populate(this.image);
    }

    @Override
    public FBFormItem cloneItem() {
        ImageFormItem clone = super.cloneItem(new ImageFormItem());
        clone.altText = this.altText;
        clone.setHeight(this.getHeight());
        clone.setWidth(this.getWidth());
        clone.id = this.id;
        clone.url = this.url;
        clone.saveI18nMap(this.getI18nMap());
        clone.populate(clone.image);
        return clone;
    }

    @Override
    public Widget cloneDisplay(Map<String, Object> data) {
        String i18nText;
        Image im = new Image();
        this.populate(im);
        String locale = (String)data.get("org.jbpm.formbuilder.server.render.Renderer.BASE_LOCALE");
        if (locale != null && (i18nText = this.getI18n(locale)) != null && !"".equals(i18nText)) {
            im.setAltText(i18nText);
            im.setTitle(i18nText);
        }
        super.populateActions(im.getElement());
        return im;
    }

    @Override
    public boolean containsLocale(String localeName) {
        return this.utils.containsLocale(localeName);
    }

    @Override
    public String getI18n(String key) {
        return this.utils.getI18n(key);
    }

    @Override
    public Map<String, String> getI18nMap() {
        return this.utils.getI18nMap();
    }

    @Override
    public void saveI18nMap(Map<String, String> i18nMap) {
        if (i18nMap != null) {
            String defaultI18n = i18nMap.get("default");
            if (defaultI18n != null && !"".equals(defaultI18n)) {
                this.altText = defaultI18n;
            }
            this.utils.saveI18nMap(i18nMap);
        }
    }

    @Override
    public void setFormat(I18NFormItem.Format format) {
    }

    @Override
    public I18NFormItem.Format getFormat() {
        return null;
    }

    @Override
    public void setSourceReference(String sourceReference) {
        this.url = sourceReference;
        this.image.setUrl(this.url);
    }

    @Override
    public String getSourceReference() {
        return this.url;
    }

    @Override
    public List<String> getAllowedTypes() {
        ArrayList<String> retval = new ArrayList<String>();
        retval.add("jpeg");
        retval.add("jpg");
        retval.add("png");
        retval.add("gif");
        retval.add("svg");
        return retval;
    }
}

