/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.form.items;

import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.FormBuilderException;
import org.jbpm.form.builder.ng.model.client.effect.FBFormEffect;
import org.jbpm.form.builder.ng.model.client.form.FBFormItem;
import org.jbpm.form.builder.ng.model.client.form.FBInplaceEditor;
import org.jbpm.form.builder.ng.model.client.form.I18NFormItem;
import org.jbpm.form.builder.ng.model.client.form.I18NUtils;
import org.jbpm.form.builder.ng.model.client.form.editors.LabelInplaceEditor;
import org.jbpm.form.builder.ng.model.client.messages.I18NConstants;
import org.jbpm.form.builder.ng.model.shared.api.FormBuilderDTO;

@Reflectable
public class LabelFormItem
extends FBFormItem
implements I18NFormItem {
    private final Label label = new Label("Label");
    private final I18NConstants i18n = CommonGlobals.getInstance().getI18n();
    private final I18NUtils utils = new I18NUtils();
    private String id;
    private String cssClassName;

    public LabelFormItem() {
        this(new ArrayList<FBFormEffect>());
    }

    public LabelFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.setWidth("200px");
        this.add((Widget)this.getLabel());
    }

    @Override
    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> formItemPropertiesMap = new HashMap<String, Object>();
        formItemPropertiesMap.put("id", this.id);
        formItemPropertiesMap.put("width", this.getWidth());
        formItemPropertiesMap.put("height", this.getHeight());
        formItemPropertiesMap.put("cssClassName", this.cssClassName);
        return formItemPropertiesMap;
    }

    @Override
    public FBInplaceEditor createInplaceEditor() {
        return new LabelInplaceEditor(this);
    }

    @Override
    public void saveValues(Map<String, Object> propertiesMap) {
        this.id = this.extractString(propertiesMap.get("id"));
        this.setWidth(this.extractString(propertiesMap.get("width")));
        this.setHeight(this.extractString(propertiesMap.get("height")));
        this.cssClassName = this.extractString(propertiesMap.get("cssClassName"));
        this.populate(this.getLabel());
    }

    private void populate(Label label) {
        if (this.getWidth() != null) {
            label.setWidth(this.getWidth());
        }
        if (this.getHeight() != null) {
            label.setHeight(this.getHeight());
        }
        if (this.cssClassName != null) {
            label.setStyleName(this.cssClassName);
        }
    }

    public Label getLabel() {
        return this.label;
    }

    @Override
    public void addEffect(FBFormEffect effect) {
        super.addEffect(effect);
        effect.setWidget((Widget)this.label);
    }

    @Override
    public FormBuilderDTO getRepresentation() {
        FormBuilderDTO dto = super.getRepresentation();
        dto.setString("value", this.label.getText());
        dto.setString("cssName", this.cssClassName);
        dto.setString("id", this.id);
        dto.setMapOfStrings("i18n", this.getI18nMap());
        dto.setString("format", this.getFormat() == null ? null : this.getFormat().toString());
        return dto;
    }

    @Override
    public void populate(FormBuilderDTO dto) throws FormBuilderException {
        if (!dto.getClassName().endsWith("LabelRepresentation")) {
            throw new FormBuilderException(this.i18n.RepNotOfType(dto.getClassName(), "LabelRepresentation"));
        }
        super.populate(dto);
        this.label.setText(dto.getString("value"));
        this.cssClassName = dto.getString("cssName");
        this.id = dto.getString("id");
        this.saveI18nMap(dto.getMapOfStrings("i18n"));
        if (dto.getString("format") != null && !"".equals(dto.getString("format"))) {
            this.setFormat(I18NFormItem.Format.valueOf(dto.getString("format")));
        }
        this.populate(this.label);
    }

    @Override
    public FBFormItem cloneItem() {
        LabelFormItem clone = new LabelFormItem(this.getFormEffects());
        clone.cssClassName = this.cssClassName;
        clone.setHeight(this.getHeight());
        clone.id = this.id;
        clone.setWidth(this.getWidth());
        clone.getLabel().setText(this.label.getText());
        clone.populate(clone.label);
        clone.saveI18nMap(this.getI18nMap());
        clone.setFormat(this.getFormat());
        return clone;
    }

    @Override
    public Widget cloneDisplay(Map<String, Object> data) {
        Label lb = new Label();
        this.populate(lb);
        String value = (String)this.getInputValue(data);
        if (value != null) {
            lb.setText(value);
        } else {
            String i18nText;
            String locale = (String)data.get("org.jbpm.formbuilder.server.render.Renderer.BASE_LOCALE");
            lb.setText(this.label.getText());
            if (locale != null && (i18nText = this.getI18n(locale)) != null && !"".equals(i18nText)) {
                lb.setText(i18nText);
            }
        }
        super.populateActions(lb.getElement());
        return lb;
    }

    @Override
    public boolean containsLocale(String localeName) {
        return this.utils.containsLocale(localeName);
    }

    @Override
    public String getI18n(String key) {
        return this.utils.getI18n(key);
    }

    @Override
    public Map<String, String> getI18nMap() {
        return this.utils.getI18nMap();
    }

    @Override
    public void saveI18nMap(Map<String, String> i18nMap) {
        if (i18nMap != null) {
            String defaultI18n = i18nMap.get("default");
            if (defaultI18n != null && !"".equals(defaultI18n)) {
                this.label.setText(defaultI18n);
            }
            this.utils.saveI18nMap(i18nMap);
        }
    }

    @Override
    public I18NFormItem.Format getFormat() {
        return this.utils.getFormat();
    }

    @Override
    public void setFormat(I18NFormItem.Format format) {
        this.utils.setFormat(format);
    }
}

