/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.form.items;

import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.visualization.client.AbstractDataTable;
import com.google.gwt.visualization.client.AbstractDrawOptions;
import com.google.gwt.visualization.client.DataTable;
import com.google.gwt.visualization.client.visualizations.LineChart;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.FormBuilderException;
import org.jbpm.form.builder.ng.model.client.effect.FBFormEffect;
import org.jbpm.form.builder.ng.model.client.form.FBFormItem;
import org.jbpm.form.builder.ng.model.client.messages.I18NConstants;
import org.jbpm.form.builder.ng.model.shared.api.FormBuilderDTO;

@Reflectable
public class LineGraphFormItem
extends FBFormItem {
    private final I18NConstants i18n = CommonGlobals.getInstance().getI18n();
    private LineChart chart = new LineChart((AbstractDataTable)DataTable.create(), LineChart.Options.create());
    private List<List<String>> dataTableRep = new ArrayList<List<String>>();
    private List<Map.Entry<String, String>> dataStructRep = new ArrayList<Map.Entry<String, String>>();
    private String graphTitle;
    private String graphXTitle;
    private String graphYTitle;

    public LineGraphFormItem() {
        this(new ArrayList<FBFormEffect>());
    }

    public LineGraphFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.setSize("200px", "150px");
        this.chart.setSize("200px", "150px");
        this.add((Widget)this.chart);
    }

    @Override
    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("width", this.getWidth());
        map.put("height", this.getHeight());
        map.put("graphTitle", this.graphTitle);
        map.put("graphXTitle", this.graphXTitle);
        map.put("graphYTitle", this.graphYTitle);
        return map;
    }

    @Override
    public void saveValues(Map<String, Object> asPropertiesMap) {
        HashMap map = new HashMap();
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.graphTitle = this.extractString(map.get("graphTitle"));
        this.graphXTitle = this.extractString(map.get("graphXTitle"));
        this.graphYTitle = this.extractString(map.get("graphYTitle"));
        this.populate(this.chart);
    }

    private int getIntValue(Object obj) {
        return Integer.valueOf(obj.toString());
    }

    private void populate(LineChart chart) {
        LineChart.Options options = LineChart.Options.create();
        options.setWidth(this.getOffsetWidth());
        options.setHeight(this.getOffsetHeight());
        options.setTitle(this.graphTitle);
        options.setTitleX(this.graphXTitle);
        options.setTitleY(this.graphYTitle);
        DataTable dataTable = DataTable.create();
        if (this.dataStructRep != null) {
            for (Map.Entry entry : this.dataStructRep) {
                dataTable.addColumn(AbstractDataTable.ColumnType.valueOf((String)((String)entry.getValue())), (String)entry.getKey());
            }
        }
        if (this.dataTableRep != null) {
            for (List list : this.dataTableRep) {
                dataTable.setValue(this.getIntValue(list.get(0)), this.getIntValue(list.get(1)), (String)list.get(2));
            }
        }
        chart.draw((AbstractDataTable)dataTable, (AbstractDrawOptions)options);
    }

    @Override
    public FormBuilderDTO getRepresentation() {
        FormBuilderDTO dto = super.getRepresentation();
        dto.setString("graphTitle", this.graphTitle);
        dto.setString("graphXTitle", this.graphXTitle);
        dto.setString("graphYTitle", this.graphYTitle);
        ArrayList<Object> structMap = new ArrayList<Object>();
        for (Map.Entry<String, String> entry : this.dataStructRep) {
            HashMap<String, String> itemMap = new HashMap<String, String>();
            itemMap.put("key", entry.getKey());
            itemMap.put("value", entry.getValue());
            structMap.add(itemMap);
        }
        dto.setList("dataStructure", structMap);
        ArrayList<Object> tableMap = new ArrayList<Object>();
        for (List<String> yPoint : this.dataTableRep) {
            HashMap<String, String> itemMap = new HashMap<String, String>();
            if (yPoint != null) {
                int index = 0;
                for (String point : yPoint) {
                    itemMap.put(String.valueOf(index), point);
                    ++index;
                }
            }
            tableMap.add(itemMap);
        }
        dto.setList("dataTable", tableMap);
        return dto;
    }

    @Override
    public void populate(FormBuilderDTO dto) throws FormBuilderException {
        if (!dto.getClassName().endsWith("LineGraphRepresentation")) {
            throw new FormBuilderException(this.i18n.RepNotOfType(dto.getClassName(), "LineGraphRepresentation"));
        }
        super.populate(dto);
        List<FormBuilderDTO> dataStructList = dto.getListOfDtos("dataStructure");
        this.dataStructRep.clear();
        for (FormBuilderDTO structDto : dataStructList) {
            LineGraphEntry entry = new LineGraphEntry();
            entry.setKey(structDto.getString("key"));
            entry.setValue(structDto.getString("value"));
            this.dataStructRep.add(entry);
        }
        this.dataTableRep.clear();
        List<FormBuilderDTO> dataTableList = dto.getListOfDtos("dataTable");
        for (FormBuilderDTO pointDto : dataTableList) {
            ArrayList<String> keys = new ArrayList<String>(pointDto.getParameters().keySet());
            Collections.sort(keys);
            ArrayList<String> item = new ArrayList<String>();
            for (String key : keys) {
                item.add(pointDto.getString(key));
            }
            this.dataTableRep.add(item);
        }
        this.graphTitle = dto.getString("graphTitle");
        this.graphXTitle = dto.getString("graphXTitle");
        this.graphYTitle = dto.getString("graphYTitle");
        this.populate(this.chart);
    }

    @Override
    public FBFormItem cloneItem() {
        LineGraphFormItem item = super.cloneItem(new LineGraphFormItem(this.getFormEffects()));
        item.chart = (LineChart)this.cloneDisplay(null);
        item.dataStructRep = new ArrayList<Map.Entry<String, String>>(this.dataStructRep);
        item.dataTableRep = new ArrayList<List<String>>(this.dataTableRep);
        item.graphTitle = this.graphTitle;
        item.graphXTitle = this.graphXTitle;
        item.graphYTitle = this.graphYTitle;
        return item;
    }

    @Override
    public Widget cloneDisplay(Map<String, Object> data) {
        LineChart chart = new LineChart();
        this.populate(chart);
        if (this.getInput() != null && this.getInput().get("name") != null) {
            DataTable dataTable = DataTable.create();
            Object myData = data.get(this.getInput().get("name"));
            this.populateInput(dataTable, myData);
            chart.draw((AbstractDataTable)dataTable);
        }
        super.populateActions(chart.getElement());
        return chart;
    }

    private void populateInput(DataTable dataTable, Object myData) {
        block4: {
            block5: {
                block3: {
                    if (!myData.getClass().isArray()) break block3;
                    Object[] myDataArray = (Object[])myData;
                    int index = 0;
                    for (Object item : myDataArray) {
                        this.setRowDataFromInput(dataTable, index, item);
                        ++index;
                    }
                    break block4;
                }
                if (!(myData instanceof Collection)) break block5;
                Collection myDataCol = (Collection)myData;
                int index = 0;
                for (Object item : myDataCol) {
                    this.setRowDataFromInput(dataTable, index, item);
                    ++index;
                }
                break block4;
            }
            if (!(myData instanceof Map)) break block4;
            Map myDataMap = (Map)myData;
            int index = 0;
            for (Object item : myDataMap.values()) {
                this.setRowDataFromInput(dataTable, index, item);
                ++index;
            }
        }
    }

    private void setRowDataFromInput(DataTable dataTable, int index, Object item) {
        if (item.getClass().isArray()) {
            Object[] subObjArray = (Object[])item;
            int columnIndex = 0;
            for (Object subObj : subObjArray) {
                String value = subObj.toString();
                dataTable.setCell(index, columnIndex, value, value, null);
                ++columnIndex;
            }
        } else if (item instanceof Collection) {
            Collection subObjCol = (Collection)item;
            int columnIndex = 0;
            for (Object subObj : subObjCol) {
                String value = subObj.toString();
                dataTable.setCell(index, columnIndex, value, value, null);
                ++columnIndex;
            }
        } else if (item instanceof Map) {
            Map subObjMap = (Map)item;
            int columnIndex = 0;
            for (Object subObj : subObjMap.values()) {
                String value = subObj.toString();
                dataTable.setCell(index, columnIndex, value, value, null);
                ++columnIndex;
            }
        } else {
            String value = item.toString();
            dataTable.setCell(index, 0, value, value, null);
        }
    }

    private class LineGraphEntry
    implements Map.Entry<String, String> {
        private String key;
        private String value;

        private LineGraphEntry() {
        }

        @Override
        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String setValue(String value) {
            String aux = this.value;
            this.value = value;
            return aux;
        }
    }
}

