/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.form.items;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.FormBuilderException;
import org.jbpm.form.builder.ng.model.client.bus.ui.NotificationEvent;
import org.jbpm.form.builder.ng.model.client.effect.FBFormEffect;
import org.jbpm.form.builder.ng.model.client.form.FBFormItem;
import org.jbpm.form.builder.ng.model.client.form.LayoutFormItem;
import org.jbpm.form.builder.ng.model.client.form.PhantomPanel;
import org.jbpm.form.builder.ng.model.client.messages.I18NConstants;
import org.jbpm.form.builder.ng.model.shared.api.FormBuilderDTO;

@Reflectable
public class LoopBlockFormItem
extends LayoutFormItem {
    private String variableName;
    private SimplePanel loopBlock = new SimplePanel();
    private final EventBus bus = CommonGlobals.getInstance().getEventBus();
    private final I18NConstants i18n = CommonGlobals.getInstance().getI18n();

    public LoopBlockFormItem() {
        this(new ArrayList<FBFormEffect>());
    }

    public LoopBlockFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.loopBlock.setStyleName("loopBlockBorder");
        this.loopBlock.setSize("100%", "50px");
        this.add((Widget)this.loopBlock);
        this.setSize("100%", "50px");
    }

    @Override
    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("variableName", this.variableName);
        return map;
    }

    @Override
    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.variableName = this.extractString(asPropertiesMap.get("variableName"));
    }

    @Override
    public FormBuilderDTO getRepresentation() {
        FormBuilderDTO dto = super.getRepresentation();
        dto.setString("inputName", this.getInput() == null ? null : String.valueOf(this.getInput().get("name")));
        FBFormItem loopItem = (FBFormItem)this.loopBlock.getWidget();
        if (loopItem != null) {
            dto.setMap("loopBlock", loopItem.getRepresentation().getParameters());
        }
        dto.setString("variableName", this.variableName);
        return dto;
    }

    @Override
    public void populate(FormBuilderDTO dto) throws FormBuilderException {
        if (!dto.getClassName().endsWith("LoopBlockRepresentation")) {
            throw new FormBuilderException(this.i18n.RepNotOfType(dto.getClassName(), "LoopBlockRepresentation"));
        }
        super.populate(dto);
        this.variableName = dto.getString("variableName");
        this.loopBlock.clear();
        if (dto.getString("inputName") != null && !"".equals(dto.getString("inputName"))) {
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("name", dto.getString("inputName"));
            this.setInput(input);
        }
        if (dto.getMap("loopBlock") != null) {
            FormBuilderDTO loopDto = new FormBuilderDTO(dto.getMap("loopBlock"));
            FBFormItem child = LayoutFormItem.createItem(loopDto);
            this.loopBlock.add((Widget)child);
        }
    }

    @Override
    public FBFormItem cloneItem() {
        LoopBlockFormItem clone = super.cloneItem(new LoopBlockFormItem(this.getFormEffects()));
        FBFormItem loopItem = (FBFormItem)this.loopBlock.getWidget();
        clone.add(loopItem);
        clone.variableName = this.variableName;
        return clone;
    }

    @Override
    public Widget cloneDisplay(Map<String, Object> data) {
        String inputName;
        FlowPanel display = new FlowPanel();
        FBFormItem subItem = (FBFormItem)this.loopBlock.getWidget();
        Object input = this.getInputValue(data);
        String string = inputName = this.getInput() == null ? null : String.valueOf(this.getInput().get("name"));
        if (subItem != null && input != null && inputName != null) {
            HashMap<String, Object> subData = new HashMap<String, Object>();
            if (input.getClass().isArray()) {
                Object[] arr;
                for (Object obj : arr = (Object[])input) {
                    subData.put(inputName, obj);
                    display.add(subItem.cloneDisplay(subData));
                }
            } else if (input instanceof Collection) {
                Collection col = (Collection)input;
                for (Object obj : col) {
                    subData.put(inputName, obj);
                    display.add(subItem.cloneDisplay(subData));
                }
            } else if (input instanceof Map) {
                Map map = (Map)input;
                for (Map.Entry obj : map.entrySet()) {
                    subData.put(inputName, obj);
                    display.add(subItem.cloneDisplay(subData));
                }
            }
        }
        display.setSize(this.getWidth(), this.getHeight());
        super.populateActions(display.getElement());
        return display;
    }

    @Override
    public HasWidgets getPanel() {
        return this.loopBlock;
    }

    @Override
    public boolean add(FBFormItem item) {
        if (this.loopBlock.getWidget() == null) {
            this.loopBlock.setWidget((Widget)item);
            return super.add(item);
        }
        this.bus.fireEvent((GwtEvent)new NotificationEvent(NotificationEvent.Level.WARN, this.i18n.LoopBlockFull()));
        return false;
    }

    @Override
    public void add(PhantomPanel phantom, int x, int y) {
        if (this.loopBlock.getWidget() == null) {
            this.loopBlock.setWidget((Widget)phantom);
        }
    }

    @Override
    public void replacePhantom(FBFormItem item) {
        if (this.loopBlock.getWidget() == null || this.loopBlock.getWidget() instanceof PhantomPanel) {
            this.loopBlock.remove(this.loopBlock.getWidget());
            this.loopBlock.setWidget((Widget)item);
        }
    }
}

