/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.form.items;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.FormBuilderException;
import org.jbpm.form.builder.ng.model.client.bus.ui.NotificationEvent;
import org.jbpm.form.builder.ng.model.client.effect.ChangeColspanFormEffect;
import org.jbpm.form.builder.ng.model.client.effect.FBFormEffect;
import org.jbpm.form.builder.ng.model.client.form.FBFormItem;
import org.jbpm.form.builder.ng.model.client.form.LayoutFormItem;
import org.jbpm.form.builder.ng.model.client.form.PhantomPanel;
import org.jbpm.form.builder.ng.model.client.messages.I18NConstants;
import org.jbpm.form.builder.ng.model.shared.api.FormBuilderDTO;

@Reflectable
public class MIGLayoutFormItem
extends LayoutFormItem {
    private final I18NConstants i18n = CommonGlobals.getInstance().getI18n();
    private final EventBus bus = CommonGlobals.getInstance().getEventBus();
    private FlexTable table = new FlexTable(){

        public boolean remove(Widget widget) {
            if (widget instanceof FBFormItem) {
                MIGLayoutFormItem.super.remove((Widget)((FBFormItem)widget));
            }
            return super.remove(widget);
        }
    };
    private Integer borderWidth = 1;
    private Integer cellpadding = null;
    private Integer cellspacing = null;
    private Integer rows = 1;
    private Integer columns = 1;
    private String title = null;

    public MIGLayoutFormItem() {
        this(new ArrayList<FBFormEffect>());
    }

    public MIGLayoutFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.table.setBorderWidth(this.borderWidth.intValue());
        this.table.insertRow(this.table.getRowCount());
        this.table.addCell(0);
        this.add((Widget)this.table);
        this.setSize("90px", "90px");
        this.table.setSize(this.getWidth(), this.getHeight());
    }

    @Override
    public void replacePhantom(FBFormItem item) {
        int row;
        if (!item.hasEffectOfType(ChangeColspanFormEffect.class)) {
            item.addEffect(new ChangeColspanFormEffect());
        }
        boolean found = false;
        int column = 0;
        for (row = 0; row < this.table.getRowCount(); ++row) {
            for (column = 0; column < this.table.getCellCount(row) && !found; ++column) {
                if (!this.isPhantom(this.table.getWidget(row, column))) continue;
                found = true;
                break;
            }
            if (found) break;
        }
        if (found) {
            int index = row * this.table.getCellCount(row) + column;
            if (super.size() > index) {
                super.insert(index, item);
            } else {
                super.add(item);
            }
            this.table.setWidget(row, column, null);
            this.table.setWidget(row, column, (Widget)item);
        } else {
            this.add(item);
        }
    }

    @Override
    public boolean add(FBFormItem child) {
        if (!child.hasEffectOfType(ChangeColspanFormEffect.class)) {
            child.addEffect(new ChangeColspanFormEffect());
        }
        boolean added = false;
        block0: for (int i = 0; i < this.table.getRowCount() && !added; ++i) {
            for (int j = 0; j < this.table.getCellCount(i) && !added; ++j) {
                if (this.table.getWidget(i, j) != null && !this.isWhiteSpace(this.table.getWidget(i, j))) continue;
                added = true;
                int index = i * this.table.getCellCount(i) + j;
                if (super.size() > index) {
                    super.insert(index - 1, child);
                } else {
                    super.add(child);
                }
                this.table.addCell(i);
                this.table.setWidget(i, j, (Widget)child);
                continue block0;
            }
        }
        if (!added) {
            this.bus.fireEvent((GwtEvent)new NotificationEvent(NotificationEvent.Level.WARN, this.i18n.TableFull()));
            return false;
        }
        return true;
    }

    @Override
    public void add(PhantomPanel phantom, int x, int y) {
        int row = 0;
        int column = 0;
        boolean found = false;
        while (row < this.table.getRowCount() && !found) {
            for (column = 0; column < this.table.getCellCount(row) && !found; ++column) {
                Element cellElement = this.table.getCellFormatter().getElement(row, column);
                if (x <= cellElement.getAbsoluteLeft() || x >= cellElement.getAbsoluteRight() || y <= cellElement.getAbsoluteTop() || y >= cellElement.getAbsoluteBottom() || this.table.getWidget(row, column) != null && !this.isWhiteSpace(this.table.getWidget(row, column)) && !this.isPhantom(this.table.getWidget(row, column))) continue;
                found = true;
                break;
            }
            if (found) continue;
            ++row;
        }
        if (found && !this.isPhantom(this.table.getWidget(row, column))) {
            this.table.setWidget(row, column, (Widget)phantom);
        }
    }

    @Override
    public HasWidgets getPanel() {
        return this.table;
    }

    @Override
    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("borderWidth", this.borderWidth);
        map.put("cellpadding", this.cellpadding);
        map.put("cellspacing", this.cellspacing);
        map.put("height", this.getHeight());
        map.put("width", this.getWidth());
        map.put("title", this.title);
        map.put("rows", this.rows);
        map.put("columns", this.columns);
        return map;
    }

    @Override
    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.borderWidth = this.extractInt(asPropertiesMap.get("borderWidth"));
        this.cellpadding = this.extractInt(asPropertiesMap.get("cellpadding"));
        this.cellspacing = this.extractInt(asPropertiesMap.get("cellspacing"));
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.title = this.extractString(asPropertiesMap.get("title"));
        this.rows = this.extractInt(asPropertiesMap.get("rows"));
        this.columns = this.extractInt(asPropertiesMap.get("columns"));
        this.populate(this.table);
    }

    @Override
    public FormBuilderDTO getRepresentation() {
        FormBuilderDTO dto = super.getRepresentation();
        dto.setInteger("rows", this.rows);
        dto.setInteger("borderWidth", this.borderWidth);
        dto.setInteger("cellPadding", this.cellpadding);
        dto.setInteger("cellSpacing", this.cellspacing);
        dto.setString("title", this.title);
        ArrayList<Object> elements = new ArrayList<Object>();
        for (int r = 0; r < this.table.getRowCount(); ++r) {
            for (int c = 0; c < this.table.getCellCount(r); ++c) {
                Widget widget = this.table.getWidget(r, c);
                int colspan = this.table.getFlexCellFormatter().getColSpan(r, c);
                int rowspan = this.table.getFlexCellFormatter().getRowSpan(r, c);
                if (widget == null || !(widget instanceof FBFormItem)) continue;
                FBFormItem item = (FBFormItem)widget;
                FormBuilderDTO subDto = item.getRepresentation();
                subDto.setInteger("migLayoutColspan", colspan);
                subDto.setInteger("migLayoutRowspan", rowspan);
                subDto.setInteger("migLayoutRow", r);
                subDto.setInteger("migLayoutColumn", c);
                elements.add(subDto.getParameters());
            }
        }
        dto.setList("elements", elements);
        return dto;
    }

    @Override
    public void populate(FormBuilderDTO dto) throws FormBuilderException {
        if (!dto.getClassName().endsWith("MIGPanelRepresentation")) {
            throw new FormBuilderException(this.i18n.RepNotOfType(dto.getClassName(), "MIGPanelRepresentation"));
        }
        super.populate(dto);
        this.rows = dto.getInteger("rows");
        this.borderWidth = dto.getInteger("borderWidth");
        this.cellpadding = dto.getInteger("cellPadding");
        this.cellspacing = dto.getInteger("cellSpacing");
        this.populate(this.table);
        this.table.clear();
        super.getItems().clear();
        List<FormBuilderDTO> elements = dto.getListOfDtos("elements");
        if (elements != null) {
            for (FormBuilderDTO subDto : elements) {
                if (subDto == null) continue;
                FBFormItem subItem = LayoutFormItem.createItem(subDto);
                int row = subDto.getInteger("migLayoutRow");
                int column = subDto.getInteger("migLayoutColumn");
                this.table.setWidget(row, column, (Widget)subItem);
                int colspan = subDto.getInteger("migLayoutColspan");
                int rowspan = subDto.getInteger("migLayoutRowspan");
                if (colspan > 1) {
                    this.table.getFlexCellFormatter().setColSpan(row, column, colspan);
                }
                if (rowspan > 1) {
                    this.table.getFlexCellFormatter().setRowSpan(row, column, rowspan);
                }
                super.add(subItem);
            }
        }
    }

    private void populate(FlexTable grid) {
        if (this.borderWidth != null && this.borderWidth > 0) {
            grid.setBorderWidth(this.borderWidth.intValue());
        }
        if (this.cellpadding != null && this.cellpadding >= 0) {
            grid.setCellPadding(this.cellpadding.intValue());
        }
        if (this.cellspacing != null && this.cellspacing >= 0) {
            grid.setCellSpacing(this.cellspacing.intValue());
        }
        if (this.getHeight() != null) {
            grid.setHeight(this.getHeight());
        }
        if (this.getWidth() != null) {
            grid.setWidth(this.getWidth());
        }
        if (this.title != null) {
            grid.setTitle(this.title);
        }
        if (this.rows != null && this.rows > 0) {
            while (this.rows > grid.getRowCount()) {
                grid.insertRow(grid.getRowCount());
                int columnCount = 0;
                FlexTable.FlexCellFormatter formatter = grid.getFlexCellFormatter();
                for (int cell = 0; cell < grid.getCellCount(grid.getRowCount() - 1); ++cell) {
                    columnCount += formatter.getColSpan(grid.getRowCount() - 1, cell);
                }
                while (this.columns > columnCount) {
                    grid.addCell(grid.getRowCount() - 1);
                    ++columnCount;
                }
            }
            while (this.rows < grid.getRowCount()) {
                grid.removeRow(grid.getRowCount() - 1);
            }
        }
        if (this.columns != null && this.columns > 0) {
            for (int row = 0; row < grid.getRowCount(); ++row) {
                int columnCount = 0;
                FlexTable.FlexCellFormatter formatter = grid.getFlexCellFormatter();
                for (int cell = 0; cell < grid.getCellCount(row); ++cell) {
                    columnCount += formatter.getColSpan(row, cell);
                }
                while (this.columns > columnCount) {
                    grid.addCell(row);
                    ++columnCount;
                }
                while (this.columns < columnCount) {
                    int cellCount = grid.getCellCount(row);
                    if (cellCount > 0) {
                        int cellColumns = formatter.getColSpan(row, cellCount - 1);
                        if (cellColumns > 1 && columnCount - cellColumns >= this.columns) {
                            grid.removeCell(row, cellCount - 1);
                        } else {
                            grid.removeCell(row, cellCount - 1);
                        }
                    }
                    --columnCount;
                }
            }
        }
    }

    @Override
    public FBFormItem cloneItem() {
        MIGLayoutFormItem clone = super.cloneItem(new MIGLayoutFormItem());
        clone.borderWidth = this.borderWidth;
        clone.cellpadding = this.cellpadding;
        clone.cellspacing = this.cellspacing;
        clone.rows = this.rows;
        clone.title = this.title;
        clone.populate(clone.table);
        for (int row = 0; row < this.table.getRowCount(); ++row) {
            for (int column = 0; column < this.table.getCellCount(row); ++column) {
                FBFormItem item = (FBFormItem)this.table.getWidget(row, column);
                if (item == null) continue;
                clone.table.addCell(row);
                int colspan = this.table.getFlexCellFormatter().getColSpan(row, column);
                clone.table.getFlexCellFormatter().setColSpan(row, column, colspan);
                clone.table.setWidget(row, column, (Widget)item.cloneItem());
            }
        }
        return clone;
    }

    @Override
    public Widget cloneDisplay(Map<String, Object> data) {
        FlexTable ft = new FlexTable();
        this.populate(ft);
        for (int row = 0; row < this.table.getRowCount(); ++row) {
            for (int column = 0; column < this.table.getCellCount(row); ++column) {
                FBFormItem item = (FBFormItem)this.table.getWidget(row, column);
                if (item == null) continue;
                ft.addCell(row);
                int colspan = this.table.getFlexCellFormatter().getColSpan(row, column);
                ft.getFlexCellFormatter().setColSpan(row, column, colspan);
                ft.setWidget(row, column, item.cloneDisplay(data));
            }
        }
        super.populateActions(ft.getElement());
        return ft;
    }

    protected boolean isPhantom(Widget widget) {
        return widget != null && widget instanceof PhantomPanel;
    }

    public void setSpan(FBFormItem item, Integer colspan, Integer rowspan) {
        block0: for (int row = 0; row < this.table.getRowCount(); ++row) {
            for (int col = 0; col < this.table.getCellCount(row); ++col) {
                Widget widget = this.table.getWidget(row, col);
                if (widget == null || !widget.equals((Object)item)) continue;
                if (colspan != null && colspan > 0) {
                    this.table.getFlexCellFormatter().setColSpan(row, col, colspan.intValue());
                }
                if (rowspan == null || rowspan <= 0) continue block0;
                this.table.getFlexCellFormatter().setRowSpan(row, col, rowspan.intValue());
                continue block0;
            }
        }
    }

    public int getColSpan(FBFormItem item) {
        for (int row = 0; row < this.table.getRowCount(); ++row) {
            for (int col = 0; col < this.table.getCellCount(row); ++col) {
                Widget widget = this.table.getWidget(row, col);
                if (widget == null || !widget.equals((Object)item)) continue;
                int colSpan = this.table.getFlexCellFormatter().getColSpan(row, col);
                if (colSpan <= 0) {
                    colSpan = 1;
                }
                return colSpan;
            }
        }
        return 1;
    }

    public int getRowSpan(FBFormItem item) {
        for (int row = 0; row < this.table.getRowCount(); ++row) {
            for (int col = 0; col < this.table.getCellCount(row); ++col) {
                Widget widget = this.table.getWidget(row, col);
                if (widget == null || !widget.equals((Object)item)) continue;
                int rowSpan = this.table.getFlexCellFormatter().getRowSpan(row, col);
                if (rowSpan <= 0) {
                    rowSpan = 1;
                }
                return rowSpan;
            }
        }
        return 1;
    }
}

