/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.form.items;

import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.FormBuilderException;
import org.jbpm.form.builder.ng.model.client.effect.FBFormEffect;
import org.jbpm.form.builder.ng.model.client.form.FBFormItem;
import org.jbpm.form.builder.ng.model.client.form.LayoutFormItem;
import org.jbpm.form.builder.ng.model.client.form.PhantomPanel;
import org.jbpm.form.builder.ng.model.client.messages.I18NConstants;
import org.jbpm.form.builder.ng.model.shared.api.FormBuilderDTO;

@Reflectable
public class MenuLayoutFormItem
extends LayoutFormItem {
    private final I18NConstants i18n = CommonGlobals.getInstance().getI18n();
    private final HorizontalPanel panel = new HorizontalPanel();
    private String type;
    private String cssClassName;
    private String id;
    private String dir;

    public MenuLayoutFormItem() {
        this(new ArrayList<FBFormEffect>());
    }

    public MenuLayoutFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.panel.setBorderWidth(0);
        this.setSize("200px", "90px");
        this.panel.setSize(this.getWidth(), this.getHeight());
        this.add((Widget)this.panel);
    }

    @Override
    public void replacePhantom(FBFormItem item) {
        PhantomPanel phantom = null;
        for (Widget widget : this.panel) {
            if (!(widget instanceof PhantomPanel)) continue;
            phantom = (PhantomPanel)widget;
            break;
        }
        if (phantom != null) {
            int index = this.panel.getWidgetIndex(phantom);
            super.insert(index, item);
            this.remove((Widget)phantom);
        } else {
            this.add(item);
        }
    }

    @Override
    public boolean add(FBFormItem item) {
        this.panel.add((Widget)item);
        return super.add(item);
    }

    @Override
    public void add(PhantomPanel phantom, int x, int y) {
        for (int index = 0; index < this.panel.getWidgetCount(); ++index) {
            Widget item = this.panel.getWidget(index);
            int left = item.getAbsoluteLeft();
            int right = left + item.getOffsetWidth();
            int top = item.getAbsoluteTop();
            int bottom = top + item.getOffsetHeight();
            if (x <= left || x >= right || y <= top || y >= bottom) continue;
            this.panel.insert((Widget)phantom, index);
            break;
        }
    }

    @Override
    public HasWidgets getPanel() {
        return this.panel;
    }

    @Override
    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> formItemPropertiesMap = new HashMap<String, Object>();
        formItemPropertiesMap.put("height", this.getHeight());
        formItemPropertiesMap.put("width", this.getWidth());
        formItemPropertiesMap.put("cssClassName", this.cssClassName);
        formItemPropertiesMap.put("dir", this.dir);
        formItemPropertiesMap.put("id", this.id);
        formItemPropertiesMap.put("type", this.type);
        return formItemPropertiesMap;
    }

    @Override
    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.cssClassName = this.extractString(asPropertiesMap.get("cssClassName"));
        this.dir = this.extractString(asPropertiesMap.get("dir"));
        this.id = this.extractString(asPropertiesMap.get("id"));
        this.type = this.extractString(asPropertiesMap.get("type"));
        this.populate(this.panel);
    }

    private void populate(HorizontalPanel panel) {
        if (this.getHeight() != null) {
            panel.setHeight(this.getHeight());
        }
        if (this.cssClassName != null) {
            panel.setStyleName(this.cssClassName);
        }
        if (this.dir != null) {
            panel.getElement().setDir(this.dir);
        }
        if (this.id != null) {
            panel.getElement().setId(this.id);
        }
        if (this.getWidth() != null) {
            panel.setWidth(this.getWidth());
        }
        if (this.type != null) {
            panel.setStyleName(this.type + " " + panel.getStyleName());
        }
    }

    @Override
    public void populate(FormBuilderDTO dto) throws FormBuilderException {
        if (!dto.getClassName().endsWith("MenuPanelRepresentation")) {
            throw new FormBuilderException(this.i18n.RepNotOfType(dto.getClassName(), "MenuPanelRepresentation"));
        }
        super.populate(dto);
        this.cssClassName = dto.getString("cssClassName");
        this.id = dto.getString("id");
        this.dir = dto.getString("dir");
        this.type = dto.getString("type");
        this.populate(this.panel);
        List<FormBuilderDTO> itemDtos = dto.getListOfDtos("items");
        if (itemDtos != null) {
            for (FormBuilderDTO itemDto : itemDtos) {
                this.add(LayoutFormItem.createItem(itemDto));
            }
        }
    }

    @Override
    public FormBuilderDTO getRepresentation() {
        FormBuilderDTO dto = super.getRepresentation();
        dto.setString("cssClassName", this.cssClassName);
        dto.setString("id", this.id);
        dto.setString("dir", this.dir);
        dto.setString("type", this.type);
        ArrayList<Object> itemDtos = new ArrayList<Object>();
        for (FBFormItem item : this.getItems()) {
            itemDtos.add(item.getRepresentation().getParameters());
        }
        dto.setList("items", itemDtos);
        return dto;
    }

    @Override
    public FBFormItem cloneItem() {
        MenuLayoutFormItem clone = super.cloneItem(new MenuLayoutFormItem(this.getFormEffects()));
        clone.cssClassName = this.cssClassName;
        clone.id = this.id;
        clone.dir = this.dir;
        clone.type = this.type;
        clone.populate(clone.panel);
        for (FBFormItem item : this.getItems()) {
            clone.add(item.cloneItem());
        }
        return clone;
    }

    @Override
    public Widget cloneDisplay(Map<String, Object> formData) {
        HorizontalPanel hp = new HorizontalPanel();
        hp.setBorderWidth(0);
        this.populate(hp);
        super.populateActions(hp.getElement());
        for (FBFormItem item : this.getItems()) {
            hp.add(item.cloneDisplay(formData));
        }
        return hp;
    }
}

