/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.form.items;

import com.google.gwt.user.client.ui.DoubleBox;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.FormBuilderException;
import org.jbpm.form.builder.ng.model.client.effect.FBFormEffect;
import org.jbpm.form.builder.ng.model.client.form.FBFormItem;
import org.jbpm.form.builder.ng.model.client.messages.I18NConstants;
import org.jbpm.form.builder.ng.model.shared.api.FormBuilderDTO;

@Reflectable
public class NumberFieldFormItem
extends FBFormItem {
    private final I18NConstants i18n = CommonGlobals.getInstance().getI18n();
    private final DoubleBox doubleBox = new DoubleBox();
    private Double defaultContent = null;
    private String name = null;
    private String id = null;
    private String title = null;
    private Integer maxlength = null;

    public NumberFieldFormItem() {
        this(new ArrayList<FBFormEffect>());
    }

    public NumberFieldFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.add((Widget)this.doubleBox);
        this.setWidth("150px");
        this.setHeight("25px");
        this.doubleBox.setWidth(this.getWidth());
        this.doubleBox.setHeight(this.getHeight());
    }

    @Override
    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("inputDefaultContent", this.defaultContent);
        map.put("name", this.name);
        map.put("height", this.getHeight());
        map.put("width", this.getWidth());
        map.put("maxlength", this.maxlength);
        map.put("title", this.title);
        map.put("id", this.id);
        return map;
    }

    @Override
    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.defaultContent = this.extractDouble(asPropertiesMap.get("inputDefaultContent"));
        this.name = this.extractString(asPropertiesMap.get("name"));
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.title = this.extractString(asPropertiesMap.get("title"));
        this.maxlength = this.extractInt(asPropertiesMap.get("maxlength"));
        this.id = this.extractString(asPropertiesMap.get("id"));
        this.populate(this.doubleBox);
    }

    private void populate(DoubleBox doubleBox) {
        if (this.defaultContent != null) {
            doubleBox.setValue((Object)this.defaultContent);
        }
        if (this.name != null) {
            doubleBox.setName(this.name);
        }
        if (this.getHeight() != null) {
            doubleBox.setHeight(this.getHeight());
        }
        if (this.getWidth() != null) {
            doubleBox.setWidth(this.getWidth());
        }
        if (this.title != null) {
            doubleBox.setTitle(this.title);
        }
        if (this.maxlength != null) {
            doubleBox.setMaxLength(this.maxlength.intValue());
        }
    }

    @Override
    public FormBuilderDTO getRepresentation() {
        FormBuilderDTO dto = super.getRepresentation();
        dto.setDouble("defaultValue", this.defaultContent);
        dto.setString("name", this.name);
        dto.setString("id", this.id);
        dto.setInteger("maxLength", this.maxlength);
        return dto;
    }

    @Override
    public void populate(FormBuilderDTO dto) throws FormBuilderException {
        if (!dto.getClassName().endsWith("NumberFieldRepresentation")) {
            throw new FormBuilderException(this.i18n.RepNotOfType(dto.getClassName(), "TextFieldRepresentation"));
        }
        super.populate(dto);
        this.defaultContent = dto.getDouble("defaultValue");
        this.name = dto.getString("name");
        this.id = dto.getString("id");
        this.maxlength = dto.getInteger("maxLength");
        this.populate(this.doubleBox);
    }

    @Override
    public FBFormItem cloneItem() {
        NumberFieldFormItem clone = super.cloneItem(new NumberFieldFormItem());
        clone.defaultContent = this.defaultContent;
        clone.setHeight(this.getHeight());
        clone.id = this.id;
        clone.maxlength = this.maxlength;
        clone.name = this.name;
        clone.title = this.title;
        clone.setWidth(this.getWidth());
        clone.populate(clone.doubleBox);
        return clone;
    }

    @Override
    public Widget cloneDisplay(Map<String, Object> formData) {
        DoubleBox tb = new DoubleBox();
        this.populate(tb);
        Object input = this.getInputValue(formData);
        if (input != null) {
            String s = input.toString();
            tb.setValue((Object)(s.equals("") ? null : Double.valueOf(s)));
        }
        if (this.getOutput() != null && this.getOutput().get("name") != null) {
            tb.setName(String.valueOf(this.getOutput().get("name")));
        }
        super.populateActions(tb.getElement());
        return tb;
    }
}

