/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.form.items;

import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.FormBuilderException;
import org.jbpm.form.builder.ng.model.client.effect.FBFormEffect;
import org.jbpm.form.builder.ng.model.client.form.FBFormItem;
import org.jbpm.form.builder.ng.model.client.messages.I18NConstants;
import org.jbpm.form.builder.ng.model.shared.api.FormBuilderDTO;

@Reflectable
public class PasswordFieldFormItem
extends FBFormItem {
    private final I18NConstants i18n = CommonGlobals.getInstance().getI18n();
    private final PasswordTextBox textBox = new PasswordTextBox();
    private String defaultContent = null;
    private String name = null;
    private String id = null;
    private String title = null;
    private Integer maxlength = null;

    public PasswordFieldFormItem() {
        this(new ArrayList<FBFormEffect>());
    }

    public PasswordFieldFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.add((Widget)this.textBox);
        this.setWidth("100px");
        this.setHeight("21px");
        this.textBox.setSize(this.getWidth(), this.getHeight());
    }

    @Override
    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("inputDefaultContent", this.defaultContent);
        map.put("name", this.name);
        map.put("id", this.id);
        map.put("height", this.getHeight());
        map.put("width", this.getWidth());
        map.put("maxlength", this.maxlength);
        map.put("title", this.title);
        return map;
    }

    @Override
    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.defaultContent = this.extractString(asPropertiesMap.get("inputDefaultContent"));
        this.name = this.extractString(asPropertiesMap.get("name"));
        this.id = this.extractString(asPropertiesMap.get("id"));
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.title = this.extractString(asPropertiesMap.get("title"));
        this.maxlength = this.extractInt(asPropertiesMap.get("maxlength"));
        this.populate(this.textBox);
    }

    private void populate(PasswordTextBox textBox) {
        if (this.defaultContent != null) {
            textBox.setValue((Object)this.defaultContent);
        }
        if (this.name != null) {
            textBox.setName(this.name);
        }
        if (this.getHeight() != null) {
            textBox.setHeight(this.getHeight());
        }
        if (this.getWidth() != null) {
            textBox.setWidth(this.getWidth());
        }
        if (this.title != null) {
            textBox.setTitle(this.title);
        }
        if (this.maxlength != null) {
            textBox.setMaxLength(this.maxlength.intValue());
        }
    }

    @Override
    public FormBuilderDTO getRepresentation() {
        FormBuilderDTO dto = super.getRepresentation();
        dto.setString("defaultValue", this.defaultContent);
        dto.setString("name", this.name);
        dto.setString("id", this.id);
        dto.setInteger("maxLength", this.maxlength);
        return dto;
    }

    @Override
    public void populate(FormBuilderDTO dto) throws FormBuilderException {
        if (!dto.getClassName().endsWith("PasswordFieldRepresentation")) {
            throw new FormBuilderException(this.i18n.RepNotOfType(dto.getClassName(), "PasswordFieldRepresentation"));
        }
        super.populate(dto);
        this.defaultContent = dto.getString("defaultValue");
        this.name = dto.getString("name");
        this.id = dto.getString("id");
        this.maxlength = dto.getInteger("maxLength");
        this.populate(this.textBox);
    }

    @Override
    public FBFormItem cloneItem() {
        PasswordFieldFormItem clone = new PasswordFieldFormItem(this.getFormEffects());
        clone.defaultContent = this.defaultContent;
        clone.setHeight(this.getHeight());
        clone.id = this.id;
        clone.maxlength = this.maxlength;
        clone.name = this.name;
        clone.title = this.title;
        clone.setWidth(this.getWidth());
        clone.populate(clone.textBox);
        return clone;
    }

    @Override
    public Widget cloneDisplay(Map<String, Object> data) {
        PasswordTextBox pb = new PasswordTextBox();
        this.populate(pb);
        Object input = this.getInputValue(data);
        if (input != null) {
            pb.setValue((Object)input.toString());
        }
        if (this.getOutput() != null && this.getOutput().get("name") != null) {
            pb.setName(String.valueOf(this.getOutput().get("name")));
        }
        super.populateActions(pb.getElement());
        return pb;
    }
}

