/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.form.items;

import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.FormBuilderException;
import org.jbpm.form.builder.ng.model.client.effect.FBFormEffect;
import org.jbpm.form.builder.ng.model.client.form.FBFormItem;
import org.jbpm.form.builder.ng.model.client.messages.I18NConstants;
import org.jbpm.form.builder.ng.model.shared.api.FormBuilderDTO;

@Reflectable
public class RadioButtonFormItem
extends FBFormItem {
    private final I18NConstants i18n = CommonGlobals.getInstance().getI18n();
    private RadioButton button = new RadioButton("");
    private String name;
    private String id;
    private String value;
    private Boolean selected = Boolean.FALSE;

    public RadioButtonFormItem() {
        this(new ArrayList<FBFormEffect>());
    }

    public RadioButtonFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.add((Widget)this.button);
        this.setHeight("15px");
        this.setWidth("15px");
        this.button.setSize(this.getWidth(), this.getHeight());
    }

    @Override
    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", this.name);
        map.put("id", this.id);
        map.put("value", this.value);
        map.put("selected", this.selected);
        map.put("width", this.getWidth());
        map.put("height", this.getHeight());
        return map;
    }

    @Override
    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.name = this.extractString(asPropertiesMap.get("name"));
        this.id = this.extractString(asPropertiesMap.get("id"));
        this.value = this.extractString(asPropertiesMap.get("value"));
        this.selected = this.extractBoolean(asPropertiesMap.get("selected"));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.populate(this.button);
    }

    private void populate(RadioButton button) {
        if (this.name != null) {
            button.setName(this.name);
        }
        if (this.value != null) {
            button.setFormValue(this.value);
        }
        if (this.selected != null) {
            button.setValue(this.selected);
        }
        if (this.getWidth() != null) {
            button.setWidth(this.getWidth());
        }
        if (this.getHeight() != null) {
            button.setHeight(this.getHeight());
        }
    }

    @Override
    public FormBuilderDTO getRepresentation() {
        FormBuilderDTO dto = super.getRepresentation();
        dto.setString("id", this.id);
        dto.setString("name", this.name);
        dto.setBoolean("selected", this.selected);
        dto.setString("value", this.value);
        return dto;
    }

    @Override
    public void populate(FormBuilderDTO dto) throws FormBuilderException {
        if (!dto.getClassName().endsWith("RadioButtonRepresentation")) {
            throw new FormBuilderException(this.i18n.RepNotOfType(dto.getClassName(), "RadioButtonRepresentation"));
        }
        super.populate(dto);
        this.id = dto.getString("id");
        this.name = dto.getString("name");
        this.selected = dto.getBoolean("selected");
        this.value = dto.getString("value");
        this.populate(this.button);
    }

    @Override
    public FBFormItem cloneItem() {
        RadioButtonFormItem clone = new RadioButtonFormItem(this.getFormEffects());
        clone.id = this.id;
        clone.name = this.name;
        clone.selected = this.selected;
        clone.value = this.value;
        clone.setHeight(this.getHeight());
        clone.setWidth(this.getWidth());
        clone.populate(clone.button);
        return clone;
    }

    @Override
    public Widget cloneDisplay(Map<String, Object> data) {
        RadioButton rb = new RadioButton("");
        this.populate(rb);
        Object input = this.getInputValue(data);
        if (input != null) {
            rb.setValue(Boolean.valueOf(input.toString()));
        }
        if (this.getOutput() != null && this.getOutput().get("name") != null) {
            rb.setName(String.valueOf(this.getOutput().get("name")));
        }
        super.populateActions(rb.getElement());
        return rb;
    }
}

