/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.form.items;

import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.FormBuilderException;
import org.jbpm.form.builder.ng.model.client.effect.FBFormEffect;
import org.jbpm.form.builder.ng.model.client.form.FBFormItem;
import org.jbpm.form.builder.ng.model.client.messages.I18NConstants;
import org.jbpm.form.builder.ng.model.common.panels.RangeBox;
import org.jbpm.form.builder.ng.model.shared.api.FormBuilderDTO;

@Reflectable
public class RangeFieldFormItem
extends FBFormItem {
    private final I18NConstants i18n = CommonGlobals.getInstance().getI18n();
    private final RangeBox rangeBox = new RangeBox();
    private Double defaultValue = null;
    private String name = null;
    private String id = null;
    private String title = null;
    private Double max = null;
    private Double min = null;
    private Double step = null;

    public RangeFieldFormItem() {
        this(new ArrayList<FBFormEffect>());
    }

    public RangeFieldFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.add((Widget)this.rangeBox);
        this.setWidth("150px");
        this.setHeight("25px");
        this.rangeBox.setWidth(this.getWidth());
        this.rangeBox.setHeight(this.getHeight());
    }

    @Override
    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("defaultValue", this.defaultValue);
        map.put("name", this.name);
        map.put("height", this.getHeight());
        map.put("width", this.getWidth());
        map.put("max", this.max);
        map.put("min", this.min);
        map.put("step", this.step);
        map.put("title", this.title);
        map.put("id", this.id);
        return map;
    }

    @Override
    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.defaultValue = this.extractDouble(asPropertiesMap.get("defaultValue"));
        this.name = this.extractString(asPropertiesMap.get("name"));
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.title = this.extractString(asPropertiesMap.get("title"));
        this.max = this.extractDouble(asPropertiesMap.get("max"));
        this.min = this.extractDouble(asPropertiesMap.get("min"));
        this.step = this.extractDouble(asPropertiesMap.get("step"));
        this.id = this.extractString(asPropertiesMap.get("id"));
        this.populate(this.rangeBox);
    }

    private void populate(RangeBox rangeBox) {
        if (this.defaultValue != null) {
            rangeBox.setValue(this.defaultValue);
        }
        if (this.name != null) {
            rangeBox.setName(this.name);
        }
        if (this.getHeight() != null) {
            rangeBox.setHeight(this.getHeight());
        }
        if (this.getWidth() != null) {
            rangeBox.setWidth(this.getWidth());
        }
        if (this.title != null) {
            rangeBox.setTitle(this.title);
        }
        if (this.max != null) {
            rangeBox.setMax(this.max);
        }
        if (this.max != null) {
            rangeBox.setMin(this.min);
        }
        if (this.max != null) {
            rangeBox.setStep(this.step);
        }
    }

    @Override
    public FormBuilderDTO getRepresentation() {
        FormBuilderDTO dto = super.getRepresentation();
        dto.setDouble("defaultValue", this.defaultValue);
        dto.setString("name", this.name);
        dto.setString("id", this.id);
        dto.setDouble("max", this.max);
        dto.setDouble("min", this.min);
        dto.setDouble("step", this.step);
        return dto;
    }

    @Override
    public void populate(FormBuilderDTO dto) throws FormBuilderException {
        if (!dto.getClassName().endsWith("RangeFieldRepresentation")) {
            throw new FormBuilderException(this.i18n.RepNotOfType(dto.getClassName(), "RangeFieldRepresentation"));
        }
        super.populate(dto);
        this.defaultValue = dto.getDouble("defaultValue");
        this.name = dto.getString("name");
        this.id = dto.getString("id");
        this.max = dto.getDouble("max");
        this.min = dto.getDouble("min");
        this.step = dto.getDouble("step");
        this.populate(this.rangeBox);
    }

    @Override
    public FBFormItem cloneItem() {
        RangeFieldFormItem clone = new RangeFieldFormItem(this.getFormEffects());
        clone.defaultValue = this.defaultValue;
        clone.setHeight(this.getHeight());
        clone.id = this.id;
        clone.max = this.max;
        clone.min = this.min;
        clone.step = this.step;
        clone.name = this.name;
        clone.title = this.title;
        clone.setWidth(this.getWidth());
        clone.populate(clone.rangeBox);
        return clone;
    }

    @Override
    public Widget cloneDisplay(Map<String, Object> formData) {
        RangeBox tb = new RangeBox();
        this.populate(tb);
        Object input = this.getInputValue(formData);
        if (input != null) {
            String inputValue = input.toString();
            tb.setValue(inputValue.equals("") ? null : Double.valueOf(inputValue));
        }
        if (this.getOutput() != null && this.getOutput().get("name") != null) {
            tb.setName(String.valueOf(this.getOutput().get("name")));
        }
        super.populateActions(tb.getElement());
        return tb;
    }
}

