/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.form.items;

import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.FormBuilderException;
import org.jbpm.form.builder.ng.model.client.effect.FBFormEffect;
import org.jbpm.form.builder.ng.model.client.form.FBFormItem;
import org.jbpm.form.builder.ng.model.client.messages.I18NConstants;
import org.jbpm.form.builder.ng.model.common.panels.RichTextEditor;
import org.jbpm.form.builder.ng.model.shared.api.FormBuilderDTO;

@Reflectable
public class RichTextEditorFormItem
extends FBFormItem {
    private final I18NConstants i18n = CommonGlobals.getInstance().getI18n();
    private RichTextEditor editor = new RichTextEditor();
    private String html = "";

    public RichTextEditorFormItem() {
        this(new ArrayList<FBFormEffect>());
    }

    public RichTextEditorFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.editor.getEditorToolbar().setHeight("50px");
        this.editor.setSize("400px", "200px");
        this.setSize("400px", "200px");
        this.editor.setHTML(this.html);
        this.add((Widget)this.editor);
    }

    @Override
    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("html", this.editor.getHTML());
        map.put("width", this.getWidth());
        map.put("height", this.getHeight());
        return map;
    }

    @Override
    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.html = this.extractString(asPropertiesMap.get("html"));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.populate(this.editor);
    }

    private void populate(RichTextEditor editor) {
        if (this.getHeight() != null && !"".equals(this.getHeight())) {
            editor.setHeight(this.getHeight());
        }
        if (this.getWidth() != null && !"".equals(this.getWidth())) {
            editor.setWidth(this.getWidth());
        }
        if (this.html != null && !"".equals(this.html)) {
            editor.setHTML(this.html);
        }
    }

    @Override
    public FormBuilderDTO getRepresentation() {
        FormBuilderDTO dto = super.getRepresentation();
        dto.setString("html", this.html);
        return dto;
    }

    @Override
    public void populate(FormBuilderDTO dto) throws FormBuilderException {
        if (!dto.getClassName().endsWith("RichTextEditorRepresentation")) {
            throw new FormBuilderException(this.i18n.RepNotOfType(dto.getClassName(), "RichTextEditorRepresentation"));
        }
        super.populate(dto);
        this.html = dto.getString("html");
        this.populate(this.editor);
    }

    @Override
    public FBFormItem cloneItem() {
        RichTextEditorFormItem clone = super.cloneItem(new RichTextEditorFormItem(this.getFormEffects()));
        clone.html = this.html;
        this.populate(clone.editor);
        return clone;
    }

    @Override
    public Widget cloneDisplay(Map<String, Object> data) {
        RichTextEditor display = new RichTextEditorFormItem().editor;
        this.populate(display);
        Object input = this.getInputValue(data);
        if (input != null) {
            display.setHTML(input.toString());
        }
        if (this.getOutput() != null && this.getOutput().get("name") != null) {
            display.setName(String.valueOf(this.getOutput().get("name")));
        }
        super.populateActions(display.getElement());
        return display;
    }
}

