/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.form.items;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.FormBuilderException;
import org.jbpm.form.builder.ng.model.client.effect.FBFormEffect;
import org.jbpm.form.builder.ng.model.client.form.FBFormItem;
import org.jbpm.form.builder.ng.model.client.form.FBInplaceEditor;
import org.jbpm.form.builder.ng.model.client.form.editors.ServerScriptEditor;
import org.jbpm.form.builder.ng.model.client.messages.I18NConstants;
import org.jbpm.form.builder.ng.model.shared.api.FormBuilderDTO;

@Reflectable
public class ServerTransformationFormItem
extends FBFormItem {
    private final I18NConstants i18n = CommonGlobals.getInstance().getI18n();
    private Label scriptMarker = new Label("{ script }");
    private TextArea script = new TextArea();
    private String language;

    public ServerTransformationFormItem() {
        this(new ArrayList<FBFormEffect>());
    }

    public ServerTransformationFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.scriptMarker.setStyleName("transformationBlockBorder");
        this.add((Widget)this.scriptMarker);
    }

    @Override
    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("language", this.language);
        return map;
    }

    @Override
    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.language = this.extractString(asPropertiesMap.get("language"));
    }

    @Override
    public FormBuilderDTO getRepresentation() {
        FormBuilderDTO dto = super.getRepresentation();
        dto.setString("script", this.script.getValue());
        dto.setString("language", this.language);
        return dto;
    }

    @Override
    public void populate(FormBuilderDTO dto) throws FormBuilderException {
        if (!dto.getClassName().endsWith("ServerTransformationRepresentation")) {
            throw new FormBuilderException(this.i18n.RepNotOfType(dto.getClassName(), "ServerTransformationRepresentation"));
        }
        super.populate(dto);
        this.setScriptContent(dto.getString("script"));
        this.language = dto.getString("language");
    }

    @Override
    public FBFormItem cloneItem() {
        ServerTransformationFormItem clone = this.cloneItem(new ServerTransformationFormItem(this.getFormEffects()));
        clone.setScriptContent(this.getScriptContent());
        clone.language = this.language;
        return clone;
    }

    @Override
    public Widget cloneDisplay(Map<String, Object> data) {
        MyWidget display = new MyWidget();
        if (this.scriptMarker.getText() != null && !"".equals(this.scriptMarker.getText())) {
            this.eval0(this.scriptMarker.getText());
        }
        display.setHeight(this.getHeight());
        display.setWidth(this.getWidth());
        super.populateActions(display.getElement());
        return display;
    }

    public native void eval0(String var1);

    @Override
    public FBInplaceEditor createInplaceEditor() {
        return new ServerScriptEditor(this);
    }

    public void setScriptContent(String value) {
        this.script.setValue((Object)value);
    }

    public String getScriptContent() {
        return this.script.getValue();
    }

    class MyWidget
    extends Widget {
        public MyWidget() {
            this.setElement(DOM.createDiv());
        }
    }
}

