/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.form.items;

import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.FormBuilderException;
import org.jbpm.form.builder.ng.model.client.effect.FBFormEffect;
import org.jbpm.form.builder.ng.model.client.form.FBFormItem;
import org.jbpm.form.builder.ng.model.client.form.I18NFormItem;
import org.jbpm.form.builder.ng.model.client.form.I18NUtils;
import org.jbpm.form.builder.ng.model.client.form.OptionsFormItem;
import org.jbpm.form.builder.ng.model.client.messages.I18NConstants;
import org.jbpm.form.builder.ng.model.common.panels.ListWidget;
import org.jbpm.form.builder.ng.model.shared.api.FormBuilderDTO;

@Reflectable
public class SummaryFormItem
extends OptionsFormItem
implements I18NFormItem {
    private final I18NConstants i18n = CommonGlobals.getInstance().getI18n();
    private final ListWidget listWidget = new ListWidget();
    private final I18NUtils utils = new I18NUtils();
    private int scrollTop;
    private int scrollLeft;
    private String id;
    private String dir;
    private String cssClassName;

    public SummaryFormItem() {
        this(new ArrayList<FBFormEffect>());
    }

    public SummaryFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.add(this.listWidget);
    }

    @Override
    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> formItemPropertiesMap = new HashMap<String, Object>();
        formItemPropertiesMap.put("scrollTop", String.valueOf(this.scrollTop));
        formItemPropertiesMap.put("scrollLeft", String.valueOf(this.scrollLeft));
        formItemPropertiesMap.put("dir", this.dir);
        formItemPropertiesMap.put("id", this.id);
        formItemPropertiesMap.put("width", this.getWidth());
        formItemPropertiesMap.put("height", this.getHeight());
        formItemPropertiesMap.put("cssClassName", this.cssClassName);
        return formItemPropertiesMap;
    }

    @Override
    public void saveValues(Map<String, Object> propertiesMap) {
        this.id = this.extractString(propertiesMap.get("id"));
        this.setWidth(this.extractString(propertiesMap.get("width")));
        this.setHeight(this.extractString(propertiesMap.get("height")));
        this.cssClassName = this.extractString(propertiesMap.get("cssClassName"));
        this.dir = this.extractString(propertiesMap.get("dir"));
        this.scrollTop = this.extractInt(propertiesMap.get("scrollTop"));
        this.scrollLeft = this.extractInt(propertiesMap.get("scrollLeft"));
        this.populate(this.listWidget);
    }

    private void populate(ListWidget list) {
        if (this.getWidth() != null) {
            list.setWidth(this.getWidth());
        }
        if (this.getHeight() != null) {
            list.setHeight(this.getHeight());
        }
        if (this.cssClassName != null) {
            list.setStyleName(this.cssClassName);
        }
        if (this.id != null) {
            list.setId(this.id);
        }
        if (this.dir != null) {
            list.setDir(this.dir);
        }
        if (this.scrollTop >= 0) {
            list.setScrollTop(this.scrollTop);
        }
        if (this.scrollLeft >= 0) {
            list.setScrollLeft(this.scrollLeft);
        }
    }

    @Override
    public FormBuilderDTO getRepresentation() {
        FormBuilderDTO dto = super.getRepresentation();
        dto.setString("cssClassName", this.cssClassName);
        dto.setString("dir", this.dir);
        dto.setString("id", this.id);
        dto.setInteger("scrollLeft", this.scrollLeft);
        dto.setInteger("scrollTop", this.scrollTop);
        dto.setMapOfStrings("i18n", this.getI18nMap());
        ArrayList<Object> items = new ArrayList<Object>(this.listWidget.getItems());
        dto.setList("items", items);
        return dto;
    }

    @Override
    public void populate(FormBuilderDTO dto) throws FormBuilderException {
        if (!dto.getClassName().endsWith("SummaryRepresentation")) {
            throw new FormBuilderException(this.i18n.RepNotOfType(dto.getClassName(), "SummaryRepresentation"));
        }
        super.populate(dto);
        this.cssClassName = dto.getString("cssClassName");
        this.dir = dto.getString("dir");
        this.saveI18nMap(dto.getMapOfStrings("i18n"));
        this.id = dto.getString("id");
        this.scrollLeft = dto.getInteger("scrollLeft");
        this.scrollTop = dto.getInteger("scrollTop");
        this.populate(this.listWidget);
    }

    @Override
    public Widget cloneDisplay(Map<String, Object> formData) {
        ListWidget lw = new ListWidget();
        this.populate(lw);
        Object value = this.getInputValue(formData);
        if (value != null) {
            if (value.getClass().isArray()) {
                Object[] arr;
                for (Object obj : arr = (Object[])value) {
                    lw.addItem(String.valueOf(obj));
                }
            } else if (value instanceof Collection) {
                Collection coll = (Collection)value;
                for (Object obj : coll) {
                    lw.addItem(String.valueOf(obj));
                }
            } else if (value instanceof Map) {
                Map map = (Map)value;
                for (Object obj : map.values()) {
                    lw.addItem(String.valueOf(obj));
                }
            }
        } else {
            String locale = (String)formData.get("org.jbpm.formbuilder.server.render.Renderer.BASE_LOCALE");
            if (locale == null) {
                for (String item : this.listWidget.getItems()) {
                    lw.addItem(item);
                }
            } else {
                String[] items;
                String i18nText = this.getI18n(locale);
                if (i18nText != null && !"".equals(i18nText) && (items = i18nText.split(",")) != null) {
                    for (String item : items) {
                        lw.addItem(item);
                    }
                }
            }
        }
        super.populateActions(lw.getElement());
        return lw;
    }

    @Override
    public FBFormItem cloneItem() {
        SummaryFormItem clone = super.cloneItem(new SummaryFormItem());
        clone.cssClassName = this.cssClassName;
        clone.id = this.id;
        clone.dir = this.dir;
        clone.scrollLeft = this.scrollLeft;
        clone.scrollTop = this.scrollTop;
        clone.setHeight(this.getHeight());
        clone.setWidth(this.getWidth());
        clone.populate(clone.listWidget);
        clone.saveI18nMap(this.getI18nMap());
        clone.setFormat(this.getFormat());
        return clone;
    }

    @Override
    public boolean containsLocale(String localeName) {
        return this.utils.containsLocale(localeName);
    }

    @Override
    public I18NFormItem.Format getFormat() {
        return this.utils.getFormat();
    }

    @Override
    public String getI18n(String key) {
        return this.utils.getI18n(key);
    }

    @Override
    public Map<String, String> getI18nMap() {
        return this.utils.getI18nMap();
    }

    @Override
    public void saveI18nMap(Map<String, String> i18nMap) {
        this.utils.saveI18nMap(i18nMap);
    }

    @Override
    public void setFormat(I18NFormItem.Format format) {
        this.utils.setFormat(format);
    }

    @Override
    public void addItem(String label, String value) {
        this.listWidget.addItem(label);
    }

    @Override
    public void deleteItem(String label) {
        this.listWidget.removeItem(label);
    }

    @Override
    public Map<String, String> getItems() {
        HashMap<String, String> items = new HashMap<String, String>();
        for (String label : this.listWidget.getItems()) {
            items.put(label, label);
        }
        return items;
    }
}

