/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.form.items;

import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.TabLayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.FormBuilderException;
import org.jbpm.form.builder.ng.model.client.effect.FBFormEffect;
import org.jbpm.form.builder.ng.model.client.form.FBFormItem;
import org.jbpm.form.builder.ng.model.client.form.LayoutFormItem;
import org.jbpm.form.builder.ng.model.client.form.PhantomPanel;
import org.jbpm.form.builder.ng.model.client.form.items.FlowLayoutFormItem;
import org.jbpm.form.builder.ng.model.client.form.items.LabelFormItem;
import org.jbpm.form.builder.ng.model.client.messages.I18NConstants;
import org.jbpm.form.builder.ng.model.shared.api.FormBuilderDTO;

@Reflectable
public class TabbedLayoutFormItem
extends LayoutFormItem {
    private final I18NConstants i18n = CommonGlobals.getInstance().getI18n();
    private final List<FlowLayoutFormItem> tabs = new ArrayList<FlowLayoutFormItem>();
    private final List<TabLabelFormItem> titles = new ArrayList<TabLabelFormItem>();
    private String cssClassName;
    private String tabWidth;
    private String id;
    private TabLayoutPanel panel = new MyTabLayoutPanel(21.0, Style.Unit.PX);

    public TabbedLayoutFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        TabLabelFormItem tab1 = new TabLabelFormItem(this.getFormEffects());
        tab1.getLabel().setText("Tab 1");
        this.panel.add((Widget)new FlowLayoutFormItem(this.getFormEffects()), (Widget)tab1);
        TabLabelFormItem tab2 = new TabLabelFormItem(this.getFormEffects());
        tab2.getLabel().setText("Tab 2");
        this.panel.add((Widget)new FlowLayoutFormItem(this.getFormEffects()), (Widget)tab2);
        TabLabelFormItem tab3 = new TabLabelFormItem(this.getFormEffects());
        tab3.getLabel().setText("Tab 3");
        this.panel.add((Widget)new FlowLayoutFormItem(this.getFormEffects()), (Widget)tab3);
        this.setSize("300px", "400px");
        this.panel.setSize("300px", "400px");
        this.add((Widget)this.panel);
    }

    public TabbedLayoutFormItem() {
        this(new ArrayList<FBFormEffect>());
    }

    @Override
    public void replacePhantom(FBFormItem item) {
        int selectedIndex = this.panel.getSelectedIndex();
        Widget tabWidget = this.panel.getWidget(selectedIndex);
        FlowLayoutFormItem tab = (FlowLayoutFormItem)tabWidget;
        tab.replacePhantom(item);
    }

    @Override
    public void add(PhantomPanel phantom, int x, int y) {
        int selectedIndex = this.panel.getSelectedIndex();
        Widget widget = this.panel.getWidget(selectedIndex);
        FlowLayoutFormItem tab = (FlowLayoutFormItem)widget;
        tab.add(phantom, x, y);
    }

    @Override
    public HasWidgets getPanel() {
        return this.panel;
    }

    @Override
    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("height", this.getHeight());
        map.put("width", this.getWidth());
        map.put("cssClassName", this.cssClassName);
        map.put("id", this.id);
        map.put("numberOfTabs", this.panel.getWidgetCount());
        return map;
    }

    @Override
    public void saveValues(Map<String, Object> asPropertiesMap) {
        block5: {
            Integer numberOfTabs;
            block4: {
                String width;
                String height = this.extractString(asPropertiesMap.get("height"));
                if (height != null && !"".equals(height)) {
                    this.setHeight(height);
                }
                if ((width = this.extractString(asPropertiesMap.get("width"))) != null && !"".equals(width)) {
                    this.setWidth(width);
                }
                this.cssClassName = this.extractString(asPropertiesMap.get("cssClassName"));
                this.id = this.extractString(asPropertiesMap.get("id"));
                numberOfTabs = this.extractInt(asPropertiesMap.get("numberOfTabs"));
                if (numberOfTabs <= this.panel.getWidgetCount()) break block4;
                for (int qtyToAdd = numberOfTabs - this.panel.getWidgetCount(); qtyToAdd > 0; --qtyToAdd) {
                    TabLabelFormItem label = new TabLabelFormItem(this.getFormEffects());
                    FlowLayoutFormItem flow = new FlowLayoutFormItem(this.getFormEffects());
                    label.getLabel().setText("Tab " + this.panel.getWidgetCount());
                    this.panel.add((Widget)flow, (Widget)label);
                }
                break block5;
            }
            if (numberOfTabs >= this.panel.getWidgetCount()) break block5;
            while (numberOfTabs.intValue() != this.panel.getWidgetCount()) {
                this.panel.remove(this.panel.getWidgetCount() - 1);
                Integer n = numberOfTabs;
                Integer n2 = numberOfTabs = Integer.valueOf(numberOfTabs - 1);
            }
        }
    }

    @Override
    public FormBuilderDTO getRepresentation() {
        FormBuilderDTO dto = super.getRepresentation();
        dto.setString("cssClassName", this.cssClassName);
        dto.setString("id", this.id);
        dto.setString("tabWidth", this.tabWidth);
        ArrayList<Object> itemMaps = new ArrayList<Object>();
        for (int index = 0; index < this.titles.size(); ++index) {
            FlowLayoutFormItem tabContent = null;
            if (index < this.tabs.size()) {
                tabContent = this.tabs.get(index);
            }
            if (tabContent == null) {
                tabContent = new FlowLayoutFormItem(this.getFormEffects());
            }
            Map<String, Object> subItemMap = tabContent.getRepresentation().getParameters();
            String tabTitle = this.titles.get(index).getLabel().getText();
            subItemMap.put("tabLayoutTitle", tabTitle);
            subItemMap.put("tabLayoutIndex", String.valueOf(index));
            itemMaps.add(subItemMap);
        }
        dto.setList("tabs", itemMaps);
        return dto;
    }

    private void populate(TabLayoutPanel panel) {
        panel.setHeight(this.getHeight());
        panel.setWidth(this.getWidth());
        panel.clear();
        for (int index = 0; index < this.titles.size() && index < this.tabs.size(); ++index) {
            FlowLayoutFormItem flow = this.tabs.get(index);
            TabLabelFormItem label = this.titles.get(index);
            if (flow == null || label == null) continue;
            FlowLayoutFormItem newFlow = (FlowLayoutFormItem)flow.cloneItem();
            if (this.cssClassName != null && !"".equals(this.cssClassName)) {
                newFlow.setStyleName(this.cssClassName);
            }
            panel.add((Widget)newFlow, (Widget)label.cloneItem());
        }
    }

    @Override
    public FBFormItem cloneItem() {
        TabbedLayoutFormItem clone = new TabbedLayoutFormItem(this.getFormEffects());
        clone.id = this.id;
        clone.cssClassName = this.cssClassName;
        for (TabLabelFormItem label : this.titles) {
            clone.titles.add((TabLabelFormItem)label.cloneItem());
        }
        for (FlowLayoutFormItem flow : this.tabs) {
            clone.tabs.add((FlowLayoutFormItem)flow.cloneItem());
        }
        this.populate(clone.panel);
        return clone;
    }

    @Override
    public Widget cloneDisplay(Map<String, Object> data) {
        MyTabLayoutPanel panel = new MyTabLayoutPanel(25.0, Style.Unit.PX);
        panel.getElement().setId(this.id);
        panel.getElement().setClassName(this.cssClassName);
        for (int index = 0; index < this.titles.size() && index < this.tabs.size(); ++index) {
            FlowLayoutFormItem flow = this.tabs.get(index);
            TabLabelFormItem label = this.titles.get(index);
            if (flow == null || label == null) continue;
            Widget newFlow = flow.cloneDisplay(data);
            if (this.cssClassName != null && !"".equals(this.cssClassName)) {
                newFlow.setStyleName(this.cssClassName);
            }
            panel.add(newFlow, label.cloneDisplay(data));
        }
        super.populateActions(panel.getElement());
        return panel;
    }

    @Override
    public boolean add(FBFormItem item) {
        int index = this.panel.getSelectedIndex();
        Widget widget = this.panel.getWidget(index);
        FlowLayoutFormItem tab = (FlowLayoutFormItem)widget;
        return tab.add(item);
    }

    @Override
    public void populate(FormBuilderDTO dto) throws FormBuilderException {
        if (!dto.getClassName().endsWith("TabbedPanelRepresentation")) {
            throw new FormBuilderException(this.i18n.RepNotOfType(dto.getClassName(), "TabbedPanelRepresentation"));
        }
        super.populate(dto);
        this.cssClassName = dto.getString("cssClassName");
        this.id = dto.getString("id");
        this.tabWidth = dto.getString("tabWidth");
        this.titles.clear();
        List<FormBuilderDTO> itemDtos = dto.getListOfDtos("tabs");
        for (FormBuilderDTO subDto : itemDtos) {
            TabLabelFormItem label = new TabLabelFormItem(this.getFormEffects());
            label.getLabel().setText(subDto.getString("tabLayoutTitle"));
            if (this.tabWidth != null && !"".equals(this.tabWidth)) {
                label.setWidth(this.tabWidth);
            }
            FlowLayoutFormItem subItem = (FlowLayoutFormItem)FBFormItem.createItem(subDto);
            if (this.cssClassName != null && !"".equals(this.cssClassName)) {
                subItem.setStyleName(this.cssClassName);
            }
            this.tabs.add(subItem);
            this.titles.add(label);
        }
        this.populate(this.panel);
    }

    public int getTabForCoordinates(int x, int y) {
        for (int tabNumber = 0; tabNumber < this.panel.getWidgetCount(); ++tabNumber) {
            Widget widget = this.panel.getTabWidget(tabNumber);
            int left = widget.getAbsoluteLeft();
            int top = widget.getAbsoluteTop();
            int right = left + widget.getOffsetWidth();
            int bottom = top + widget.getOffsetHeight();
            if (x <= left || x >= right || y <= top || y >= bottom) continue;
            return tabNumber;
        }
        return this.panel.getSelectedIndex();
    }

    public FBFormItem[] removeTab(int tabNumber) {
        FBFormItem[] retval = new FBFormItem[]{this.titles.get(tabNumber), this.tabs.get(tabNumber)};
        this.titles.remove(tabNumber);
        this.tabs.remove(tabNumber);
        this.panel.remove(tabNumber);
        return retval;
    }

    public void insertTab(int tabNumber, TabLabelFormItem label, FlowLayoutFormItem panel) {
        if (label == null) {
            label = new TabLabelFormItem(this.getFormEffects());
            label.getLabel().setText("Tab " + (tabNumber + 1));
            if (this.tabWidth != null && !"".equals(this.tabWidth)) {
                label.setWidth(this.tabWidth);
            }
        }
        if (panel == null) {
            panel = new FlowLayoutFormItem(this.getFormEffects());
            if (this.cssClassName != null && !"".equals(this.cssClassName)) {
                panel.setStyleName(this.cssClassName);
            }
        }
        this.panel.insert((Widget)panel, (Widget)label, tabNumber);
        List<TabLabelFormItem> nextLabels = this.titles.subList(tabNumber, this.titles.size() - 1);
        this.titles.removeAll(nextLabels);
        this.titles.add(label);
        this.titles.addAll(nextLabels);
        List<FlowLayoutFormItem> nextPanels = this.tabs.subList(tabNumber, this.tabs.size() - 1);
        this.tabs.removeAll(nextPanels);
        this.tabs.add(panel);
        this.tabs.addAll(nextPanels);
    }

    public class MyTabLayoutPanel
    extends TabLayoutPanel {
        public MyTabLayoutPanel(double barHeight, Style.Unit barUnit) {
            super(barHeight, barUnit);
        }

        public boolean remove(Widget widget) {
            if (widget instanceof FBFormItem) {
                TabbedLayoutFormItem.this.removeItem((FBFormItem)widget);
            }
            return super.remove(widget);
        }
    }

    public class TabLabelFormItem
    extends LabelFormItem {
        public TabLabelFormItem(List<FBFormEffect> formEffects) {
            super(formEffects);
        }

        @Override
        public FBFormItem cloneItem() {
            LabelFormItem supItem = (LabelFormItem)super.cloneItem();
            TabLabelFormItem clone = new TabLabelFormItem(this.getFormEffects());
            try {
                clone.populate(supItem.getRepresentation());
            }
            catch (FormBuilderException formBuilderException) {
                // empty catch block
            }
            return clone;
        }

        @Override
        public void saveValues(Map<String, Object> propertiesMap) {
            super.saveValues(propertiesMap);
            String width = this.extractString(propertiesMap.get("width"));
            String height = this.extractString(propertiesMap.get("height"));
            if (width != null && !"".equals(width)) {
                for (TabLabelFormItem item : TabbedLayoutFormItem.this.titles) {
                    item.setWidth(width);
                    TabbedLayoutFormItem.this.tabWidth = width;
                }
            }
            if (height != null && !"".equals(height)) {
                for (TabLabelFormItem item : TabbedLayoutFormItem.this.titles) {
                    item.setHeight(height);
                }
            }
        }
    }
}

