/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.form.items;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.FormBuilderException;
import org.jbpm.form.builder.ng.model.client.bus.ui.NotificationEvent;
import org.jbpm.form.builder.ng.model.client.effect.FBFormEffect;
import org.jbpm.form.builder.ng.model.client.form.FBFormItem;
import org.jbpm.form.builder.ng.model.client.form.LayoutFormItem;
import org.jbpm.form.builder.ng.model.client.form.PhantomPanel;
import org.jbpm.form.builder.ng.model.client.messages.I18NConstants;
import org.jbpm.form.builder.ng.model.shared.api.FormBuilderDTO;

@Reflectable
public class TableLayoutFormItem
extends LayoutFormItem {
    private final I18NConstants i18n = CommonGlobals.getInstance().getI18n();
    private Grid grid = new Grid(1, 1){

        public boolean remove(Widget widget) {
            if (widget instanceof FBFormItem) {
                int row;
                boolean found = false;
                int column = 0;
                for (row = 0; row < super.getRowCount() && !found; ++row) {
                    for (column = 0; column < super.getColumnCount() && !found; ++column) {
                        Widget cellWidget = super.getWidget(row, column);
                        if (cellWidget != null && cellWidget.equals(widget)) {
                            found = true;
                        }
                        if (found) break;
                    }
                    if (found) break;
                }
                if (found) {
                    super.remove(widget);
                    this.getCellFormatter().getElement(row, column).setInnerHTML("&nbsp");
                }
                return found;
            }
            if (widget instanceof PhantomPanel) {
                int row;
                boolean retval = false;
                int column = 0;
                for (row = 0; row < super.getRowCount() && !retval; ++row) {
                    for (column = 0; column < super.getColumnCount() && !retval; ++column) {
                        if (super.getWidget(row, column) == null || !TableLayoutFormItem.this.isPhantom(super.getWidget(row, column))) continue;
                        this.getCellFormatter().getElement(row, column).setInnerHTML("&nbsp");
                        break;
                    }
                    if (retval) break;
                }
                if (retval) {
                    super.remove(widget);
                    this.getCellFormatter().getElement(row, column).setInnerHTML("&nbsp");
                }
                return retval;
            }
            return super.remove(widget);
        }
    };
    private final EventBus bus = CommonGlobals.getInstance().getEventBus();
    private Integer borderWidth = 1;
    private Integer cellpadding = null;
    private Integer cellspacing = null;
    private Integer columns = 1;
    private Integer rows = 1;
    private String title = null;

    public TableLayoutFormItem() {
        this(new ArrayList<FBFormEffect>());
    }

    public TableLayoutFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.grid.setBorderWidth(this.borderWidth.intValue());
        this.add((Widget)this.grid);
        this.setSize("90px", "90px");
        this.grid.setSize(this.getWidth(), this.getHeight());
    }

    @Override
    public HasWidgets getPanel() {
        return this.grid;
    }

    @Override
    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.borderWidth = this.extractInt(asPropertiesMap.get("borderWidth"));
        this.cellpadding = this.extractInt(asPropertiesMap.get("cellpadding"));
        this.cellspacing = this.extractInt(asPropertiesMap.get("cellspacing"));
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.title = this.extractString(asPropertiesMap.get("title"));
        this.columns = this.extractInt(asPropertiesMap.get("columns"));
        this.rows = this.extractInt(asPropertiesMap.get("rows"));
        this.populate(this.grid);
    }

    private void populate(Grid grid) {
        if (this.borderWidth != null && this.borderWidth > 0) {
            grid.setBorderWidth(this.borderWidth.intValue());
        }
        if (this.cellpadding != null && this.cellpadding >= 0) {
            grid.setCellPadding(this.cellpadding.intValue());
        }
        if (this.cellspacing != null && this.cellspacing >= 0) {
            grid.setCellSpacing(this.cellspacing.intValue());
        }
        if (this.getHeight() != null) {
            grid.setHeight(this.getHeight());
        }
        if (this.getWidth() != null) {
            grid.setWidth(this.getWidth());
        }
        if (this.title != null) {
            grid.setTitle(this.title);
        }
        if (this.columns != null && this.columns > 0) {
            grid.resizeColumns(this.columns.intValue());
        }
        if (this.rows != null && this.rows > 0) {
            grid.resizeRows(this.rows.intValue());
        }
    }

    @Override
    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("borderWidth", this.borderWidth);
        map.put("cellpadding", this.cellpadding);
        map.put("cellspacing", this.cellspacing);
        map.put("height", this.getHeight());
        map.put("width", this.getWidth());
        map.put("title", this.title);
        map.put("columns", this.columns);
        map.put("rows", this.rows);
        return map;
    }

    @Override
    public boolean add(FBFormItem child) {
        boolean added = false;
        block0: for (int i = 0; i < this.grid.getRowCount() && !added; ++i) {
            for (int j = 0; j < this.grid.getColumnCount() && !added; ++j) {
                if (this.grid.getWidget(i, j) != null && !this.isWhiteSpace(this.grid.getWidget(i, j))) continue;
                added = true;
                int index = i * this.grid.getColumnCount() + j;
                if (super.size() > index) {
                    super.insert(index - 1, child);
                } else {
                    super.add(child);
                }
                this.grid.setWidget(i, j, (Widget)child);
                continue block0;
            }
        }
        if (!added) {
            this.bus.fireEvent((GwtEvent)new NotificationEvent(NotificationEvent.Level.WARN, this.i18n.TableFull()));
            return false;
        }
        return true;
    }

    @Override
    public void add(PhantomPanel phantom, int x, int y) {
        int row = 0;
        int column = 0;
        boolean found = false;
        while (row < this.grid.getRowCount() && !found) {
            for (column = 0; column < this.grid.getColumnCount() && !found; ++column) {
                Element cellElement = this.grid.getCellFormatter().getElement(row, column);
                if (x <= cellElement.getAbsoluteLeft() || x >= cellElement.getAbsoluteRight() || y <= cellElement.getAbsoluteTop() || y >= cellElement.getAbsoluteBottom() || this.grid.getWidget(row, column) != null && !this.isWhiteSpace(this.grid.getWidget(row, column)) && !this.isPhantom(this.grid.getWidget(row, column))) continue;
                found = true;
                break;
            }
            if (found) continue;
            ++row;
        }
        if (found && !this.isPhantom(this.grid.getWidget(row, column))) {
            this.grid.setWidget(row, column, (Widget)phantom);
        }
    }

    public int getRowForYCoordinate(int y) {
        for (int row = 0; row < this.grid.getRowCount(); ++row) {
            Element rowElement = this.grid.getRowFormatter().getElement(row);
            if (y <= rowElement.getAbsoluteTop() || y >= rowElement.getAbsoluteBottom()) continue;
            return row;
        }
        return -1;
    }

    public List<FBFormItem> removeRow(int rowNumber) {
        ArrayList<FBFormItem> retval = null;
        if (rowNumber < this.grid.getRowCount()) {
            retval = new ArrayList<FBFormItem>(this.grid.getColumnCount());
            for (int column = 0; column < this.grid.getColumnCount(); ++column) {
                Widget widget = this.grid.getWidget(rowNumber, column);
                if (widget instanceof FBFormItem) {
                    retval.add((FBFormItem)widget);
                } else {
                    retval.add(null);
                }
                this.grid.remove(widget);
            }
            this.grid.removeRow(rowNumber);
            TableLayoutFormItem tableLayoutFormItem = this;
            Integer n = tableLayoutFormItem.rows;
            Integer n2 = tableLayoutFormItem.rows = Integer.valueOf(tableLayoutFormItem.rows - 1);
        }
        return retval;
    }

    public void addRow(int beforeRowNumber) {
        this.grid.insertRow(beforeRowNumber);
        TableLayoutFormItem tableLayoutFormItem = this;
        Integer n = tableLayoutFormItem.rows;
        Integer n2 = tableLayoutFormItem.rows = Integer.valueOf(tableLayoutFormItem.rows + 1);
    }

    public void insertRowElements(int rowNumber, List<FBFormItem> rowItems) {
        FBFormItem prevItem = null;
        for (int i = rowNumber - 1; i > 0 && prevItem == null; --i) {
            for (int j = this.grid.getColumnCount(); j > 0 && prevItem == null; --j) {
                Widget widget = this.grid.getWidget(i, j);
                if (widget == null || !(widget instanceof FBFormItem)) continue;
                prevItem = (FBFormItem)widget;
            }
        }
        int index = prevItem == null ? -1 : super.getItems().indexOf((Object)prevItem);
        int colNumber = 0;
        for (FBFormItem newItem : rowItems) {
            if (newItem != null) {
                if (index < 0) {
                    super.add(newItem);
                } else {
                    super.insert(index, newItem);
                }
                ++index;
                this.grid.setWidget(rowNumber, colNumber, (Widget)newItem);
            }
            ++colNumber;
        }
    }

    public void insertColumnElements(int colNumber, List<FBFormItem> columnItems) {
        int rowNumber = 0;
        for (FBFormItem newItem : columnItems) {
            int index;
            FBFormItem prevItem = null;
            for (int i = this.grid.getRowCount(); i > 0 && prevItem == null; --i) {
                for (int j = colNumber - 1; j > 0 && prevItem == null; --j) {
                    Widget widget = this.grid.getWidget(i, j);
                    if (widget == null || !(widget instanceof FBFormItem)) continue;
                    prevItem = (FBFormItem)widget;
                }
            }
            int n = index = prevItem == null ? -1 : super.getItems().indexOf((Object)prevItem);
            if (newItem != null) {
                if (index < 0) {
                    super.add(newItem);
                } else {
                    super.insert(index, newItem);
                }
                this.grid.setWidget(rowNumber, colNumber, (Widget)newItem);
            }
            ++rowNumber;
        }
    }

    public int getColumnForXCoordinate(int x) {
        if (this.grid.getRowCount() > 0) {
            for (int column = 0; column < this.grid.getColumnCount(); ++column) {
                Element cellElement = this.grid.getCellFormatter().getElement(0, column);
                if (x <= cellElement.getAbsoluteLeft() || x >= cellElement.getAbsoluteRight()) continue;
                return column;
            }
        }
        return -1;
    }

    public void addColumn(int beforeColumnNumber) {
        if (beforeColumnNumber < this.grid.getColumnCount()) {
            TableLayoutFormItem tableLayoutFormItem = this;
            Integer n = tableLayoutFormItem.columns;
            Integer n2 = tableLayoutFormItem.columns = Integer.valueOf(tableLayoutFormItem.columns + 1);
            this.grid.resizeColumns(this.grid.getColumnCount() + 1);
            for (int row = 0; row < this.grid.getRowCount(); ++row) {
                for (int column = this.grid.getColumnCount() - 1; column > beforeColumnNumber && column < this.grid.getColumnCount(); ++column) {
                    Widget widget;
                    if (column <= 0 || (widget = this.grid.getWidget(row, column - 1)) == null) continue;
                    this.grid.setWidget(row, column, widget);
                    if (this.grid.getWidget(row, column - 1) == null) continue;
                    this.grid.getWidget(row, column - 1).getElement().getParentElement().setInnerHTML("&nbsp;");
                }
            }
        }
    }

    public List<FBFormItem> removeColumn(int columnNumber) {
        ArrayList<FBFormItem> retval = null;
        if (columnNumber < this.grid.getColumnCount()) {
            retval = new ArrayList<FBFormItem>(this.grid.getRowCount());
            for (int row = 0; row < this.grid.getRowCount(); ++row) {
                for (int column = columnNumber + 1; column < this.grid.getColumnCount(); ++column) {
                    Widget widget = this.grid.getWidget(row, column);
                    if (column == columnNumber + 1 && widget instanceof FBFormItem) {
                        retval.add((FBFormItem)widget);
                    } else if (column == columnNumber + 1) {
                        retval.add(null);
                    }
                    this.grid.setWidget(row, column - 1, widget);
                    this.remove(widget);
                }
            }
            this.grid.resizeColumns(this.grid.getColumnCount() - 1);
            TableLayoutFormItem tableLayoutFormItem = this;
            Integer n = tableLayoutFormItem.columns;
            Integer n2 = tableLayoutFormItem.columns = Integer.valueOf(tableLayoutFormItem.columns - 1);
        }
        return retval;
    }

    protected boolean isPhantom(Widget widget) {
        return widget != null && widget instanceof PhantomPanel;
    }

    @Override
    public void replacePhantom(FBFormItem item) {
        int row;
        boolean found = false;
        int column = 0;
        for (row = 0; row < this.grid.getRowCount(); ++row) {
            for (column = 0; column < this.grid.getColumnCount() && !found; ++column) {
                if (!this.isPhantom(this.grid.getWidget(row, column))) continue;
                found = true;
                break;
            }
            if (found) break;
        }
        if (found) {
            int index = row * this.grid.getColumnCount() + column;
            if (super.size() > index) {
                super.insert(index, item);
            } else {
                super.add(item);
            }
            this.grid.setWidget(row, column, null);
            this.grid.setWidget(row, column, (Widget)item);
        } else {
            this.add(item);
        }
    }

    @Override
    public boolean removeItem(FBFormItem item) {
        return false;
    }

    @Override
    public FormBuilderDTO getRepresentation() {
        FormBuilderDTO dto = super.getRepresentation();
        dto.setInteger("rows", this.rows);
        dto.setInteger("columns", this.columns);
        dto.setInteger("borderWidth", this.borderWidth);
        dto.setInteger("cellPadding", this.cellpadding);
        dto.setInteger("cellSpacing", this.cellspacing);
        ArrayList<Object> elements = new ArrayList<Object>();
        for (int index = 0; index < this.columns * this.rows; ++index) {
            int column = index % this.columns;
            int row = index / this.columns;
            Widget widget = this.grid.getWidget(row, column);
            if (widget == null || !(widget instanceof FBFormItem)) continue;
            FBFormItem item = (FBFormItem)widget;
            FormBuilderDTO subDto = item.getRepresentation();
            subDto.setInteger("tableLayoutRow", row);
            subDto.setInteger("tableLayoutColumn", column);
            elements.add(subDto.getParameters());
        }
        dto.setList("elements", elements);
        return dto;
    }

    @Override
    public void populate(FormBuilderDTO dto) throws FormBuilderException {
        if (!dto.getClassName().endsWith("TableRepresentation")) {
            throw new FormBuilderException(this.i18n.RepNotOfType(dto.getClassName(), "TableRepresentation"));
        }
        super.populate(dto);
        this.rows = dto.getInteger("rows");
        this.columns = dto.getInteger("columns");
        this.borderWidth = dto.getInteger("borderWidth");
        this.cellpadding = dto.getInteger("cellPadding");
        this.cellspacing = dto.getInteger("cellSpacing");
        this.populate(this.grid);
        this.grid.clear();
        super.getItems().clear();
        List<FormBuilderDTO> elements = dto.getListOfDtos("elements");
        if (elements != null) {
            for (FormBuilderDTO elem : elements) {
                if (elem == null) continue;
                Integer row = elem.getInteger("row");
                Integer col = elem.getInteger("column");
                FBFormItem subItem = LayoutFormItem.createItem(elem);
                this.grid.setWidget(row.intValue(), col.intValue(), (Widget)subItem);
                super.add(subItem);
            }
        }
    }

    private void addItemToCollection(FBFormItem item) {
        super.add(item);
    }

    @Override
    public FBFormItem cloneItem() {
        TableLayoutFormItem clone = new TableLayoutFormItem(this.getFormEffects());
        clone.borderWidth = this.borderWidth;
        clone.cellpadding = this.cellpadding;
        clone.cellspacing = this.cellspacing;
        clone.columns = this.columns;
        clone.setHeight(this.getHeight());
        clone.rows = this.rows;
        clone.title = this.title;
        clone.setWidth(this.getWidth());
        clone.populate(clone.grid);
        for (int index = 0; index < clone.columns * clone.rows; ++index) {
            int column = index % clone.columns;
            int row = index / clone.columns;
            FBFormItem item = (FBFormItem)this.grid.getWidget(row, column);
            if (item == null) continue;
            clone.grid.setWidget(row, column, (Widget)item.cloneItem());
        }
        List<FBFormItem> items = this.getItems();
        if (items != null) {
            for (FBFormItem item : items) {
                clone.addItemToCollection(item);
            }
        }
        return clone;
    }

    @Override
    public Widget cloneDisplay(Map<String, Object> data) {
        Grid g = new Grid(this.rows.intValue(), this.columns.intValue());
        this.populate(g);
        for (int index = 0; index < this.columns * this.rows; ++index) {
            int column = index % this.columns;
            int row = index / this.columns;
            FBFormItem item = (FBFormItem)this.grid.getWidget(row, column);
            if (item == null) continue;
            g.setWidget(row, column, item.cloneDisplay(data));
        }
        super.populateActions(g.getElement());
        return g;
    }
}

