/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.form.items;

import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.FormBuilderException;
import org.jbpm.form.builder.ng.model.client.effect.FBFormEffect;
import org.jbpm.form.builder.ng.model.client.form.FBFormItem;
import org.jbpm.form.builder.ng.model.client.messages.I18NConstants;
import org.jbpm.form.builder.ng.model.shared.api.FormBuilderDTO;

@Reflectable
public class TextAreaFormItem
extends FBFormItem {
    private final I18NConstants i18n = CommonGlobals.getInstance().getI18n();
    private TextArea area = new TextArea();
    private String defaultValue;
    private Integer rows = 3;
    private Integer cols = 30;
    private String name;
    private String id;

    public TextAreaFormItem() {
        this(new ArrayList<FBFormEffect>());
    }

    public TextAreaFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.area.setVisibleLines(this.rows.intValue());
        this.area.setCharacterWidth(this.cols.intValue());
        this.add((Widget)this.area);
    }

    @Override
    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("defaultValue", this.defaultValue);
        map.put("rows", this.rows);
        map.put("cols", this.cols);
        map.put("name", this.name);
        map.put("id", this.id);
        map.put("width", this.getWidth());
        map.put("height", this.getHeight());
        return map;
    }

    @Override
    public void saveValues(Map<String, Object> asPropertiesMap) {
        Integer rows = this.extractInt(asPropertiesMap.get("rows"));
        Integer cols = this.extractInt(asPropertiesMap.get("cols"));
        this.defaultValue = this.extractString(asPropertiesMap.get("defaultValue"));
        this.name = this.extractString(asPropertiesMap.get("name"));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        if (rows != null && rows > 0) {
            this.rows = rows;
        }
        if (cols != null && cols > 0) {
            this.cols = cols;
        }
        this.populate(this.area);
    }

    private void populate(TextArea area) {
        if (this.rows != null) {
            area.setVisibleLines(this.rows.intValue());
        }
        if (this.cols != null) {
            area.setCharacterWidth(this.cols.intValue());
        }
        if (this.defaultValue != null) {
            area.setValue((Object)this.defaultValue);
        }
        if (this.name != null) {
            area.setName(this.name);
        }
        if (this.getWidth() != null) {
            area.setWidth(this.getWidth());
        }
        if (this.getHeight() != null) {
            area.setHeight(this.getHeight());
        }
    }

    @Override
    public FormBuilderDTO getRepresentation() {
        FormBuilderDTO dto = super.getRepresentation();
        dto.setInteger("cols", this.cols);
        dto.setString("id", this.id);
        dto.setString("name", this.name);
        dto.setInteger("rows", this.rows);
        dto.setString("value", this.defaultValue);
        return dto;
    }

    @Override
    public void populate(FormBuilderDTO dto) throws FormBuilderException {
        if (!dto.getClassName().endsWith("TextAreaRepresentation")) {
            throw new FormBuilderException(this.i18n.RepNotOfType(dto.getClassName(), "TextAreaRepresentation"));
        }
        super.populate(dto);
        this.cols = dto.getInteger("cols");
        this.id = dto.getString("id");
        this.name = dto.getString("name");
        this.rows = dto.getInteger("rows");
        this.defaultValue = dto.getString("value");
        this.populate(this.area);
    }

    @Override
    public FBFormItem cloneItem() {
        TextAreaFormItem clone = new TextAreaFormItem(this.getFormEffects());
        clone.cols = this.cols;
        clone.defaultValue = this.defaultValue;
        clone.id = this.id;
        clone.name = this.name;
        clone.rows = this.rows;
        clone.populate(clone.area);
        return clone;
    }

    @Override
    public Widget cloneDisplay(Map<String, Object> data) {
        TextArea ta = new TextArea();
        this.populate(ta);
        Object input = this.getInputValue(data);
        if (input != null) {
            ta.setValue((Object)input.toString());
        }
        if (this.getOutput() != null && this.getOutput().get("name") != null) {
            ta.setName(String.valueOf(this.getOutput().get("name")));
        }
        super.populateActions(ta.getElement());
        return ta;
    }

    public String getInputValue() {
        return this.area.getValue();
    }
}

