/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.form.items;

import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.FormBuilderException;
import org.jbpm.form.builder.ng.model.client.effect.FBFormEffect;
import org.jbpm.form.builder.ng.model.client.form.FBFormItem;
import org.jbpm.form.builder.ng.model.client.messages.I18NConstants;
import org.jbpm.form.builder.ng.model.shared.api.FormBuilderDTO;

@Reflectable
public class TextFieldFormItem
extends FBFormItem {
    private final I18NConstants i18n = CommonGlobals.getInstance().getI18n();
    private final TextBox textBox = new TextBox();
    private String defaultContent = null;
    private String name = null;
    private String id = null;
    private String title = null;
    private Integer maxlength = null;

    public TextFieldFormItem() {
        this(new ArrayList<FBFormEffect>());
    }

    public TextFieldFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.add((Widget)this.textBox);
        this.setWidth("150px");
        this.setHeight("25px");
        this.textBox.setWidth(this.getWidth());
        this.textBox.setHeight(this.getHeight());
    }

    @Override
    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("inputDefaultContent", this.defaultContent);
        map.put("name", this.name);
        map.put("height", this.getHeight());
        map.put("width", this.getWidth());
        map.put("maxlength", this.maxlength);
        map.put("title", this.title);
        map.put("id", this.id);
        return map;
    }

    @Override
    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.defaultContent = this.extractString(asPropertiesMap.get("inputDefaultContent"));
        this.name = this.extractString(asPropertiesMap.get("name"));
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.title = this.extractString(asPropertiesMap.get("title"));
        this.maxlength = this.extractInt(asPropertiesMap.get("maxlength"));
        this.id = this.extractString(asPropertiesMap.get("id"));
        this.populate(this.textBox);
    }

    private void populate(TextBox textBox) {
        if (this.defaultContent != null) {
            textBox.setValue((Object)this.defaultContent);
        }
        if (this.name != null) {
            textBox.setName(this.name);
        }
        if (this.getHeight() != null) {
            textBox.setHeight(this.getHeight());
        }
        if (this.getWidth() != null) {
            textBox.setWidth(this.getWidth());
        }
        if (this.title != null) {
            textBox.setTitle(this.title);
        }
        if (this.maxlength != null) {
            textBox.setMaxLength(this.maxlength.intValue());
        }
    }

    @Override
    public FormBuilderDTO getRepresentation() {
        FormBuilderDTO rep = super.getRepresentation();
        rep.setString("defaultValue", this.defaultContent);
        rep.setString("name", this.name);
        rep.setString("id", this.id);
        rep.setInteger("maxLength", this.maxlength);
        return rep;
    }

    @Override
    public void populate(FormBuilderDTO dto) throws FormBuilderException {
        if (!dto.getClassName().endsWith("TextFieldRepresentation")) {
            throw new FormBuilderException(this.i18n.RepNotOfType(dto.getClassName(), "TextFieldRepresentation"));
        }
        super.populate(dto);
        this.defaultContent = dto.getString("defaultValue");
        this.name = dto.getString("name");
        this.id = dto.getString("id");
        this.maxlength = dto.getInteger("maxLength");
        this.populate(this.textBox);
    }

    @Override
    public FBFormItem cloneItem() {
        TextFieldFormItem clone = new TextFieldFormItem(this.getFormEffects());
        clone.defaultContent = this.defaultContent;
        clone.setHeight(this.getHeight());
        clone.id = this.id;
        clone.maxlength = this.maxlength;
        clone.name = this.name;
        clone.title = this.title;
        clone.setWidth(this.getWidth());
        clone.populate(clone.textBox);
        return clone;
    }

    @Override
    public Widget cloneDisplay(Map<String, Object> data) {
        TextBox tb = new TextBox();
        this.populate(tb);
        Object input = this.getInputValue(data);
        if (input != null) {
            tb.setValue((Object)input.toString());
        }
        if (this.getOutput() != null && this.getOutput().get("name") != null) {
            tb.setName(String.valueOf(this.getOutput().get("name")));
        }
        super.populateActions(tb.getElement());
        return tb;
    }
}

