/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.menu;

import com.allen_sauer.gwt.dnd.client.HasDragHandle;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.ng.model.client.bus.FormItemSelectionHandler;
import org.jbpm.form.builder.ng.model.client.effect.FBFormEffect;
import org.jbpm.form.builder.ng.model.client.form.FBFormItem;
import org.jbpm.form.builder.ng.model.shared.api.FBScript;

public abstract class FBMenuItem
extends AbsolutePanel
implements HasDragHandle {
    private FocusPanel shim = new FocusPanel();
    private final List<FBFormEffect> formEffects;
    private final List<String> allowedEvents = new ArrayList<String>();
    private FormItemSelectionHandler itemSelectionHandler;

    public FBMenuItem() {
        this(new ArrayList<FBFormEffect>());
    }

    public FBMenuItem(List<FBFormEffect> formEffects) {
        this.formEffects = formEffects;
        this.repaint();
    }

    public void repaint() {
        if (this.getWidgetCount() > 0) {
            this.remove(0);
        }
        HorizontalPanel panel = new HorizontalPanel();
        String urlIcon = this.getIconUrl().getSafeUri().asString();
        if (this.getIconUrlAsString() != null) {
            urlIcon = this.getIconUrlAsString();
        }
        panel.add((Widget)new Image(urlIcon));
        panel.add((Widget)new HTML("&nbsp;"));
        panel.add((Widget)this.getDescription());
        this.add((Widget)panel);
    }

    public List<FBFormEffect> getFormEffects() {
        return this.formEffects;
    }

    public String getItemId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public Widget getDragHandle() {
        if (!this.shim.isAttached() && this.isAttached()) {
            this.shim.setPixelSize(this.getOffsetWidth(), this.getOffsetHeight());
            this.add((Widget)this.shim, 0, 0);
        }
        return this.shim;
    }

    public void setPixelSize(int width, int height) {
        super.setPixelSize(width, height);
        this.shim.setPixelSize(width, height);
    }

    public void setSize(String width, String height) {
        super.setSize(width, height);
        this.shim.setSize(width, height);
    }

    protected void onLoad() {
        super.onLoad();
        int height = this.getOffsetHeight();
        int width = this.getOffsetWidth();
        if (height == 0 && width == 0) {
            height = 18;
            width = 210;
        }
        this.shim.setPixelSize(width, height);
        this.add((Widget)this.shim, 0, 0);
    }

    protected void onUnload() {
        super.onUnload();
        this.shim.removeFromParent();
    }

    public void addEffect(FBFormEffect effect) {
        this.formEffects.add(effect);
    }

    protected String getIconUrlAsString() {
        return null;
    }

    protected abstract ImageResource getIconUrl();

    public abstract Label getDescription();

    protected <T extends FBMenuItem> T clone(T item) {
        if (this.getFormEffects() != null) {
            for (FBFormEffect effect : this.getFormEffects()) {
                item.addEffect(effect);
            }
        }
        if (this.getAllowedEvents() != null) {
            for (String allowedEvent : this.getAllowedEvents()) {
                item.addAllowedEvent(allowedEvent);
            }
        }
        item.setItemSelectionHandler(this.itemSelectionHandler);
        return item;
    }

    protected <T extends FBFormItem> T build(T item) {
        if (this.getFormEffects() != null) {
            for (FBFormEffect effect : this.getFormEffects()) {
                item.addEffect(effect);
            }
        }
        if (this.getAllowedEvents() != null) {
            item.setEventActions(this.getAllowedEventsAsMap());
        }
        item.setItemSelectionHandler(this.itemSelectionHandler);
        return item;
    }

    public abstract FBMenuItem cloneWidget();

    public abstract FBFormItem buildWidget();

    public void addAllowedEvent(String allowedEventName) {
        this.allowedEvents.add(allowedEventName);
    }

    public List<String> getAllowedEvents() {
        return this.allowedEvents;
    }

    public Map<String, FBScript> getAllowedEventsAsMap() {
        HashMap<String, FBScript> map = new HashMap<String, FBScript>();
        for (String evtName : this.allowedEvents) {
            map.put(evtName, null);
        }
        return map;
    }

    public void setItemSelectionHandler(FormItemSelectionHandler itemSelectionHandler) {
        this.itemSelectionHandler = itemSelectionHandler;
    }
}

