/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.ng.model.client.menu;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.jbpm.form.builder.ng.model.client.CommonGlobals;
import org.jbpm.form.builder.ng.model.client.SettingsDTO;
import org.jbpm.form.builder.ng.model.client.SettingsEntryDTO;
import org.jbpm.form.builder.ng.model.client.bus.ApplySettingsEvent;
import org.jbpm.form.builder.ng.model.client.messages.I18NConstants;

public class SettingsPopupPanel
extends PopupPanel {
    private final I18NConstants i18n = CommonGlobals.getInstance().getI18n();
    private final EventBus bus = CommonGlobals.getInstance().getEventBus();
    private final ListBox storage = new ListBox(false);

    public SettingsPopupPanel(final SettingsDTO settings) {
        super(true);
        this.setStyleName("commandPopupPanel");
        VerticalPanel vPanel = new VerticalPanel();
        vPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        Grid grid = new Grid(2, 2);
        this.storage.addItem("guvnor");
        this.storage.addItem("fs");
        SettingsEntryDTO entry = settings.getEntry("storage");
        if (entry == null || "guvnor".equals(entry.getValue())) {
            this.storage.setSelectedIndex(0);
        }
        if (entry != null && "fs".equals(entry.getValue())) {
            this.storage.setSelectedIndex(1);
        }
        grid.setWidget(0, 0, (Widget)new Label(this.i18n.SettingsLabel()));
        grid.setWidget(1, 0, (Widget)new Label(this.i18n.StorageType()));
        grid.setWidget(1, 1, (Widget)this.storage);
        vPanel.add((Widget)grid);
        HorizontalPanel buttonPanel = new HorizontalPanel();
        buttonPanel.add((Widget)new Button(this.i18n.ConfirmButton(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                String storageValue = SettingsPopupPanel.this.storage.getItemText(SettingsPopupPanel.this.storage.getSelectedIndex());
                if (settings.getEntry("storage") == null) {
                    settings.addEntry(new SettingsEntryDTO("storage", storageValue));
                } else {
                    settings.getEntry("storage").setValue(storageValue);
                }
                SettingsPopupPanel.this.bus.fireEvent((GwtEvent)new ApplySettingsEvent(settings));
                SettingsPopupPanel.this.hide();
            }
        }));
        buttonPanel.add((Widget)new Button(this.i18n.CancelButton(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                SettingsPopupPanel.this.hide();
            }
        }));
        vPanel.add((Widget)buttonPanel);
        vPanel.setStyleName("commandContent");
        this.setWidget((Widget)vPanel);
    }

    public void setStorage(String storage) {
        for (int index = 0; index < this.storage.getItemCount(); ++index) {
            if (!this.storage.getValue(index).equals(storage)) continue;
            this.storage.setSelectedIndex(index);
            break;
        }
    }

    public String getStorage() {
        return this.storage.getValue(this.storage.getSelectedIndex());
    }

    protected void onLoad() {
        super.onLoad();
        int left = this.getPopupLeft();
        int top = this.getPopupTop();
        int width = this.getOffsetWidth();
        int height = this.getOffsetHeight();
        boolean changed = false;
        if (left + width > Window.getClientWidth()) {
            left -= width;
            changed = true;
        }
        if (top + height > Window.getClientHeight()) {
            top -= height;
            changed = true;
        }
        if (changed) {
            this.setPopupPosition(left, top);
        }
    }
}

